/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.config.InterfaceConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.config.SoapuiProjectDocumentConfig;
import com.eviware.soapui.config.TestSuiteConfig;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.WSToolsJava2WsdlAction;
import com.eviware.soapui.impl.wsdl.actions.project.AddInterfaceActionFromFile;
import com.eviware.soapui.impl.wsdl.actions.project.AddInterfaceActionFromURL;
import com.eviware.soapui.impl.wsdl.actions.project.AddNewMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.project.AddNewTestSuiteAction;
import com.eviware.soapui.impl.wsdl.actions.project.ReloadProjectAction;
import com.eviware.soapui.impl.wsdl.actions.project.RemoveProjectAction;
import com.eviware.soapui.impl.wsdl.actions.project.RenameProjectAction;
import com.eviware.soapui.impl.wsdl.actions.project.SaveProjectAction;
import com.eviware.soapui.impl.wsdl.actions.project.SaveProjectAsAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlImporter;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.ProjectListener;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlProject
extends AbstractWsdlModelItem<ProjectConfig>
implements Project {
    private WorkspaceImpl workspace;
    private String path;
    private List<WsdlInterface> interfaces = new ArrayList<WsdlInterface>();
    private List<WsdlTestSuite> testSuites = new ArrayList<WsdlTestSuite>();
    private List<WsdlMockService> mockServices = new ArrayList<WsdlMockService>();
    private Set<ProjectListener> listeners = new HashSet<ProjectListener>();
    private SoapuiProjectDocumentConfig projectDocument;
    private ImageIcon disabledIcon;
    private long lastModified;
    private static final Logger log = Logger.getLogger(WsdlProject.class);

    public WsdlProject() throws XmlException, IOException {
        this((WorkspaceImpl)null);
    }

    public WsdlProject(String path) throws XmlException, IOException, SoapUIException {
        this(path, null);
    }

    public WsdlProject(WorkspaceImpl workspace) throws XmlException, IOException {
        super(null, workspace, "/project.gif");
        this.workspace = workspace;
        this.projectDocument = SoapuiProjectDocumentConfig.Factory.newInstance();
        this.setConfig(this.projectDocument.addNewSoapuiProject());
        this.initActions();
    }

    public WsdlProject(String path, WorkspaceImpl workspace) throws SoapUIException {
        this(path, workspace, true);
    }

    public WsdlProject(String path, WorkspaceImpl workspace, boolean create) throws SoapUIException {
        super(null, workspace, "/project.gif");
        this.workspace = workspace;
        this.path = path;
        File file = new File(path);
        if (file.exists()) {
            this.loadProject(file);
        } else if (create) {
            this.projectDocument = SoapuiProjectDocumentConfig.Factory.newInstance();
            this.setConfig(this.projectDocument.addNewSoapuiProject());
        } else {
            this.disabledIcon = UISupport.createImageIcon("/disabledProject.gif");
        }
        this.setProjectRoot(path);
        this.initActions();
    }

    private void loadProject(File file) throws SoapUIException {
        try {
            this.lastModified = file.lastModified();
            this.projectDocument = SoapuiProjectDocumentConfig.Factory.parse((File)file);
        }
        catch (Exception e) {
            throw new SoapUIException("Failed to create project from file [" + file.getName() + "]", e);
        }
        this.setConfig(this.projectDocument.getSoapuiProject());
        if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
            this.removeDefinitionCaches(this.projectDocument);
        }
        log.info((Object)("Loaded project from [" + file.getAbsolutePath() + "]"));
        List interfaceConfigs = ((ProjectConfig)this.getConfig()).getInterfaceList();
        for (InterfaceConfig config : interfaceConfigs) {
            this.interfaces.add(new WsdlInterface(this, config));
        }
        List testSuiteConfigs = ((ProjectConfig)this.getConfig()).getTestSuiteList();
        for (TestSuiteConfig config : testSuiteConfigs) {
            this.testSuites.add(new WsdlTestSuite(this, config));
        }
        List mockServiceConfigs = ((ProjectConfig)this.getConfig()).getMockServiceList();
        for (MockServiceConfig config : mockServiceConfigs) {
            this.mockServices.add(new WsdlMockService(this, config));
        }
    }

    private void setProjectRoot(String path) {
        int ix;
        if (path != null && this.projectDocument != null && (ix = path.lastIndexOf(File.separatorChar)) > 0) {
            this.getSettings().setString(ProjectSettings.PROJECT_ROOT, path.substring(0, ix));
        }
    }

    @Override
    public ImageIcon getIcon() {
        if (this.projectDocument != null) {
            return super.getIcon();
        }
        return this.disabledIcon;
    }

    @Override
    public String getName() {
        if (this.projectDocument != null) {
            return super.getName();
        }
        int ix = this.path.lastIndexOf(File.separatorChar);
        String name = ix == -1 ? this.path : this.path.substring(ix + 1);
        return name + " (disabled)";
    }

    @Override
    public String getDescription() {
        return this.projectDocument == null ? this.getName() : super.getDescription();
    }

    private void initActions() {
        if (this.projectDocument == null) {
            this.addAction(new ReloadProjectAction(this));
            this.addAction(new RemoveProjectAction(this));
            this.addAction(ActionSupport.SEPARATOR_ACTION);
            this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects.html#soapui_WSDL_Projects"));
        } else {
            this.addAction(new AddInterfaceActionFromURL(this));
            this.addAction(new AddInterfaceActionFromFile(this));
            this.addAction(ActionSupport.SEPARATOR_ACTION);
            this.addAction(new WSToolsJava2WsdlAction(this));
            this.addAction(ActionSupport.SEPARATOR_ACTION);
            this.addAction(new AddNewTestSuiteAction(this));
            this.addAction(new AddNewMockServiceAction(this));
            this.addAction(ActionSupport.SEPARATOR_ACTION);
            this.addAction(new RenameProjectAction(this));
            this.addAction(new RemoveProjectAction(this));
            this.addAction(new ReloadProjectAction(this));
            this.addAction(ActionSupport.SEPARATOR_ACTION);
            this.addAction(new SaveProjectAction(this));
            this.addAction(new SaveProjectAsAction(this));
            this.addAction(ActionSupport.SEPARATOR_ACTION);
            this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects.html#soapui_WSDL_Projects"));
        }
    }

    @Override
    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    @Override
    public WsdlInterface getInterfaceAt(int index) {
        return this.interfaces.get(index);
    }

    @Override
    public WsdlInterface getInterfaceByName(String interfaceName) {
        return (WsdlInterface)this.getWsdlModelItemByName(this.interfaces, interfaceName);
    }

    public WsdlInterface getInterfaceByBindingName(QName bindingName) {
        for (int c = 0; c < this.getInterfaceCount(); ++c) {
            if (!this.getInterfaceAt(c).getBindingName().equals(bindingName)) continue;
            return this.getInterfaceAt(c);
        }
        return null;
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaces.size();
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean save() throws IOException {
        if (this.projectDocument == null) {
            return true;
        }
        if (this.path == null) {
            File file = UISupport.getFileDialogs().saveAs(this, "Save project " + this.getName());
            if (file == null) {
                return false;
            }
            this.path = file.getAbsolutePath();
        }
        File projectFile = new File(this.path);
        while (projectFile.exists() && !projectFile.canWrite()) {
            if (UISupport.confirm("Project file [" + this.path + "] can not be written to, save to new file?", "Save Project")) {
                projectFile = UISupport.getFileDialogs().saveAs(this, "Save project " + this.getName());
                if (projectFile == null) {
                    return false;
                }
                this.path = projectFile.getAbsolutePath();
                continue;
            }
            return false;
        }
        if (projectFile.exists() && this.lastModified != 0L && this.lastModified < projectFile.lastModified() && !UISupport.confirm("Project file for [" + this.getName() + "] has been modified externally, overwrite?", "Save Project")) {
            return false;
        }
        long size = 0L;
        if (projectFile.exists() && this.getSettings().getBoolean(UISettings.CREATE_BACKUP)) {
            this.createBackup(projectFile);
        }
        if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
            SoapuiProjectDocumentConfig config = (SoapuiProjectDocumentConfig)this.projectDocument.copy();
            this.removeDefinitionCaches(config);
            config.getSoapuiProject().setSoapuiVersion("1.7.1");
            config.save(projectFile);
        } else {
            try {
                this.projectDocument.getSoapuiProject().setSoapuiVersion("1.7.1");
                ByteArrayOutputStream writer = new ByteArrayOutputStream(8192);
                this.projectDocument.save((OutputStream)writer);
                FileOutputStream out = new FileOutputStream(projectFile);
                writer.writeTo(out);
                out.close();
                size = writer.size();
            }
            catch (Throwable t) {
                t.printStackTrace();
                UISupport.showErrorMessage("Failed to save project [" + this.getName() + "]: " + t.toString());
                return false;
            }
        }
        this.lastModified = projectFile.lastModified();
        log.info((Object)("Saved project [" + this.getName() + "] to [" + projectFile.getAbsolutePath() + " - " + size + " bytes"));
        this.setProjectRoot(this.path);
        return true;
    }

    private void createBackup(File projectFile) throws IOException {
        String backupFolderName = this.getSettings().getString(UISettings.BACKUP_FOLDER, "");
        File backupFolder = new File(backupFolderName);
        if (!backupFolder.isAbsolute()) {
            backupFolder = new File(projectFile.getParentFile(), backupFolderName);
        }
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        File backupFile = new File(backupFolder, projectFile.getName() + ".backup");
        log.info((Object)("Backing up [" + projectFile + "] to [" + backupFile + "]"));
        Tools.copyFile(projectFile, backupFile, true);
    }

    private void removeDefinitionCaches(SoapuiProjectDocumentConfig config) {
        for (InterfaceConfig ifaceConfig : config.getSoapuiProject().getInterfaceList()) {
            if (!ifaceConfig.isSetDefinitionCache()) continue;
            log.info((Object)("Removing definition cache from interface [" + ifaceConfig.getName() + "]"));
            ifaceConfig.unsetDefinitionCache();
        }
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests) throws SoapUIException {
        return this.importWsdl(url, createRequests, null, null);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, WsdlLoader wsdlLoader) throws SoapUIException {
        return this.importWsdl(url, createRequests, null, wsdlLoader);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, QName bindingName) throws SoapUIException {
        return this.importWsdl(url, createRequests, bindingName, null);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, QName bindingName, WsdlLoader wsdlLoader) throws SoapUIException {
        WsdlInterface[] result;
        if (this.projectDocument == null) {
            return null;
        }
        try {
            result = WsdlImporter.getInstance().importWsdl(this, url, bindingName, wsdlLoader);
        }
        catch (Exception e) {
            log.error((Object)("Error importing wsdl: " + e));
            e.printStackTrace();
            throw new SoapUIException("Error importing wsdl", e);
        }
        try {
            if (createRequests && result != null) {
                for (WsdlInterface iface : result) {
                    for (int c = 0; c < iface.getOperationCount(); ++c) {
                        WsdlOperation operation = iface.getOperationAt(c);
                        WsdlRequest request = operation.addNewRequest("Request 1");
                        try {
                            request.setRequestContent(operation.createRequest(true));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error creating requests: " + e.getMessage()));
            throw new SoapUIException("Error creating requests", e);
        }
        return result;
    }

    public WsdlInterface addNewInterface(String name) {
        WsdlInterface iface = new WsdlInterface(this, ((ProjectConfig)this.getConfig()).addNewInterface());
        iface.setName(name);
        this.interfaces.add(iface);
        this.fireInterfaceAdded(iface);
        return iface;
    }

    @Override
    public void addProjectListener(ProjectListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProjectListener(ProjectListener listener) {
        this.listeners.remove(listener);
    }

    public void fireInterfaceAdded(WsdlInterface iface) {
        ProjectListener[] a = this.listeners.toArray(new ProjectListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].interfaceAdded(iface);
        }
    }

    public void fireInterfaceRemoved(WsdlInterface iface) {
        ProjectListener[] a = this.listeners.toArray(new ProjectListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].interfaceRemoved(iface);
        }
    }

    public void fireTestSuiteAdded(WsdlTestSuite testSuite) {
        ProjectListener[] a = this.listeners.toArray(new ProjectListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testSuiteAdded(testSuite);
        }
    }

    public void fireTestSuiteRemoved(WsdlTestSuite testSuite) {
        ProjectListener[] a = this.listeners.toArray(new ProjectListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testSuiteRemoved(testSuite);
        }
    }

    public void fireMockServiceAdded(WsdlMockService mockService) {
        ProjectListener[] a = this.listeners.toArray(new ProjectListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].mockServiceAdded(mockService);
        }
    }

    public void fireMockServiceRemoved(WsdlMockService mockService) {
        ProjectListener[] a = this.listeners.toArray(new ProjectListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].mockServiceRemoved(mockService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterface(WsdlInterface iface) {
        int ix = this.interfaces.indexOf(iface);
        this.interfaces.remove(ix);
        try {
            this.fireInterfaceRemoved(iface);
        }
        finally {
            iface.release();
            ((ProjectConfig)this.getConfig()).removeInterface(ix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestSuite(WsdlTestSuite testSuite) {
        int ix = this.testSuites.indexOf(testSuite);
        this.testSuites.remove(ix);
        try {
            this.fireTestSuiteRemoved(testSuite);
        }
        finally {
            testSuite.release();
            ((ProjectConfig)this.getConfig()).removeTestSuite(ix);
        }
    }

    public boolean isDisabled() {
        return this.projectDocument == null;
    }

    @Override
    public int getTestSuiteCount() {
        return this.testSuites.size();
    }

    @Override
    public WsdlTestSuite getTestSuiteAt(int index) {
        return this.testSuites.get(index);
    }

    @Override
    public WsdlTestSuite getTestSuiteByName(String testSuiteName) {
        return (WsdlTestSuite)this.getWsdlModelItemByName(this.testSuites, testSuiteName);
    }

    @Override
    public WsdlTestSuite addNewTestSuite(String name) {
        WsdlTestSuite testSuite = new WsdlTestSuite(this, ((ProjectConfig)this.getConfig()).addNewTestSuite());
        testSuite.setName(name);
        this.testSuites.add(testSuite);
        this.fireTestSuiteAdded(testSuite);
        return testSuite;
    }

    public WsdlTestSuite cloneTestSuite(WsdlTestSuite testSuite, String name) {
        TestSuiteConfig testSuiteConfig = ((ProjectConfig)this.getConfig()).addNewTestSuite();
        testSuiteConfig.set(testSuite.getConfig());
        WsdlTestSuite newTestSuite = new WsdlTestSuite(this, testSuiteConfig);
        newTestSuite.setName(name);
        this.testSuites.add(newTestSuite);
        this.fireTestSuiteAdded(newTestSuite);
        return newTestSuite;
    }

    public boolean isCacheDefinitions() {
        return this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS);
    }

    public void setCacheDefinitions(boolean cacheDefinitions) {
        this.getSettings().setBoolean(WsdlSettings.CACHE_WSDLS, cacheDefinitions);
    }

    public boolean saveTo(String fileName) throws IOException {
        String oldPath = this.path;
        this.path = fileName;
        boolean result = this.save();
        if (!result) {
            this.path = oldPath;
        }
        this.setProjectRoot(this.path);
        return result;
    }

    @Override
    public void release() {
        super.release();
        for (WsdlTestSuite testSuite : this.testSuites) {
            testSuite.release();
        }
        for (WsdlInterface iface : this.interfaces) {
            iface.release();
        }
        for (WsdlMockService mockService : this.mockServices) {
            mockService.release();
        }
    }

    public WsdlMockService cloneMockService(WsdlMockService mockService, String name) {
        MockServiceConfig testSuiteConfig = ((ProjectConfig)this.getConfig()).addNewMockService();
        testSuiteConfig.set(mockService.getConfig());
        WsdlMockService newMockService = new WsdlMockService(this, testSuiteConfig);
        newMockService.setName(name);
        this.mockServices.add(newMockService);
        this.fireMockServiceAdded(newMockService);
        return newMockService;
    }

    @Override
    public WsdlMockService addNewMockService(String name) {
        WsdlMockService mockService = new WsdlMockService(this, ((ProjectConfig)this.getConfig()).addNewMockService());
        mockService.setName(name);
        this.mockServices.add(mockService);
        this.fireMockServiceAdded(mockService);
        return mockService;
    }

    @Override
    public WsdlMockService getMockServiceAt(int index) {
        return this.mockServices.get(index);
    }

    @Override
    public WsdlMockService getMockServiceByName(String mockServiceName) {
        return (WsdlMockService)this.getWsdlModelItemByName(this.mockServices, mockServiceName);
    }

    @Override
    public int getMockServiceCount() {
        return this.mockServices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMockService(WsdlMockService mockService) {
        int ix = this.mockServices.indexOf(mockService);
        this.mockServices.remove(ix);
        try {
            this.fireMockServiceRemoved(mockService);
        }
        finally {
            mockService.release();
            ((ProjectConfig)this.getConfig()).removeMockService(ix);
        }
    }

    @Override
    public List<TestSuite> getTestSuites() {
        return new ArrayList<TestSuite>(this.testSuites);
    }

    @Override
    public List<MockService> getMockServices() {
        return new ArrayList<MockService>(this.mockServices);
    }

    public List<Interface> getInterfaces() {
        return new ArrayList<Interface>(this.interfaces);
    }

    public void reload(File file) throws SoapUIException {
        this.path = file.getAbsolutePath();
        this.getWorkspace().reloadProject(this);
    }

    @Override
    public boolean hasNature(String natureId) {
        Settings projectSettings = this.getSettings();
        String projectNature = projectSettings.getString(ProjectSettings.PROJECT_NATURE, null);
        return natureId.equals(projectNature);
    }
}

