/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.dependencies.JCAInflowAdapterMBean;
import org.jboss.soa.esb.listeners.jca.ActivationBridge;
import org.jboss.soa.esb.listeners.jca.EndpointContainer;
import org.jboss.soa.esb.listeners.jca.EndpointFactory;
import org.jboss.soa.esb.listeners.jca.JBoss42ActivationBridge;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCAInflowAdapter
extends ServiceMBeanSupport
implements JCAInflowAdapterMBean {
    private static final Logger LOGGER = Logger.getLogger(JCAInflowAdapter.class);
    private String messagingInterface;
    private String beanType;
    private String adapter;
    private boolean isTransacted = true;
    private String activationBridge;
    private Properties activationSpec;
    private String description;
    private ActivationBridge bridge;

    @Override
    public void setMessagingInterface(String messagingInterface) {
        this.messagingInterface = messagingInterface;
    }

    @Override
    public String getMessagingInterface() {
        return this.messagingInterface;
    }

    @Override
    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    @Override
    public String getBeanType() {
        return this.beanType;
    }

    @Override
    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    @Override
    public String getAdapter() {
        return this.adapter;
    }

    @Override
    public void setIsTransacted(boolean isTransacted) {
        this.isTransacted = isTransacted;
    }

    @Override
    public boolean getIsTransacted() {
        return this.isTransacted;
    }

    @Override
    public void setActivationBridge(String activationBridge) {
        this.activationBridge = activationBridge;
    }

    @Override
    public String getActivationBridge() {
        return this.activationBridge;
    }

    @Override
    public void setActivationSpec(Properties activationSpec) {
        this.activationSpec = activationSpec;
    }

    @Override
    public Properties getActivationSpec() {
        return this.activationSpec;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void createService() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.beanType == null) {
            throw new IllegalArgumentException("BeanType must be specified");
        }
        if (this.adapter == null) {
            throw new IllegalArgumentException("Adapter name must be specified");
        }
        if (this.activationSpec == null) {
            throw new IllegalArgumentException("Activation specification properties must be specified");
        }
        Class<?> beanClass = classLoader.loadClass(this.beanType);
        Class<?> messagingClass = this.messagingInterface != null ? classLoader.loadClass(this.messagingInterface) : this.findMessagingClass(beanClass);
        this.bridge = this.activationBridge != null ? (ActivationBridge)classLoader.loadClass(this.activationBridge).newInstance() : new JBoss42ActivationBridge();
        final Object bean = beanClass.newInstance();
        final String inflowDescription = this.description != null ? this.description : "Message Inflow";
        final String inflowAdapter = this.adapter;
        final boolean transacted = this.isTransacted;
        EndpointContainer container = new EndpointContainer(){

            public String getDescription() {
                return inflowDescription + " jca adapter: " + inflowAdapter;
            }

            public Object invoke(Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(bean, args);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }

            public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
                return transacted;
            }
        };
        Map<String, String> activationProperties = this.getActivationProperties();
        EndpointFactory mef = new EndpointFactory();
        mef.setContainer(container);
        mef.setLoader(classLoader);
        mef.setMessagingType(messagingClass);
        mef.start();
        this.bridge.setActivationProperties(activationProperties);
        this.bridge.setAdapter(this.adapter);
        this.bridge.setMessageEndpointFactory(mef);
        this.bridge.setMessagingTypeClass(messagingClass);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Created JCA Inflow bridge " + this.getServiceName() + ", messagingClass: " + messagingClass + ", bean: " + bean + ", activationProperties: " + activationProperties));
        }
    }

    protected void startService() throws Exception {
        this.bridge.activate();
    }

    protected void stopService() throws Exception {
        this.bridge.deactivate();
    }

    private Class<?> findMessagingClass(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            throw new IllegalArgumentException("Unable to guess MessagingClass interface, specify this explicity");
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<?> type = null;
        for (Class<?> intf : interfaces) {
            if (type != null) {
                throw new IllegalArgumentException("Unable to guess MessagingClass interface as the base class implements too many interfaces, specify this explicity");
            }
            type = intf;
        }
        if (type == null) {
            type = this.findMessagingClass(clazz.getSuperclass());
        }
        return type;
    }

    private Map<String, String> getActivationProperties() {
        HashMap<String, String> activationProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.activationSpec.entrySet()) {
            activationProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return activationProperties;
    }
}

