/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.FtpImpl;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.FTPSEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.util.RemoteFileSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpsImpl
extends FtpImpl {
    private static final Logger _logger = Logger.getLogger(FtpsImpl.class);
    private URI m_oCertificate;
    private String m_oCertificateName;

    public FtpsImpl(ConfigTree p_oP, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        super(p_oP, p_bConnect);
    }

    public FtpsImpl(FTPSEpr p_oP, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        super(p_oP);
        try {
            this.m_oCertificate = p_oP.getCertificateURI();
        }
        catch (URISyntaxException urise) {
            _logger.warn((Object)urise);
        }
        this.m_oCertificateName = p_oP.getCertificateName();
        this.configTreeFromEpr();
        this.initialize(p_bConnect);
    }

    public FtpsImpl(List<KeyValuePair> p_oAttribs, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        super(p_oAttribs, p_bConnect);
    }

    @Override
    protected void configTreeFromEpr() throws RemoteFileSystemException {
        super.configTreeFromEpr();
        try {
            if (this.m_oCertificate != null) {
                this.m_oParms.setAttribute("certificate", this.m_oCertificate.toString());
            }
            if (this.m_oCertificateName != null) {
                this.m_oParms.setAttribute("certificateName", this.m_oCertificateName);
            }
        }
        catch (Exception e) {
            throw new RemoteFileSystemException(e);
        }
    }

    @Override
    protected void checkParms() throws ConfigurationException {
        super.checkParms();
        String certificate = this.m_oParms.getAttribute("certificate");
        if (certificate != null) {
            try {
                this.m_oCertificate = new URI(certificate);
            }
            catch (URISyntaxException ex) {
                throw new ConfigurationException("Failed to create certificate URI", ex);
            }
        }
        this.m_oCertificateName = this.m_oParms.getAttribute("certificateName");
    }

    @Override
    protected FTPClient instantiateClient() throws RemoteFileSystemException {
        FTPSClient ftpsClient;
        try {
            ftpsClient = new FTPSClient();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RemoteFileSystemException(nsae);
        }
        try {
            ftpsClient.setTrustManager((TrustManager)new ESBTrustManager(this.m_oCertificate));
        }
        catch (Exception ex) {
            throw new RemoteFileSystemException("Exception creating trust manager", ex);
        }
        return ftpsClient;
    }

    @Override
    protected void connect() throws IOException {
        super.connect();
        FTPSClient ftpsClient = (FTPSClient)this.m_oConn;
        ftpsClient.enterLocalPassiveMode();
        ftpsClient.execPBSZ(0L);
        ftpsClient.execPROT("P");
    }

    private static final class ESBTrustManager
    implements X509TrustManager {
        private final X509Certificate[] certificates;
        private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ESBTrustManager(URI certificate) throws URISyntaxException, MalformedURLException, IOException, CertificateException {
            if (certificate != null) {
                InputStream is;
                if (certificate.isAbsolute()) {
                    is = certificate.toURL().openStream();
                } else {
                    File file = new File(certificate);
                    is = file.toURL().openStream();
                }
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    BufferedInputStream bis = new BufferedInputStream(is);
                    DataInputStream dis = new DataInputStream(bis);
                    if (dis.available() > 0) {
                        do {
                            dis.mark(BEGIN_CERTIFICATE.length() * 2);
                            String line = dis.readLine();
                            if (!BEGIN_CERTIFICATE.equals(line)) continue;
                            dis.reset();
                            break;
                        } while (dis.available() > 0);
                        if (dis.available() > 0) {
                            X509Certificate cert = (X509Certificate)cf.generateCertificate(dis);
                            certificates.add(cert);
                        }
                    }
                    this.certificates = certificates.toArray(new X509Certificate[certificates.size()]);
                }
                finally {
                    is.close();
                }
            } else {
                this.certificates = null;
            }
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            int numCerts = chain == null ? 0 : chain.length;
            for (int count = 0; count < numCerts; ++count) {
                X509Certificate cert = chain[count];
                cert.checkValidity();
                this.verify(cert);
            }
        }

        private void verify(X509Certificate cert) throws CertificateException {
            int numCertificates;
            int n = numCertificates = this.certificates == null ? 0 : this.certificates.length;
            if (numCertificates > 0) {
                for (int count = 0; count < numCertificates; ++count) {
                    try {
                        cert.verify(this.certificates[count].getPublicKey());
                        return;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
                throw new CertificateException("Failed to verify certificate");
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.certificates;
        }
    }
}

