/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.monitoring;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.monitoring.MVELMonitor;
import org.jboss.soa.esb.actions.monitoring.MonitoringPatternBean;
import org.jboss.soa.esb.actions.scripting.ScriptingAction;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.mapping.ObjectMapper;
import org.jboss.soa.esb.message.mapping.ObjectMappingException;

public class MVELMonitoringAction
extends AbstractActionPipelineProcessor {
    public static final String MONITOR_VALUE = "monitor-value";
    public static final String MVEL_PATTERN = "mvel-pattern";
    public static final String PATTERN_NAME = "pattern-name";
    public static final String PATTERN_CONDITIONAL = "pattern-conditional";
    private static final String BEANSHELL_VARIABLE = "beanshellVar";
    private MVELMonitor mvelMonitor;
    ArrayList<MonitoringPatternBean> list = null;
    private static Logger logger = Logger.getLogger(ScriptingAction.class);
    protected ConfigTree _config;

    public MVELMonitoringAction(ConfigTree config) {
        this._config = config;
        ConfigTree[] configTree = this._config.getChildren(MONITOR_VALUE);
        if (null == configTree || configTree.length < 1) {
            logger.warn((Object)"Missing or empty destination list - This action class won't have any effect");
            return;
        }
        this.list = new ArrayList();
        for (ConfigTree curr : configTree) {
            try {
                String pattern = curr.getAttribute(MVEL_PATTERN, "");
                String name = curr.getAttribute(PATTERN_NAME, "");
                String conditional = curr.getAttribute(PATTERN_CONDITIONAL, "");
                this.list.add(new MonitoringPatternBean(pattern, name, conditional));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mvelMonitor = new MVELMonitor(config);
        try {
            this.mvelMonitor.registerMBean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Message process(Message message) throws ActionProcessingException {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                MonitoringPatternBean mpb = this.list.get(i);
                String object = null;
                ObjectMapper mapper = new ObjectMapper();
                try {
                    object = (String)mapper.getObjectFromMessage(message, mpb.getPattern());
                    Interpreter inter = new Interpreter();
                    inter.eval("beanshellVar = " + object + mpb.getConditional());
                    Boolean b = (Boolean)inter.get(BEANSHELL_VARIABLE);
                    if (!b.booleanValue()) continue;
                    this.mvelMonitor.addEvent(message, mpb);
                    continue;
                }
                catch (ObjectMappingException e1) {
                    throw new ActionProcessingException(e1);
                }
                catch (EvalError e) {
                    throw new ActionProcessingException(e);
                }
            }
        }
        return message;
    }
}

