/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers.persist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcCleanConn {
    private DataSource m_oDS = null;
    private Connection m_conn = null;
    private boolean transactional = false;
    protected List<PreparedStatement> m_olPrepSt = new ArrayList<PreparedStatement>();
    protected Logger m_oLogger;

    public JdbcCleanConn(DataSource p_oDS) {
        this(p_oDS, false);
    }

    public JdbcCleanConn(DataSource p_oDS, boolean transactional) {
        this.m_oDS = p_oDS;
        this.m_oLogger = Logger.getLogger(this.getClass());
        this.transactional = transactional;
    }

    public void commit() throws SQLException {
        if (null == this.m_conn || this.transactional) {
            throw new SQLException("Connection is null!");
        }
        this.m_conn.commit();
    }

    public void rollback() throws SQLException {
        if (null == this.m_conn || this.transactional) {
            throw new SQLException("Connection is null");
        }
        this.m_conn.rollback();
    }

    public List<PreparedStatement> getStatements() {
        return this.m_olPrepSt;
    }

    public void release() {
        if (null != this.m_conn) {
            if (!this.transactional) {
                try {
                    this.m_conn.rollback();
                }
                catch (Exception eRoll) {
                    // empty catch block
                }
            }
            for (PreparedStatement PS : this.m_olPrepSt) {
                try {
                    PS.close();
                }
                catch (Exception exception) {}
            }
            try {
                this.m_conn.close();
            }
            catch (Exception exception) {}
        } else {
            this.m_oLogger.debug((Object)"Connection is null.");
        }
        this.m_olPrepSt.clear();
        this.m_conn = null;
    }

    public PreparedStatement prepareStatement(String p_sSt, int p_i1, int p_i2) throws SQLException {
        if (null == this.m_conn) {
            this.connect();
            if (this.m_conn == null) {
                throw new SQLException("Connection is null!");
            }
        }
        PreparedStatement PS = this.m_conn.prepareStatement(p_sSt, p_i1, p_i2);
        this.m_olPrepSt.add(PS);
        return PS;
    }

    public PreparedStatement prepareStatement(String p_sSt) throws SQLException {
        if (null == this.m_conn) {
            this.connect();
            if (this.m_conn == null) {
                throw new SQLException("Connection is null!");
            }
        }
        PreparedStatement PS = this.m_conn.prepareStatement(p_sSt);
        this.m_olPrepSt.add(PS);
        return PS;
    }

    public ResultSet execQueryWait(PreparedStatement p_PS, int p_iQtry) throws SQLException {
        if (null == this.m_conn) {
            this.connect();
            if (this.m_conn == null) {
                throw new SQLException("Connection is null!");
            }
        }
        if (p_PS == null) {
            throw new SQLException("Null PreparedStatement!");
        }
        SQLException eRet = null;
        int iQtry = p_iQtry < 1 ? 1 : (p_iQtry < 50 ? p_iQtry : 50);
        for (int i1 = 0; i1 < iQtry; ++i1) {
            try {
                return p_PS.executeQuery();
            }
            catch (SQLException e) {
                if (null == eRet) {
                    eRet = e;
                }
                try {
                    Thread.sleep(100L + (long)(100.0 * Math.random()));
                }
                catch (InterruptedException ex) {
                    this.m_oLogger.debug((Object)"Thread interrupted.", (Throwable)ex);
                }
                this.release();
                this.m_conn = null;
                continue;
            }
        }
        this.m_oLogger.debug((Object)"execQueryWait() FAILED", eRet);
        throw eRet;
    }

    public int execUpdWait(PreparedStatement p_PS, int p_iQtry) throws SQLException {
        if (null == this.m_conn) {
            this.connect();
            if (this.m_conn == null) {
                throw new SQLException("Connection is null!");
            }
        }
        if (p_PS == null) {
            throw new SQLException("Null PreparedStatement!");
        }
        SQLException eRet = null;
        int iQtry = p_iQtry < 1 ? 1 : (p_iQtry < 50 ? p_iQtry : 50);
        for (int i1 = 0; i1 < iQtry; ++i1) {
            try {
                return p_PS.executeUpdate();
            }
            catch (SQLException e) {
                if (null == eRet) {
                    eRet = e;
                }
                try {
                    Thread.sleep(100L + (long)(100.0 * Math.random()));
                }
                catch (InterruptedException ex) {
                    this.m_oLogger.debug((Object)"Thread interrupted.", (Throwable)ex);
                }
                this.release();
                this.m_conn = null;
                continue;
            }
        }
        this.m_oLogger.debug((Object)"execUpdWait() FAILED", eRet);
        throw eRet;
    }

    private void connect() throws SQLException {
        if (this.m_conn != null) {
            return;
        }
        if (this.m_oDS == null) {
            throw new SQLException("DataSource is null!");
        }
        SQLException eRet = null;
        for (int i1 = 0; i1 < 5; ++i1) {
            try {
                this.m_conn = this.m_oDS.getConnection();
                eRet = null;
                break;
            }
            catch (SQLException e) {
                if (null == eRet) {
                    eRet = e;
                }
                try {
                    Thread.sleep(2000L + (long)(100.0 * Math.random()));
                }
                catch (InterruptedException ex) {
                    this.m_oLogger.debug((Object)"Thread interrupted.", (Throwable)ex);
                }
                continue;
            }
        }
        if (eRet != null) {
            this.m_oLogger.debug((Object)"connect() FAILED", eRet);
            throw eRet;
        }
        if (this.m_conn == null) {
            throw new RuntimeException("connect() FAILED: no connection");
        }
        if (!this.transactional) {
            this.m_conn.setAutoCommit(false);
            this.m_conn.setTransactionIsolation(8);
        }
        this.m_olPrepSt.clear();
    }
}

