/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.publish.ContractPublisher;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.publish.Publisher;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePublisher {
    private String serviceName;
    private String category;
    private String description;
    private Publisher publisher;
    private static Map<ManagedLifecycleController, Map<Service, List<ServicePublisher>>> SERVICE_PUBLISHERS = new LinkedHashMap<ManagedLifecycleController, Map<Service, List<ServicePublisher>>>();

    public ServicePublisher(String name, String category, Publisher publisher) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNullAndNotEmpty(category, "category");
        this.serviceName = name;
        this.category = category;
        this.publisher = publisher;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getCategory() {
        return this.category;
    }

    public ContractPublisher getContractPublisher() {
        return this.publisher instanceof ContractPublisher ? (ContractPublisher)this.publisher : null;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    private static void addPublisher(Map<Service, List<ServicePublisher>> servicePublishers, Service service, ServicePublisher publisher) {
        List<ServicePublisher> publishers = servicePublishers.get(service);
        if (publishers != null) {
            publishers.add(publisher);
        } else {
            ArrayList<ServicePublisher> newPublishers = new ArrayList<ServicePublisher>();
            newPublishers.add(publisher);
            servicePublishers.put(service, newPublishers);
        }
    }

    public static synchronized void addServicePublishers(ManagedLifecycleController controller, Map<Service, List<ServicePublisher>> publishers) {
        Map<Service, List<ServicePublisher>> currentMap = SERVICE_PUBLISHERS.get(controller);
        if (currentMap != null) {
            for (Map.Entry<Service, List<ServicePublisher>> entry : publishers.entrySet()) {
                Service service = entry.getKey();
                List<ServicePublisher> currentList = currentMap.get(service);
                if (currentList != null) {
                    currentList.addAll((Collection<ServicePublisher>)entry.getValue());
                    continue;
                }
                currentMap.put(service, entry.getValue());
            }
        } else {
            SERVICE_PUBLISHERS.put(controller, publishers);
        }
    }

    public static synchronized List<ServicePublisher> getServicePublishers() {
        ArrayList<ServicePublisher> publishers = new ArrayList<ServicePublisher>();
        Collection<Map<Service, List<ServicePublisher>>> allPublishers = SERVICE_PUBLISHERS.values();
        for (Map<Service, List<ServicePublisher>> servicePublishers : allPublishers) {
            for (List<ServicePublisher> curPublisherList : servicePublishers.values()) {
                publishers.addAll(curPublisherList);
            }
        }
        return publishers;
    }

    public static synchronized void removeServicePublishers(ManagedLifecycleController controller) {
        SERVICE_PUBLISHERS.remove(controller);
    }

    public static synchronized void addContractReferencePublishers(ManagedLifecycleController controller, List<? extends ContractReferencePublisher> publishers) {
        if (publishers != null) {
            LinkedHashMap<Service, List<ServicePublisher>> servicePublishers = new LinkedHashMap<Service, List<ServicePublisher>>();
            for (ContractReferencePublisher contractReferencePublisher : publishers) {
                Service service = contractReferencePublisher.getService();
                ServicePublisher servicePublisher = new ServicePublisher(service.getName(), service.getCategory(), contractReferencePublisher);
                servicePublisher.setDescription(contractReferencePublisher.getDescription());
                ServicePublisher.addPublisher(servicePublishers, service, servicePublisher);
            }
            ServicePublisher.addServicePublishers(controller, servicePublishers);
        }
    }

    public static synchronized List<Service> getServices() {
        LinkedHashSet<Service> services = new LinkedHashSet<Service>();
        Collection<Map<Service, List<ServicePublisher>>> allPublishers = SERVICE_PUBLISHERS.values();
        for (Map<Service, List<ServicePublisher>> servicePublishers : allPublishers) {
            services.addAll(servicePublishers.keySet());
        }
        return new ArrayList<Service>(services);
    }

    public static synchronized List<ServicePublisher> getServicePublishers(Service service) {
        ArrayList<ServicePublisher> publishers = new ArrayList<ServicePublisher>();
        Collection<Map<Service, List<ServicePublisher>>> allPublishers = SERVICE_PUBLISHERS.values();
        for (Map<Service, List<ServicePublisher>> servicePublishers : allPublishers) {
            List<ServicePublisher> curPublisherList = servicePublishers.get(service);
            if (curPublisherList == null) continue;
            publishers.addAll(curPublisherList);
        }
        return publishers;
    }
}

