/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import java.io.File;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers120.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FsBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FsMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FsProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Listener;
import org.jboss.soa.esb.listeners.gateway.FileGatewayListener;
import org.w3c.dom.Element;

public class FsListenerMapper {
    public static Element map(Element root, FsListenerDocument.FsListener listener, XMLBeansModel model) throws ConfigurationException {
        FsProviderDocument.FsProvider provider;
        FsBusDocument.FsBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (FsBusDocument.FsBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <fs-listener> must reference a <fs-bus>.");
        }
        try {
            provider = (FsProviderDocument.FsProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <fs-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        FsMessageFilterDocument.FsMessageFilter messageFilter = listener.getFsMessageFilter();
        if (messageFilter == null && (messageFilter = bus.getFsMessageFilter()) == null) {
            throw new ConfigurationException("No <fs-detination> defined on either <fs-listener> [" + listener.getName() + "] or <fs-bus> [" + bus.getBusid() + "].");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("gatewayClass", FileGatewayListener.class.getName());
            FsListenerMapper.mapFsEprProperties(listenerNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            FsListenerMapper.mapFsEprProperties(eprNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapFsEprProperties(Element toElement, FsProviderDocument.FsProvider provider, FsMessageFilterDocument.FsMessageFilter messageFilter) {
        File directory = new File(messageFilter.getDirectory());
        toElement.setAttribute("URL", directory.toURI().toString());
        toElement.setAttribute("inputSuffix", messageFilter.getInputSuffix());
        toElement.setAttribute("workSuffix", messageFilter.getWorkSuffix());
        toElement.setAttribute("postDelete", String.valueOf(messageFilter.getPostDelete()));
        toElement.setAttribute("postRename", String.valueOf(messageFilter.getPostRename()));
        if (!messageFilter.getPostDelete()) {
            toElement.setAttribute("postDir", messageFilter.getPostDirectory());
            toElement.setAttribute("postSuffix", messageFilter.getPostSuffix());
        }
        toElement.setAttribute("errorDelete", String.valueOf(messageFilter.getErrorDelete()));
        if (!messageFilter.getErrorDelete()) {
            toElement.setAttribute("errorDir", messageFilter.getErrorDirectory());
            toElement.setAttribute("errorSuffix", messageFilter.getErrorSuffix());
        }
    }
}

