/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.File;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.gateway.FileGatewayListener;
import org.jboss.soa.esb.listeners.gateway.GatewayException;
import org.jboss.soa.esb.listeners.gateway.RemoteFileMessageComposer;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.FtpClientUtil;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;
import org.jboss.soa.esb.util.RemoteFileSystemFactory;

public class RemoteGatewayListener
extends FileGatewayListener {
    public RemoteGatewayListener(ConfigTree config) throws ConfigurationException, RegistryException, GatewayException {
        super(config);
        this.checkMyParms();
    }

    protected void checkMyParms() throws ConfigurationException, RegistryException, GatewayException {
        try {
            EPR epr = ListenerUtil.assembleEpr(this.config);
            if (!(epr instanceof FTPEpr)) {
                throw new GatewayException("This Gateway only accepts FTP and SFTP.");
            }
            FTPEpr ftpEpr = (FTPEpr)epr;
            RemoteFileSystem rfs = RemoteFileSystemFactory.getRemoteFileSystem(ftpEpr, true);
            rfs.quit();
        }
        catch (RemoteFileSystemException ex) {
            throw new ConfigurationException(ex);
        }
    }

    protected void seeIfOkToWorkOnDir(File p_oDir) {
    }

    public boolean deleteFile(File file) throws GatewayException {
        RemoteFileSystem rfs = null;
        try {
            EPR epr = ListenerUtil.assembleEpr(this.config);
            if (epr instanceof FTPEpr) {
                FTPEpr ftpEpr = (FTPEpr)epr;
                rfs = RemoteFileSystemFactory.getRemoteFileSystem(ftpEpr, true);
                rfs.setRemoteDir(FtpClientUtil.fileToFtpString(this._inputDirectory));
                rfs.deleteRemoteFile(file.toString());
                boolean bl = true;
                return bl;
            }
            try {
                throw new GatewayException("This Gateway only accepts FTP and SFTP.");
            }
            catch (Exception e) {
                throw new GatewayException(e);
            }
        }
        finally {
            if (null != rfs) {
                rfs.quit();
            }
        }
    }

    byte[] getFileContents(File file) throws GatewayException {
        RemoteFileSystem rfs = null;
        try {
            File temp = File.createTempFile("FTPdown", ".tmp");
            EPR epr = ListenerUtil.assembleEpr(this.config);
            if (epr instanceof FTPEpr) {
                FTPEpr ftpEpr = (FTPEpr)epr;
                rfs = RemoteFileSystemFactory.getRemoteFileSystem(ftpEpr, true);
                rfs.setRemoteDir(FtpClientUtil.fileToFtpString(this._inputDirectory));
                rfs.downloadFile(file.toString(), temp.getAbsolutePath());
                byte[] contents = super.getFileContents(temp);
                temp.delete();
                byte[] byArray = contents;
                return byArray;
            }
            try {
                throw new GatewayException("This Gateway only accepts FTP and SFTP.");
            }
            catch (Exception e) {
                throw new GatewayException(e);
            }
        }
        finally {
            if (null != rfs) {
                rfs.quit();
            }
        }
    }

    String getDefaultComposer() {
        return RemoteFileMessageComposer.class.getName();
    }

    File[] getFileList() throws GatewayException {
        File[] oaRet;
        block9: {
            RemoteFileSystem rfs = null;
            oaRet = null;
            try {
                EPR epr = ListenerUtil.assembleEpr(this.config);
                if (epr instanceof FTPEpr) {
                    FTPEpr ftpEpr = (FTPEpr)epr;
                    rfs = RemoteFileSystemFactory.getRemoteFileSystem(ftpEpr, true);
                    rfs.setRemoteDir(FtpClientUtil.fileToFtpString(this._inputDirectory));
                    String[] sa = rfs.getFileListFromRemoteDir(this._inputSuffix);
                    oaRet = new File[null == sa ? 0 : sa.length];
                    int i1 = 0;
                    if (null != sa) {
                        for (String sCurr : sa) {
                            oaRet[i1++] = new File(sCurr);
                        }
                    }
                    break block9;
                }
                throw new GatewayException("This Gateway only accepts FTP and SFTP.");
            }
            catch (Exception e) {
                throw new GatewayException(e);
            }
            finally {
                if (null != rfs) {
                    rfs.quit();
                }
            }
        }
        return oaRet;
    }

    boolean renameFile(File from, File to) throws GatewayException {
        RemoteFileSystem rfs = null;
        try {
            EPR epr = ListenerUtil.assembleEpr(this.config);
            if (epr instanceof FTPEpr) {
                FTPEpr ftpEpr = (FTPEpr)epr;
                rfs = RemoteFileSystemFactory.getRemoteFileSystem(ftpEpr, true);
                rfs.setRemoteDir(FtpClientUtil.fileToFtpString(this._inputDirectory));
                rfs.remoteRename(from, to);
                boolean bl = true;
                return bl;
            }
            try {
                throw new GatewayException("This Gateway only accepts FTP and SFTP.");
            }
            catch (Exception e) {
                throw new GatewayException(e);
            }
        }
        finally {
            if (null != rfs) {
                rfs.quit();
            }
        }
    }

    protected File getWorkFileName(File file, String suffix) {
        return new File(file.toString() + suffix);
    }

    void bytesToFile(byte[] bytes, File file) throws GatewayException {
        RemoteFileSystem rfs = null;
        try {
            EPR epr = ListenerUtil.assembleEpr(this.config);
            if (!(epr instanceof FTPEpr)) {
                throw new Exception("This Gateway only accepts FTP and SFTP.");
            }
            FTPEpr ftpEpr = (FTPEpr)epr;
            rfs = RemoteFileSystemFactory.getRemoteFileSystem(ftpEpr, true);
            rfs.setRemoteDir(FtpClientUtil.fileToFtpString(this._inputDirectory));
            File tmpFile = File.createTempFile("RemoteGW", ".forUpload");
            super.bytesToFile(bytes, tmpFile);
            rfs.uploadFile(tmpFile, file.getName());
            tmpFile.delete();
        }
        catch (Exception e) {
            throw new GatewayException(e);
        }
        finally {
            if (null != rfs) {
                rfs.quit();
            }
        }
    }
}

