/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.principals;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
implements java.security.acl.Group,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ROLES_GROUP_NAME = "Roles";
    private final String groupName;
    private final Set<Principal> members = new HashSet<Principal>();

    public Group(String groupName) {
        if (groupName == null) {
            throw new NullPointerException("groupName argument must not be null");
        }
        this.groupName = groupName;
    }

    public String getName() {
        return this.groupName;
    }

    public String toString() {
        return "[groupName=" + this.groupName + ", members=" + this.members + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return other.groupName.equals(this.groupName) && ((Object)other.members).equals(this.members);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.groupName == null ? 0 : this.groupName.hashCode();
        return hash;
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean isMember(Principal user) {
        return this.members.contains(user);
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }
}

