/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ShowHelp;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.gui.AboutDialog;
import edu.umd.cs.findbugs.gui.AnalysisErrorDialog;
import edu.umd.cs.findbugs.gui.AnalysisRun;
import edu.umd.cs.findbugs.gui.BugCellRenderer;
import edu.umd.cs.findbugs.gui.BugInstanceGroup;
import edu.umd.cs.findbugs.gui.ConfigureDetectorsDialog;
import edu.umd.cs.findbugs.gui.ConsoleLogger;
import edu.umd.cs.findbugs.gui.Grouper;
import edu.umd.cs.findbugs.gui.LineNumberer;
import edu.umd.cs.findbugs.gui.LogSync;
import edu.umd.cs.findbugs.gui.Logger;
import edu.umd.cs.findbugs.gui.RunAnalysisDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindBugsFrame
extends JFrame
implements LogSync {
    private static final int fontSize = 12;
    private static final Font SOURCE_FONT = new Font("Monospaced", 0, 12);
    private static final Font JTREE_FONT = new Font("SansSerif", 0, 12);
    private static final Font LABEL_FONT = new Font("Dialog", 1, 24);
    private static final Font BUTTON_FONT = new Font("Dialog", 0, 12);
    private static final long serialVersionUID = 1L;
    static final Color HIGH_PRIORITY_COLOR = new Color(0xFF0000);
    static final Color NORMAL_PRIORITY_COLOR = new Color(0x9F0000);
    static final Color LOW_PRIORITY_COLOR = Color.BLACK;
    static final Color EXP_PRIORITY_COLOR = Color.BLACK;
    private static final Comparator<BugInstance> bugInstanceClassComparator = new BugInstanceClassComparator();
    private static final Comparator<BugInstance> bugInstancePackageComparator = new BugInstancePackageComparator();
    private static final Comparator<BugInstance> bugInstanceTypeComparator = new BugInstanceTypeComparator();
    private static final Comparator<BugInstance> bugInstanceCategoryComparator = new BugInstanceCategoryComparator();
    private static final Comparator<BugInstance> bugInstanceByClassComparator = new BugInstanceByClassComparator();
    private static final Comparator<BugInstance> bugInstanceByPackageComparator = new BugInstanceByPackageComparator();
    private static final Comparator<BugInstance> bugInstanceByTypeComparator = new BugInstanceByTypeComparator();
    private static final Comparator<BugInstance> bugInstanceByCategoryComparator = new BugInstanceByCategoryComparator();
    private static final FileFilter projectFileFilter = new ProjectFileFilter();
    private static final FileFilter auxClasspathEntryFileFilter = new AuxClasspathEntryFileFilter();
    private static final FileFilter xmlFileFilter = new XMLFileFilter();
    private static final HashSet<String> archiveExtensionSet = new HashSet();
    private static final FileFilter archiveAndDirectoryFilter;
    static final String GROUP_BY_CLASS = "By class";
    static final String GROUP_BY_PACKAGE = "By package";
    static final String GROUP_BY_BUG_TYPE = "By bug type";
    static final String GROUP_BY_BUG_CATEGORY = "By bug category";
    private static final String[] GROUP_BY_ORDER_LIST;
    private static final int DIVIDER_FUDGE = 3;
    private static final boolean BUG_COUNT;
    Component selectedComponent = null;
    private static final int SELECTION_VOFFSET = 2;
    private int analysisPriority = 4;
    private JMenuItem aboutItem;
    private JButton addClasspathEntryButton;
    private JButton addJarButton;
    private JButton addSourceDirButton;
    private JTextArea annotationTextArea;
    private JScrollPane annotationTextAreaScrollPane;
    private JButton browseClasspathEntryButton;
    private JButton browseJarButton;
    private JButton browseSrcDirButton;
    private JEditorPane bugDescriptionEditorPane;
    private JScrollPane bugDescriptionScrollPane;
    private JTabbedPane bugDetailsTabbedPane;
    private JEditorPane bugSummaryEditorPane;
    private JSplitPane bugTreeBugDetailsSplitter;
    private JPanel bugTreePanel;
    private JTree byBugCategoryBugTree;
    private JScrollPane byBugCategoryScrollPane;
    private JTree byBugTypeBugTree;
    private JScrollPane byBugTypeScrollPane;
    private JTree byClassBugTree;
    private JScrollPane byClassScrollPane;
    private JTree byPackageBugTree;
    private JScrollPane byPackageScrollPane;
    private JScrollPane bySummary;
    private JButton classpathDownButton;
    private JLabel classpathEntryLabel;
    private JList classpathEntryList;
    private JLabel classpathEntryListLabel;
    private JScrollPane classpathEntryListScrollPane;
    private JTextField classpathEntryTextField;
    private JButton classpathUpButton;
    private JMenuItem closeProjectItem;
    private JMenuItem configureDetectorsItem;
    private JMenuItem copyItem;
    private JMenuItem cutItem;
    private JMenu editMenu;
    private JLabel editProjectLabel;
    private JPanel editProjectPanel;
    private ButtonGroup effortButtonGroup;
    private JMenu effortMenu;
    private JPanel emptyPanel;
    private JMenuItem exitItem;
    private JRadioButtonMenuItem expPriorityButton;
    private JMenu fileMenu;
    private JMenu filterWarningsMenu;
    private JButton findBugsButton;
    private JCheckBoxMenuItem fullDescriptionsItem;
    private JTabbedPane groupByTabbedPane;
    private JLabel growBoxSpacer;
    private JMenu helpMenu;
    private JRadioButtonMenuItem highPriorityButton;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JLabel jarFileLabel;
    private JList jarFileList;
    private JLabel jarFileListLabel;
    private JScrollPane jarFileListScrollPane;
    private JTextField jarNameTextField;
    private JMenuItem loadBugsItem;
    private JLabel logoLabel;
    private JRadioButtonMenuItem lowPriorityButton;
    private JCheckBoxMenuItem maxEffortItem;
    private JRadioButtonMenuItem mediumPriorityButton;
    private JCheckBoxMenuItem minEffortItem;
    private JMenuItem newProjectItem;
    private JCheckBoxMenuItem normalEffortItem;
    private JMenuItem openProjectItem;
    private JMenuItem pasteItem;
    private ButtonGroup priorityButtonGroup;
    private JMenu recentProjectsMenu;
    private JMenuItem reloadProjectItem;
    private JButton removeClasspathEntryButton;
    private JButton removeJarButton;
    private JButton removeSrcDirButton;
    private JPanel reportPanel;
    private JMenuItem saveBugsItem;
    private JMenuItem saveProjectAsItem;
    private JMenuItem saveProjectItem;
    private JMenuItem selectAllItem;
    private JMenu settingsMenu;
    private JLabel sourceDirLabel;
    private JList sourceDirList;
    private JLabel sourceDirListLabel;
    private JScrollPane sourceDirListScrollPane;
    private JButton sourceDownButton;
    private JTextArea sourceTextArea;
    private LineNumberer sourceLineNumberer;
    private JScrollPane sourceTextAreaScrollPane;
    private JButton sourceUpButton;
    private JTextField srcDirTextField;
    private JMenuBar theMenuBar;
    private JLabel urlLabel;
    private JCheckBoxMenuItem viewBugDetailsItem;
    private JRadioButtonMenuItem viewBugsItem;
    private JMenu viewMenu;
    private JPanel viewPanel;
    private JRadioButtonMenuItem viewProjectItem;
    private Logger logger;
    private CardLayout viewPanelLayout;
    private String currentView;
    private File currentDirectory;
    private Project currentProject;
    private JTree[] bugTreeList;
    private AnalysisRun currentAnalysisRun;
    private SourceFinder sourceFinder = new SourceFinder();
    private BugInstance currentBugInstance;
    private SourceLineAnnotation currentSourceLineAnnotation;
    private String currentBugDetailsKey;
    private JCheckBoxMenuItem[] bugCategoryCheckBoxList;
    private String[] bugCategoryList;
    private AnalysisFeatureSetting[] settingList = FindBugs.DEFAULT_EFFORT;
    private static final boolean MAC_OS_X;

    public FindBugsFrame() {
        UserPreferences prefs = UserPreferences.getUserPreferences();
        prefs.read();
        String dirProp = SystemProperties.getProperty("user.dir");
        if (dirProp != null) {
            this.currentDirectory = new File(dirProp);
        }
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.priorityButtonGroup = new ButtonGroup();
        this.effortButtonGroup = new ButtonGroup();
        this.viewPanel = new JPanel();
        this.emptyPanel = new JPanel();
        this.reportPanel = new JPanel();
        this.editProjectPanel = new JPanel();
        this.jarFileLabel = new JLabel();
        this.jarNameTextField = new JTextField();
        this.addJarButton = new JButton();
        this.jarFileListLabel = new JLabel();
        this.sourceDirLabel = new JLabel();
        this.srcDirTextField = new JTextField();
        this.addSourceDirButton = new JButton();
        this.sourceDirListLabel = new JLabel();
        this.removeJarButton = new JButton();
        this.removeSrcDirButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.browseJarButton = new JButton();
        this.browseSrcDirButton = new JButton();
        this.editProjectLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.findBugsButton = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jarFileListScrollPane = new JScrollPane();
        this.jarFileList = new JList();
        this.sourceDirListScrollPane = new JScrollPane();
        this.sourceDirList = new JList();
        this.classpathEntryLabel = new JLabel();
        this.classpathEntryListLabel = new JLabel();
        this.classpathEntryTextField = new JTextField();
        this.browseClasspathEntryButton = new JButton();
        this.addClasspathEntryButton = new JButton();
        this.removeClasspathEntryButton = new JButton();
        this.classpathEntryListScrollPane = new JScrollPane();
        this.classpathEntryList = new JList();
        this.jSeparator5 = new JSeparator();
        this.sourceUpButton = new JButton();
        this.sourceDownButton = new JButton();
        this.classpathUpButton = new JButton();
        this.classpathDownButton = new JButton();
        this.bugTreePanel = new JPanel();
        this.bugTreeBugDetailsSplitter = new JSplitPane();
        this.groupByTabbedPane = new JTabbedPane();
        this.byClassScrollPane = new JScrollPane();
        this.byClassBugTree = new JTree();
        this.byClassBugTree.setFont(JTREE_FONT);
        this.byPackageScrollPane = new JScrollPane();
        this.byPackageBugTree = new JTree();
        this.byPackageBugTree.setFont(JTREE_FONT);
        this.byBugTypeScrollPane = new JScrollPane();
        this.byBugTypeBugTree = new JTree();
        this.byBugTypeBugTree.setFont(JTREE_FONT);
        this.byBugCategoryScrollPane = new JScrollPane();
        this.byBugCategoryBugTree = new JTree();
        this.byBugCategoryBugTree.setFont(JTREE_FONT);
        this.bySummary = new JScrollPane();
        this.bugSummaryEditorPane = new JEditorPane();
        this.bugDetailsTabbedPane = new JTabbedPane();
        this.bugDescriptionScrollPane = new JScrollPane();
        this.bugDescriptionEditorPane = new JEditorPane();
        this.sourceTextAreaScrollPane = new JScrollPane();
        this.sourceTextArea = new JTextArea();
        this.annotationTextAreaScrollPane = new JScrollPane();
        this.annotationTextArea = new JTextArea();
        this.urlLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.logoLabel = new JLabel();
        this.growBoxSpacer = new JLabel();
        this.theMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newProjectItem = new JMenuItem();
        this.openProjectItem = new JMenuItem();
        this.recentProjectsMenu = new JMenu();
        this.jSeparator9 = new JSeparator();
        this.closeProjectItem = new JMenuItem();
        this.saveProjectItem = new JMenuItem();
        this.saveProjectAsItem = new JMenuItem();
        this.reloadProjectItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.loadBugsItem = new JMenuItem();
        this.saveBugsItem = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.selectAllItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewBugDetailsItem = new JCheckBoxMenuItem();
        this.fullDescriptionsItem = new JCheckBoxMenuItem();
        this.jSeparator7 = new JSeparator();
        this.filterWarningsMenu = new JMenu();
        this.expPriorityButton = new JRadioButtonMenuItem();
        this.lowPriorityButton = new JRadioButtonMenuItem();
        this.mediumPriorityButton = new JRadioButtonMenuItem();
        this.highPriorityButton = new JRadioButtonMenuItem();
        this.jSeparator11 = new JSeparator();
        this.jSeparator8 = new JSeparator();
        this.viewProjectItem = new JRadioButtonMenuItem();
        this.viewBugsItem = new JRadioButtonMenuItem();
        this.settingsMenu = new JMenu();
        this.configureDetectorsItem = new JMenuItem();
        this.effortMenu = new JMenu();
        this.minEffortItem = new JCheckBoxMenuItem();
        this.normalEffortItem = new JCheckBoxMenuItem();
        this.maxEffortItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.aboutItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FindBugsFrame.this.exitForm(evt);
            }

            public void windowOpened(WindowEvent evt) {
                FindBugsFrame.this.formWindowOpened(evt);
            }
        });
        this.viewPanel.setLayout(new CardLayout());
        this.viewPanel.add((Component)this.emptyPanel, "EmptyPanel");
        this.viewPanel.add((Component)this.reportPanel, "ReportPanel");
        this.editProjectPanel.setLayout(new GridBagLayout());
        this.jarFileLabel.setFont(BUTTON_FONT);
        this.jarFileLabel.setText("Archive or directory:");
        this.jarFileLabel.setText(L10N.getLocalString("dlg.jarfile_lbl", "Archive or Directory:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.jarFileLabel, gridBagConstraints);
        this.jarNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.jarNameTextFieldActionPerformed(evt);
            }
        });
        this.jarNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.jarNameTextField, gridBagConstraints);
        this.addJarButton.setFont(BUTTON_FONT);
        this.addJarButton.setText("Add");
        this.addJarButton.setMaximumSize(new Dimension(90, 25));
        this.addJarButton.setMinimumSize(new Dimension(90, 25));
        this.addJarButton.setPreferredSize(new Dimension(90, 25));
        this.addJarButton.setText(L10N.getLocalString("dlg.add_btn", "Add"));
        this.addJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.addJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.addJarButton, gridBagConstraints);
        this.jarFileListLabel.setFont(BUTTON_FONT);
        this.jarFileListLabel.setText("Archives/directories:");
        this.jarFileListLabel.setText(L10N.getLocalString("dlg.jarlist_lbl", "Archives/Directories:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.jarFileListLabel, gridBagConstraints);
        this.sourceDirLabel.setFont(BUTTON_FONT);
        this.sourceDirLabel.setText("Source directory:");
        this.sourceDirLabel.setText(L10N.getLocalString("dlg.srcfile_lbl", "Source directory:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.sourceDirLabel, gridBagConstraints);
        this.srcDirTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.srcDirTextFieldActionPerformed(evt);
            }
        });
        this.srcDirTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.srcDirTextField, gridBagConstraints);
        this.addSourceDirButton.setFont(BUTTON_FONT);
        this.addSourceDirButton.setText("Add");
        this.addSourceDirButton.setMaximumSize(new Dimension(90, 25));
        this.addSourceDirButton.setMinimumSize(new Dimension(90, 25));
        this.addSourceDirButton.setPreferredSize(new Dimension(90, 25));
        this.addSourceDirButton.setText(L10N.getLocalString("dlg.add_btn", "Add"));
        this.addSourceDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.addSourceDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.addSourceDirButton, gridBagConstraints);
        this.sourceDirListLabel.setFont(BUTTON_FONT);
        this.sourceDirListLabel.setText("Source directories:");
        this.sourceDirListLabel.setText(L10N.getLocalString("dlg.srclist_lbl", "Source directories:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.sourceDirListLabel, gridBagConstraints);
        this.removeJarButton.setFont(BUTTON_FONT);
        this.removeJarButton.setText("Remove");
        this.removeJarButton.setMaximumSize(new Dimension(90, 25));
        this.removeJarButton.setMinimumSize(new Dimension(90, 25));
        this.removeJarButton.setPreferredSize(new Dimension(90, 25));
        this.removeJarButton.setText(L10N.getLocalString("dlg.remove_btn", "Remove"));
        this.removeJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.removeJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.removeJarButton, gridBagConstraints);
        this.removeSrcDirButton.setFont(BUTTON_FONT);
        this.removeSrcDirButton.setText("Remove");
        this.removeSrcDirButton.setMaximumSize(new Dimension(90, 25));
        this.removeSrcDirButton.setMinimumSize(new Dimension(90, 25));
        this.removeSrcDirButton.setPreferredSize(new Dimension(90, 25));
        this.removeSrcDirButton.setText(L10N.getLocalString("dlg.remove_btn", "Remove"));
        this.removeSrcDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.removeSrcDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.removeSrcDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.browseJarButton.setFont(BUTTON_FONT);
        this.browseJarButton.setText("Browse");
        this.browseJarButton.setMaximumSize(new Dimension(90, 25));
        this.browseJarButton.setMinimumSize(new Dimension(90, 25));
        this.browseJarButton.setPreferredSize(new Dimension(90, 25));
        this.browseJarButton.setText(L10N.getLocalString("dlg.browse_btn", "Browse..."));
        this.browseJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.browseJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.browseJarButton, gridBagConstraints);
        this.browseSrcDirButton.setFont(BUTTON_FONT);
        this.browseSrcDirButton.setText("Browse");
        this.browseSrcDirButton.setMaximumSize(new Dimension(90, 25));
        this.browseSrcDirButton.setMinimumSize(new Dimension(90, 25));
        this.browseSrcDirButton.setPreferredSize(new Dimension(90, 25));
        this.browseSrcDirButton.setText(L10N.getLocalString("dlg.browse_btn", "Browse..."));
        this.browseSrcDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.browseSrcDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.browseSrcDirButton, gridBagConstraints);
        this.editProjectLabel.setBackground(new Color(0, 0, 204));
        this.editProjectLabel.setFont(LABEL_FONT);
        this.editProjectLabel.setForeground(new Color(255, 255, 255));
        this.editProjectLabel.setText("Project");
        this.editProjectLabel.setOpaque(true);
        this.editProjectLabel.setText(L10N.getLocalString("dlg.project_lbl", "Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.editProjectPanel.add((Component)this.editProjectLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.findBugsButton.setMnemonic('B');
        this.findBugsButton.setText("Find Bugs!");
        this.findBugsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.findBugsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.findBugsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.jSeparator4, gridBagConstraints);
        this.jarFileListScrollPane.setPreferredSize(new Dimension(259, 1));
        this.jarFileList.setBorder(new BevelBorder(1));
        this.jarFileList.setFont(BUTTON_FONT);
        this.disableEditKeyBindings(this.jarFileList);
        this.jarFileList.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.jarFileListScrollPane.setViewportView(this.jarFileList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.jarFileListScrollPane, gridBagConstraints);
        this.sourceDirListScrollPane.setPreferredSize(new Dimension(259, 1));
        this.sourceDirList.setBorder(new BevelBorder(1));
        this.sourceDirList.setFont(BUTTON_FONT);
        this.disableEditKeyBindings(this.sourceDirList);
        this.sourceDirList.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.sourceDirListScrollPane.setViewportView(this.sourceDirList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.sourceDirListScrollPane, gridBagConstraints);
        this.classpathEntryLabel.setFont(BUTTON_FONT);
        this.classpathEntryLabel.setText("Classpath entry:");
        this.classpathEntryLabel.setText(L10N.getLocalString("dlg.classpathfile_lbl", "Classpath entry:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.editProjectPanel.add((Component)this.classpathEntryLabel, gridBagConstraints);
        this.classpathEntryListLabel.setFont(BUTTON_FONT);
        this.classpathEntryListLabel.setText("Classpath entries:");
        this.classpathEntryListLabel.setText(L10N.getLocalString("dlg.classpathlist_lbl", "Classpath entries:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.editProjectPanel.add((Component)this.classpathEntryListLabel, gridBagConstraints);
        this.classpathEntryTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.classpathEntryTextField, gridBagConstraints);
        this.browseClasspathEntryButton.setFont(BUTTON_FONT);
        this.browseClasspathEntryButton.setText("Browse");
        this.browseClasspathEntryButton.setMaximumSize(new Dimension(90, 25));
        this.browseClasspathEntryButton.setMinimumSize(new Dimension(90, 25));
        this.browseClasspathEntryButton.setPreferredSize(new Dimension(90, 25));
        this.browseClasspathEntryButton.setText(L10N.getLocalString("dlg.browse_btn", "Browse..."));
        this.browseClasspathEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.browseClasspathEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        this.editProjectPanel.add((Component)this.browseClasspathEntryButton, gridBagConstraints);
        this.addClasspathEntryButton.setFont(BUTTON_FONT);
        this.addClasspathEntryButton.setText("Add");
        this.addClasspathEntryButton.setMaximumSize(new Dimension(90, 25));
        this.addClasspathEntryButton.setMinimumSize(new Dimension(90, 25));
        this.addClasspathEntryButton.setPreferredSize(new Dimension(90, 25));
        this.addClasspathEntryButton.setText(L10N.getLocalString("dlg.add_btn", "Add"));
        this.addClasspathEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.addClasspathEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.addClasspathEntryButton, gridBagConstraints);
        this.removeClasspathEntryButton.setFont(BUTTON_FONT);
        this.removeClasspathEntryButton.setText("Remove");
        this.removeClasspathEntryButton.setMaximumSize(new Dimension(90, 25));
        this.removeClasspathEntryButton.setMinimumSize(new Dimension(90, 25));
        this.removeClasspathEntryButton.setPreferredSize(new Dimension(90, 25));
        this.removeClasspathEntryButton.setText(L10N.getLocalString("dlg.remove_btn", "Remove"));
        this.removeClasspathEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.removeClasspathEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.removeClasspathEntryButton, gridBagConstraints);
        this.classpathEntryListScrollPane.setPreferredSize(new Dimension(259, 1));
        this.classpathEntryList.setBorder(new BevelBorder(1));
        this.classpathEntryList.setFont(BUTTON_FONT);
        this.disableEditKeyBindings(this.classpathEntryList);
        this.classpathEntryList.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.classpathEntryListScrollPane.setViewportView(this.classpathEntryList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.classpathEntryListScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.editProjectPanel.add((Component)this.jSeparator5, gridBagConstraints);
        this.sourceUpButton.setFont(BUTTON_FONT);
        this.sourceUpButton.setText("Up");
        this.sourceUpButton.setMaximumSize(new Dimension(90, 25));
        this.sourceUpButton.setMinimumSize(new Dimension(90, 25));
        this.sourceUpButton.setPreferredSize(new Dimension(90, 25));
        this.sourceUpButton.setText(L10N.getLocalString("dlg.up_btn", "Up"));
        this.sourceUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.sourceUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 0.2;
        this.editProjectPanel.add((Component)this.sourceUpButton, gridBagConstraints);
        this.sourceDownButton.setFont(BUTTON_FONT);
        this.sourceDownButton.setText("Down");
        this.sourceDownButton.setMaximumSize(new Dimension(90, 25));
        this.sourceDownButton.setMinimumSize(new Dimension(90, 25));
        this.sourceDownButton.setPreferredSize(new Dimension(90, 25));
        this.sourceDownButton.setText(L10N.getLocalString("dlg.down_btn", "Down"));
        this.sourceDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.sourceDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        this.editProjectPanel.add((Component)this.sourceDownButton, gridBagConstraints);
        this.classpathUpButton.setFont(BUTTON_FONT);
        this.classpathUpButton.setText("Up");
        this.classpathUpButton.setMaximumSize(new Dimension(90, 25));
        this.classpathUpButton.setMinimumSize(new Dimension(90, 25));
        this.classpathUpButton.setPreferredSize(new Dimension(90, 25));
        this.classpathUpButton.setText(L10N.getLocalString("dlg.up_btn", "Up"));
        this.classpathUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.classpathUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.weighty = 0.2;
        this.editProjectPanel.add((Component)this.classpathUpButton, gridBagConstraints);
        this.classpathDownButton.setFont(BUTTON_FONT);
        this.classpathDownButton.setText("Down");
        this.classpathDownButton.setMaximumSize(new Dimension(90, 25));
        this.classpathDownButton.setMinimumSize(new Dimension(90, 25));
        this.classpathDownButton.setPreferredSize(new Dimension(90, 25));
        this.classpathDownButton.setText(L10N.getLocalString("dlg.down_btn", "Down"));
        this.classpathDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.classpathDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        this.editProjectPanel.add((Component)this.classpathDownButton, gridBagConstraints);
        this.viewPanel.add((Component)this.editProjectPanel, "EditProjectPanel");
        this.bugTreePanel.setLayout(new GridBagLayout());
        this.bugTreeBugDetailsSplitter.setOrientation(0);
        this.bugTreeBugDetailsSplitter.setResizeWeight(1.0);
        this.bugTreeBugDetailsSplitter.setOneTouchExpandable(true);
        this.bugTreeBugDetailsSplitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FindBugsFrame.this.bugTreeBugDetailsSplitterPropertyChange(evt);
            }
        });
        this.byClassBugTree.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.byClassScrollPane.setViewportView(this.byClassBugTree);
        this.groupByTabbedPane.addTab("By Class", this.byClassScrollPane);
        this.byPackageBugTree.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.byPackageScrollPane.setViewportView(this.byPackageBugTree);
        this.groupByTabbedPane.addTab("By Package", this.byPackageScrollPane);
        this.byBugTypeBugTree.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.byBugTypeScrollPane.setViewportView(this.byBugTypeBugTree);
        this.groupByTabbedPane.addTab("By Bug Type", this.byBugTypeScrollPane);
        this.byBugCategoryBugTree.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.byBugCategoryScrollPane.setViewportView(this.byBugCategoryBugTree);
        this.groupByTabbedPane.addTab("By Category Type", this.byBugCategoryScrollPane);
        this.bugSummaryEditorPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.bySummary.setViewportView(this.bugSummaryEditorPane);
        this.groupByTabbedPane.addTab("Summary", this.bySummary);
        this.bugTreeBugDetailsSplitter.setTopComponent(this.groupByTabbedPane);
        this.bugDescriptionEditorPane.setEditable(false);
        this.bugDescriptionEditorPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.bugDescriptionScrollPane.setViewportView(this.bugDescriptionEditorPane);
        this.bugDetailsTabbedPane.addTab("Details", this.bugDescriptionScrollPane);
        this.sourceTextAreaScrollPane.setMinimumSize(new Dimension(22, 180));
        this.sourceTextAreaScrollPane.setPreferredSize(new Dimension(0, 100));
        this.sourceTextArea.setEditable(false);
        this.sourceTextArea.setFont(SOURCE_FONT);
        this.sourceTextArea.setEnabled(false);
        this.sourceTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.sourceTextAreaScrollPane.setViewportView(this.sourceTextArea);
        this.sourceLineNumberer = new LineNumberer(this.sourceTextArea);
        this.sourceLineNumberer.setBackground(Color.WHITE);
        this.sourceTextAreaScrollPane.setRowHeaderView(this.sourceLineNumberer);
        this.bugDetailsTabbedPane.addTab("Source code", this.sourceTextAreaScrollPane);
        this.annotationTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                FindBugsFrame.this.focusGainedHandler(evt);
            }
        });
        this.annotationTextAreaScrollPane.setViewportView(this.annotationTextArea);
        this.bugDetailsTabbedPane.addTab("Annotations", this.annotationTextAreaScrollPane);
        this.bugTreeBugDetailsSplitter.setBottomComponent(this.bugDetailsTabbedPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bugTreePanel.add((Component)this.bugTreeBugDetailsSplitter, gridBagConstraints);
        this.viewPanel.add((Component)this.bugTreePanel, "BugTree");
        this.equalizeControls(new JComponent[]{this.addJarButton, this.addSourceDirButton, this.addClasspathEntryButton, this.removeJarButton, this.removeSrcDirButton, this.removeClasspathEntryButton, this.browseJarButton, this.browseSrcDirButton, this.browseClasspathEntryButton, this.sourceUpButton, this.sourceDownButton, this.classpathUpButton, this.classpathDownButton});
        this.groupByTabbedPane.setTitleAt(0, L10N.getLocalString("dlg.byclass_tab", "By Class"));
        this.groupByTabbedPane.setTitleAt(1, L10N.getLocalString("dlg.bypackage_tab", "By Package"));
        this.groupByTabbedPane.setTitleAt(2, L10N.getLocalString("dlg.bybugtype_tab", "By Bug Type"));
        this.groupByTabbedPane.setTitleAt(3, L10N.getLocalString("dlg.bybugcategory_tab", "By Bug Category"));
        this.groupByTabbedPane.setTitleAt(4, L10N.getLocalString("dlg.summary_tab", "Summary"));
        this.bugDetailsTabbedPane.setTitleAt(0, L10N.getLocalString("dlg.details_tab", "Details"));
        this.bugDetailsTabbedPane.setTitleAt(1, L10N.getLocalString("dlg.sourcecode_tab", "Source Code"));
        this.bugDetailsTabbedPane.setTitleAt(2, L10N.getLocalString("dlg.annotations_tab", "Annotations"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.viewPanel, gridBagConstraints);
        this.urlLabel.setFont(BUTTON_FONT);
        this.urlLabel.setText("FindBugs - http://findbugs.sourceforge.net/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.getContentPane().add((Component)this.urlLabel, gridBagConstraints);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 0));
        this.jPanel1.add(this.logoLabel);
        this.growBoxSpacer.setMaximumSize(new Dimension(16, 16));
        this.jPanel1.add(this.growBoxSpacer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.theMenuBar.setFont(BUTTON_FONT);
        this.fileMenu.setText("File");
        this.fileMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.fileMenu, "menu.file_menu", "&File", true);
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                FindBugsFrame.this.fileMenuMenuSelected(evt);
            }
        });
        this.newProjectItem.setFont(BUTTON_FONT);
        this.newProjectItem.setText("New Project");
        this.localiseButton(this.newProjectItem, "menu.new_item", "&New Project", true);
        this.newProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.newProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newProjectItem);
        this.openProjectItem.setFont(BUTTON_FONT);
        this.openProjectItem.setText("Open Project...");
        this.localiseButton(this.openProjectItem, "menu.open_item", "&Open Project...", true);
        this.openProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.openProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProjectItem);
        this.recentProjectsMenu.setText("Recent Projects");
        this.recentProjectsMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.recentProjectsMenu, "menu.recent_menu", "R&ecent Projects", true);
        this.rebuildRecentProjectsMenu();
        this.fileMenu.add(this.recentProjectsMenu);
        this.fileMenu.add(this.jSeparator9);
        this.closeProjectItem.setFont(BUTTON_FONT);
        this.closeProjectItem.setText("Close Project");
        this.localiseButton(this.closeProjectItem, "menu.close_item", "&Close Project", true);
        this.closeProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.closeProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeProjectItem);
        this.saveProjectItem.setFont(BUTTON_FONT);
        this.saveProjectItem.setText("Save Project");
        this.localiseButton(this.saveProjectItem, "menu.save_item", "&Save Project", true);
        this.saveProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.saveProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectItem);
        this.saveProjectAsItem.setFont(BUTTON_FONT);
        this.saveProjectAsItem.setText("Save Project As...");
        this.localiseButton(this.saveProjectAsItem, "menu.saveas_item", "Save Project &As...", true);
        this.saveProjectAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.saveProjectAsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectAsItem);
        this.reloadProjectItem.setFont(BUTTON_FONT);
        this.reloadProjectItem.setText("Reload Project");
        this.localiseButton(this.reloadProjectItem, "menu.reload_item", "&Reload Project", true);
        this.reloadProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.reloadProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.reloadProjectItem);
        this.fileMenu.add(this.jSeparator3);
        this.loadBugsItem.setFont(BUTTON_FONT);
        this.loadBugsItem.setText("Load Bugs...");
        this.localiseButton(this.loadBugsItem, "menu.loadbugs_item", "&Load Bugs...", true);
        this.loadBugsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.loadBugsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadBugsItem);
        this.saveBugsItem.setFont(BUTTON_FONT);
        this.saveBugsItem.setText("Save Bugs");
        this.localiseButton(this.saveBugsItem, "menu.savebugs_item", "Save &Bugs...", true);
        this.saveBugsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.saveBugsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveBugsItem);
        this.fileMenu.add(this.jSeparator6);
        this.exitItem.setFont(BUTTON_FONT);
        this.exitItem.setText("Exit");
        this.localiseButton(this.exitItem, "menu.exit_item", "E&xit", true);
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.theMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.setFont(BUTTON_FONT);
        this.editMenu.setEnabled(false);
        this.localiseButton(this.editMenu, "menu.edit_menu", "&Edit", true);
        this.cutItem.setFont(BUTTON_FONT);
        this.cutItem.setText("Cut");
        this.localiseButton(this.cutItem, "menu.cut_item", "Cut", true);
        this.cutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.cutActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutItem);
        this.copyItem.setFont(BUTTON_FONT);
        this.copyItem.setText("Copy");
        this.localiseButton(this.copyItem, "menu.copy_item", "Copy", true);
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.copyActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem.setFont(BUTTON_FONT);
        this.pasteItem.setText("Paste");
        this.localiseButton(this.pasteItem, "menu.paste_item", "Paste", true);
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.pasteActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteItem);
        this.editMenu.add(this.jSeparator10);
        this.selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllItem.setFont(BUTTON_FONT);
        this.selectAllItem.setText("Select All");
        this.localiseButton(this.selectAllItem, "menu.selectall_item", "Select &All", true);
        this.selectAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.selectAllActionPerformed(evt);
            }
        });
        this.editMenu.add(this.selectAllItem);
        this.theMenuBar.add(this.editMenu);
        this.viewMenu.setText("View");
        this.viewMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.viewMenu, "menu.view_menu", "&View", true);
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                FindBugsFrame.this.viewMenuMenuSelected(evt);
            }
        });
        this.viewBugDetailsItem.setFont(BUTTON_FONT);
        this.viewBugDetailsItem.setSelected(true);
        this.viewBugDetailsItem.setText("Bug Details");
        this.localiseButton(this.viewBugDetailsItem, "menu.bugdetails_item", "Bug &Details", true);
        this.viewBugDetailsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.viewBugDetailsItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewBugDetailsItem);
        this.fullDescriptionsItem.setFont(BUTTON_FONT);
        this.fullDescriptionsItem.setSelected(true);
        this.fullDescriptionsItem.setText("Full Descriptions");
        this.localiseButton(this.fullDescriptionsItem, "menu.fulldescriptions_item", "&Full Descriptions", true);
        this.fullDescriptionsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.fullDescriptionsItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fullDescriptionsItem);
        this.viewMenu.add(this.jSeparator7);
        this.filterWarningsMenu.setText("Filter Warnings");
        this.filterWarningsMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.filterWarningsMenu, "menu.filterwarnings_menu", "Filter &Warnings", true);
        this.expPriorityButton.setFont(BUTTON_FONT);
        this.expPriorityButton.setText("Experimental Priority");
        this.priorityButtonGroup.add(this.expPriorityButton);
        this.localiseButton(this.expPriorityButton, "menu.exppriority_item", "&Experimental Priority", true);
        this.expPriorityButton.setSelected(this.getPriorityThreshold() == 4);
        this.expPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.expPriorityButtonActionPerformed(evt);
            }
        });
        this.filterWarningsMenu.add(this.expPriorityButton);
        this.lowPriorityButton.setFont(BUTTON_FONT);
        this.lowPriorityButton.setText("Low Priority");
        this.priorityButtonGroup.add(this.lowPriorityButton);
        this.localiseButton(this.lowPriorityButton, "menu.lowpriority_item", "&Low Priority", true);
        this.lowPriorityButton.setSelected(this.getPriorityThreshold() == 3);
        this.lowPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.lowPriorityButtonActionPerformed(evt);
            }
        });
        this.filterWarningsMenu.add(this.lowPriorityButton);
        this.mediumPriorityButton.setFont(BUTTON_FONT);
        this.mediumPriorityButton.setText("Medium Priority");
        this.priorityButtonGroup.add(this.mediumPriorityButton);
        this.localiseButton(this.mediumPriorityButton, "menu.mediumpriority_item", "&Medium Priority", true);
        this.mediumPriorityButton.setSelected(this.getPriorityThreshold() == 2);
        this.mediumPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.mediumPriorityButtonActionPerformed(evt);
            }
        });
        this.filterWarningsMenu.add(this.mediumPriorityButton);
        this.highPriorityButton.setFont(BUTTON_FONT);
        this.highPriorityButton.setText("High Priority");
        this.priorityButtonGroup.add(this.highPriorityButton);
        this.localiseButton(this.highPriorityButton, "menu.highpriority_item", "&High Priority", true);
        this.highPriorityButton.setSelected(this.getPriorityThreshold() == 1);
        this.highPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.highPriorityButtonActionPerformed(evt);
            }
        });
        this.filterWarningsMenu.add(this.highPriorityButton);
        this.filterWarningsMenu.add(this.jSeparator11);
        this.viewMenu.add(this.filterWarningsMenu);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.expPriorityButton);
        bg.add(this.lowPriorityButton);
        bg.add(this.mediumPriorityButton);
        bg.add(this.highPriorityButton);
        this.viewMenu.add(this.jSeparator8);
        this.viewProjectItem.setFont(BUTTON_FONT);
        this.viewProjectItem.setText("View Project Details");
        this.viewProjectItem.setEnabled(false);
        this.localiseButton(this.viewProjectItem, "menu.viewprojectdetails_item", "View Project Details", true);
        this.viewProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.viewProjectItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewProjectItem);
        this.viewBugsItem.setFont(BUTTON_FONT);
        this.viewBugsItem.setText("View Bugs");
        this.viewBugsItem.setEnabled(false);
        this.localiseButton(this.viewBugsItem, "menu.viewbugs_item", "View Bugs", true);
        this.viewBugsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.viewBugsItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewBugsItem);
        this.theMenuBar.add(this.viewMenu);
        this.settingsMenu.setText("Settings");
        this.settingsMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.settingsMenu, "menu.settings_menu", "&Settings", true);
        this.settingsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.settingsMenuActionPerformed(evt);
            }
        });
        this.configureDetectorsItem.setFont(BUTTON_FONT);
        this.configureDetectorsItem.setText("Configure Detectors...");
        this.localiseButton(this.configureDetectorsItem, "menu.configure_item", "&Configure Detectors...", true);
        this.configureDetectorsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.configureDetectorsItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.configureDetectorsItem);
        this.effortMenu.setText("Effort");
        this.effortMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.effortMenu, "menu.effort_menu", "Effort", true);
        this.minEffortItem.setFont(BUTTON_FONT);
        this.minEffortItem.setText("Minimum");
        this.effortButtonGroup.add(this.minEffortItem);
        this.localiseButton(this.minEffortItem, "menu.mineffort_item", "&Minimum", true);
        this.minEffortItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.minEffortItemActionPerformed(evt);
            }
        });
        this.effortMenu.add(this.minEffortItem);
        this.normalEffortItem.setFont(BUTTON_FONT);
        this.normalEffortItem.setSelected(true);
        this.normalEffortItem.setText("Normal");
        this.effortButtonGroup.add(this.normalEffortItem);
        this.localiseButton(this.normalEffortItem, "menu.normaleffort_item", "&Normal", true);
        this.normalEffortItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.normalEffortItemActionPerformed(evt);
            }
        });
        this.effortMenu.add(this.normalEffortItem);
        this.maxEffortItem.setFont(BUTTON_FONT);
        this.maxEffortItem.setText("Maximum");
        this.effortButtonGroup.add(this.maxEffortItem);
        this.localiseButton(this.maxEffortItem, "menu.maxeffort_item", "&Maximum", true);
        this.maxEffortItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.maxEffortItemActionPerformed(evt);
            }
        });
        this.effortMenu.add(this.maxEffortItem);
        this.settingsMenu.add(this.effortMenu);
        this.theMenuBar.add(this.settingsMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.setFont(BUTTON_FONT);
        this.localiseButton(this.helpMenu, "menu.help_menu", "&Help", true);
        this.aboutItem.setFont(BUTTON_FONT);
        this.aboutItem.setText("About...");
        this.localiseButton(this.aboutItem, "menu.about_item", "&About", true);
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.theMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.theMenuBar);
        this.pack();
    }

    private void maxEffortItemActionPerformed(ActionEvent evt) {
        this.settingList = FindBugs.MAX_EFFORT;
    }

    private void normalEffortItemActionPerformed(ActionEvent evt) {
        this.settingList = FindBugs.DEFAULT_EFFORT;
    }

    private void minEffortItemActionPerformed(ActionEvent evt) {
        this.settingList = FindBugs.MIN_EFFORT;
    }

    private void settingsMenuActionPerformed(ActionEvent evt) {
    }

    private void formWindowOpened(WindowEvent evt) {
        if (SystemProperties.getBoolean("findbugs.noSummary")) {
            this.groupByTabbedPane.remove(this.bySummary);
        }
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        if (this.selectedComponent == null) {
            return;
        }
        if (this.selectedComponent instanceof JTextComponent) {
            ((JTextComponent)this.selectedComponent).selectAll();
        } else if (this.selectedComponent instanceof JList) {
            JList list = (JList)this.selectedComponent;
            list.setSelectionInterval(0, list.getModel().getSize() - 1);
        }
    }

    private void disableEditKeyBindings(JList list) {
        list.getInputMap().put(KeyStroke.getKeyStroke(88, 2), "none");
        list.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "none");
        list.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "none");
    }

    private String buildSelectPath(JList list) {
        StringBuilder path = new StringBuilder();
        int[] indices = list.getSelectedIndices();
        String separatorStr = SystemProperties.getProperty("path.separator");
        String sep = "";
        ListModel m = list.getModel();
        for (int indice : indices) {
            path.append(sep);
            sep = separatorStr;
            path.append(m.getElementAt(indice));
        }
        return path.toString();
    }

    private void pasteActionPerformed(ActionEvent evt) {
        Clipboard cb;
        Transferable transfer;
        if (this.selectedComponent == null) {
            return;
        }
        if (this.selectedComponent instanceof JTextComponent) {
            ((JTextComponent)this.selectedComponent).paste();
        } else if (this.selectedComponent instanceof JList && (transfer = (cb = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(this)).isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String path = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                if (this.selectedComponent == this.jarFileList) {
                    this.jarNameTextField.setText(path);
                    this.addJarButtonActionPerformed(evt);
                } else if (this.selectedComponent == this.sourceDirList) {
                    this.srcDirTextField.setText(path);
                    this.addSourceDirButtonActionPerformed(evt);
                } else if (this.selectedComponent == this.classpathEntryList) {
                    this.classpathEntryTextField.setText(path);
                    this.addClasspathEntryButtonActionPerformed(evt);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void copyActionPerformed(ActionEvent evt) {
        if (this.selectedComponent == null) {
            return;
        }
        if (this.selectedComponent instanceof JTextComponent) {
            ((JTextComponent)this.selectedComponent).copy();
        } else if (this.selectedComponent instanceof JTree) {
            TreePath path = ((JTree)this.selectedComponent).getSelectionPath();
            StringSelection data = new StringSelection(path.getLastPathComponent().toString());
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(data, data);
        } else if (this.selectedComponent instanceof JList) {
            StringSelection path = new StringSelection(this.buildSelectPath((JList)this.selectedComponent));
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(path, path);
        }
    }

    private void cutActionPerformed(ActionEvent evt) {
        if (this.selectedComponent == null) {
            return;
        }
        if (this.selectedComponent instanceof JTextComponent) {
            ((JTextComponent)this.selectedComponent).cut();
        } else if (this.selectedComponent instanceof JList) {
            StringSelection path = new StringSelection(this.buildSelectPath((JList)this.selectedComponent));
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(path, path);
            if (this.selectedComponent == this.jarFileList) {
                this.removeJarButtonActionPerformed(evt);
            } else if (this.selectedComponent == this.sourceDirList) {
                this.removeSrcDirButtonActionPerformed(evt);
            } else if (this.selectedComponent == this.classpathEntryList) {
                this.removeClasspathEntryButtonActionPerformed(evt);
            }
        }
    }

    private void focusGainedHandler(FocusEvent evt) {
        Component old = evt.getOppositeComponent();
        if (old instanceof JList) {
            ((JList)old).clearSelection();
        }
        this.selectedComponent = evt.getComponent();
        this.ableEditMenu();
    }

    private void classpathUpButtonActionPerformed(ActionEvent evt) {
        if (this.moveEntriesUp(this.classpathEntryList)) {
            this.resyncAuxClasspathEntries();
        }
    }

    private void sourceDownButtonActionPerformed(ActionEvent evt) {
        if (this.moveEntriesDown(this.sourceDirList)) {
            this.resyncSourceEntries();
        }
    }

    private void sourceUpButtonActionPerformed(ActionEvent evt) {
        if (this.moveEntriesUp(this.sourceDirList)) {
            this.resyncSourceEntries();
        }
    }

    private void classpathDownButtonActionPerformed(ActionEvent evt) {
        if (this.moveEntriesDown(this.classpathEntryList)) {
            this.resyncAuxClasspathEntries();
        }
    }

    private void viewBugsItemActionPerformed(ActionEvent evt) {
        this.setView("BugTree");
    }

    private void viewProjectItemActionPerformed(ActionEvent evt) {
        this.setView("EditProjectPanel");
    }

    private void highPriorityButtonActionPerformed(ActionEvent evt) {
        this.setPriorityThreshold(1);
    }

    private void mediumPriorityButtonActionPerformed(ActionEvent evt) {
        this.setPriorityThreshold(2);
    }

    private void lowPriorityButtonActionPerformed(ActionEvent evt) {
        this.setPriorityThreshold(3);
    }

    private void expPriorityButtonActionPerformed(ActionEvent evt) {
        this.setPriorityThreshold(4);
    }

    private void saveBugsItemActionPerformed(ActionEvent evt) {
        try {
            if (this.currentAnalysisRun == null) {
                this.logger.logMessage(2, "No bugs are loaded!");
                return;
            }
            JFileChooser chooser = this.createFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(xmlFileFilter);
            int result = this.chooseFile(chooser, L10N.getLocalString("dlg.savebugs_ttl", "Save Bugs"));
            if (result != 1) {
                if (this.currentBugInstance != null) {
                    this.synchBugAnnotation(this.currentBugInstance);
                }
                File selectedFile = chooser.getSelectedFile();
                this.currentAnalysisRun.saveBugsToFile(selectedFile);
            }
        }
        catch (Exception e) {
            if (FindBugs.DEBUG) {
                e.printStackTrace();
            }
            this.logger.logMessage(2, "Could not save bugs: " + e.toString());
        }
    }

    private void loadBugsFromFile(File file) throws IOException, DocumentException {
        File selectedFile = file;
        Project project = new Project();
        AnalysisRun analysisRun = new AnalysisRun(project, this);
        analysisRun.loadBugsFromFile(selectedFile);
        project.setProjectFileName(file.getName());
        this.setProject(project);
        this.synchAnalysisRun(analysisRun);
    }

    private void loadBugsFromURL(String urlspec) throws IOException, DocumentException {
        URL url = new URL(urlspec);
        InputStream in = url.openStream();
        Project project = new Project();
        AnalysisRun analysisRun = new AnalysisRun(project, this);
        analysisRun.loadBugsFromInputStream(in);
        this.setProject(project);
        this.synchAnalysisRun(analysisRun);
    }

    private void loadBugsItemActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = this.createFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(xmlFileFilter);
            int result = this.chooseFile(chooser, L10N.getLocalString("dlg.loadbugs_ttl", "Load Bugs..."));
            if (result != 1) {
                this.loadBugsFromFile(chooser.getSelectedFile());
            }
        }
        catch (Exception e) {
            if (FindBugs.DEBUG) {
                e.printStackTrace();
            }
            this.logger.logMessage(2, "Could not load bugs: " + e.toString());
        }
    }

    private void configureDetectorsItemActionPerformed(ActionEvent evt) {
        ConfigureDetectorsDialog dialog = new ConfigureDetectorsDialog((Frame)this, true);
        dialog.setSize(700, 520);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private void reloadProjectItemActionPerformed(ActionEvent evt) {
        Project current = this.getCurrentProject();
        if (current == null) {
            return;
        }
        try {
            String filename = current.getProjectFileName();
            Project project = new Project();
            project.read(filename);
            this.setProject(null);
            this.setProject(project);
            this.findBugsButtonActionPerformed(evt);
        }
        catch (IOException e) {
            this.logger.logMessage(2, "Could not reload project: " + e.getMessage());
        }
    }

    private void saveProjectAsItemActionPerformed(ActionEvent evt) {
        this.saveProject(this.getCurrentProject(), L10N.getLocalString("dlg.saveprojectas_ttl", "Save Project As..."), true);
    }

    private void viewMenuMenuSelected(MenuEvent evt) {
        boolean hasProject = this.getCurrentProject() != null;
        this.viewBugDetailsItem.setEnabled(hasProject);
        this.fullDescriptionsItem.setEnabled(hasProject);
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        boolean hasProject = this.getCurrentProject() != null;
        this.saveProjectItem.setEnabled(hasProject);
        this.saveProjectAsItem.setEnabled(hasProject);
        this.reloadProjectItem.setEnabled(hasProject && !this.getCurrentProject().getProjectFileName().equals("<<unnamed project>>"));
        this.closeProjectItem.setEnabled(hasProject);
        boolean hasAnalysisRun = this.currentAnalysisRun != null;
        this.saveBugsItem.setEnabled(hasAnalysisRun);
    }

    private void closeProjectItemActionPerformed(ActionEvent evt) {
        if (this.closeProjectHook(this.getCurrentProject(), L10N.getLocalString("dlg.closeproject_lbl", "Close Project"))) {
            this.setProject(null);
        }
    }

    private void removeClasspathEntryButtonActionPerformed(ActionEvent evt) {
        Project project = this.getCurrentProject();
        DefaultListModel listModel = (DefaultListModel)this.classpathEntryList.getModel();
        int[] selIndices = this.classpathEntryList.getSelectedIndices();
        for (int i = selIndices.length - 1; i >= 0; --i) {
            int sel = selIndices[i];
            project.removeAuxClasspathEntry(sel);
            listModel.remove(sel);
        }
    }

    private void addClasspathEntryButtonActionPerformed(ActionEvent evt) {
        this.addClasspathEntryToList();
    }

    private void browseClasspathEntryButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(auxClasspathEntryFileFilter);
        chooser.setMultiSelectionEnabled(true);
        int result = this.chooseFile(chooser, "Add Entry");
        if (result != 1) {
            File[] selectedFileList = chooser.getSelectedFiles();
            for (int i = 0; i < selectedFileList.length; ++i) {
                selectedFileList[i] = this.verifyFileSelection(selectedFileList[i]);
                String entry = selectedFileList[i].getPath();
                this.addClasspathEntryToProject(entry);
            }
        }
    }

    private void fullDescriptionsItemActionPerformed(ActionEvent evt) {
        for (JTree bugTree : this.bugTreeList) {
            DefaultTreeModel bugTreeModel = (DefaultTreeModel)bugTree.getModel();
            int numRows = bugTree.getRowCount();
            for (int i = 0; i < numRows; ++i) {
                DefaultMutableTreeNode node;
                TreePath path = bugTree.getPathForRow(i);
                if (path == null || !((node = (DefaultMutableTreeNode)path.getLastPathComponent()) instanceof BugTreeNode)) continue;
                bugTreeModel.valueForPathChanged(path, node.getUserObject());
            }
        }
    }

    private void viewBugDetailsItemActionPerformed(ActionEvent evt) {
        String view = this.getView();
        if (view.equals("BugTree")) {
            this.checkBugDetailsVisibility();
        }
    }

    private void bugTreeBugDetailsSplitterPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("dividerLocation")) {
            boolean isMaximized = this.isSplitterMaximized(this.bugTreeBugDetailsSplitter, evt);
            this.viewBugDetailsItem.setSelected(!isMaximized);
            if (!isMaximized) {
                this.synchBugInstance();
            }
        }
    }

    private void openProjectItemActionPerformed(ActionEvent evt) {
        if (!this.closeProjectHook(this.getCurrentProject(), L10N.getLocalString("msg.openproject_txt", "Open Project"))) {
            return;
        }
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileFilter(projectFileFilter);
        int result = this.chooseFileToOpen(chooser);
        if (result == 1) {
            return;
        }
        try {
            File file = chooser.getSelectedFile();
            Project project = new Project();
            project.read(file.getPath());
            this.setProject(project);
            UserPreferences.getUserPreferences().useProject(file.getPath());
            this.rebuildRecentProjectsMenu();
        }
        catch (IOException e) {
            this.logger.logMessage(2, MessageFormat.format(L10N.getLocalString("msg.couldnotopenproject_txt", "Could not open project: {0}"), e.getMessage()));
        }
    }

    private void saveProjectItemActionPerformed(ActionEvent evt) {
        this.saveProject(this.getCurrentProject(), L10N.getLocalString("msg.saveproject_txt", "Save Project"));
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        this.about();
    }

    private void findBugsButtonActionPerformed(ActionEvent evt) {
        Project project = this.getCurrentProject();
        if (project.getFileCount() == 0) {
            this.logger.logMessage(2, MessageFormat.format(L10N.getLocalString("msg.projectnojars_txt", "Project {0} has no Jar files selected"), project));
            return;
        }
        this.bugDescriptionEditorPane.setText("");
        this.currentBugDetailsKey = null;
        this.sourceTextArea.setText("");
        AnalysisRun analysisRun = new AnalysisRun(project, this);
        this.logger.logMessage(0, MessageFormat.format(L10N.getLocalString("msg.beginninganalysis_txt", "Beginning analysis of {0}"), project));
        RunAnalysisDialog dialog = new RunAnalysisDialog((Frame)this, analysisRun, this.analysisPriority);
        dialog.setSize(400, 300);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.isCompleted()) {
            this.logger.logMessage(0, MessageFormat.format(L10N.getLocalString("msg.analysiscompleted_txt", "Analysis {0} completed"), project));
            analysisRun.reportAnalysisErrors();
            this.synchAnalysisRun(analysisRun);
        } else if (dialog.exceptionOccurred()) {
            StackTraceElement[] callList;
            Exception e = dialog.getException();
            AnalysisErrorDialog err = new AnalysisErrorDialog((Frame)this, true, null);
            err.addLine(MessageFormat.format(L10N.getLocalString("msg.fatalanalysisexception_txt", "Fatal analysis exception: {0}"), e.toString()));
            for (StackTraceElement aCallList : callList = e.getStackTrace()) {
                err.addLine("\t" + aCallList);
            }
            err.finish();
            err.setSize(650, 500);
            err.setLocationRelativeTo(null);
            err.setVisible(true);
        } else {
            this.logger.logMessage(0, MessageFormat.format(L10N.getLocalString("msg.analysiscancelled_txt", "Analysis of {0} cancelled by user"), project));
        }
    }

    private void browseSrcDirButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileFilter(archiveAndDirectoryFilter);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        int rc = this.chooseFile(chooser, L10N.getLocalString("msg_addsource_lbl", "Add source directory or archive"));
        if (rc == 0) {
            File[] selectedFileList = chooser.getSelectedFiles();
            for (int i = 0; i < selectedFileList.length; ++i) {
                selectedFileList[i] = this.verifyFileSelection(selectedFileList[i]);
                String entry = selectedFileList[i].getPath();
                this.addSrcToProject(entry);
            }
        }
    }

    private void srcDirTextFieldActionPerformed(ActionEvent evt) {
        this.addSourceDirToList();
    }

    private void jarNameTextFieldActionPerformed(ActionEvent evt) {
        this.addJarToList();
    }

    private void browseJarButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileFilter(archiveAndDirectoryFilter);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        int rc = this.chooseFile(chooser, L10N.getLocalString("msg.addarchiveordirectory_txt", "Add archive or directory"));
        if (rc == 0) {
            File[] selectedFileList = chooser.getSelectedFiles();
            for (int i = 0; i < selectedFileList.length; ++i) {
                selectedFileList[i] = this.verifyFileSelection(selectedFileList[i]);
                String entry = selectedFileList[i].getPath();
                this.addJarToProject(entry);
            }
        }
    }

    private void newProjectItemActionPerformed(ActionEvent evt) {
        if (!this.closeProjectHook(this.getCurrentProject(), L10N.getLocalString("msg.newproject_txt", "New Project"))) {
            return;
        }
        Project project = new Project();
        this.setProject(project);
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.exitFindBugs();
    }

    private void removeSrcDirButtonActionPerformed(ActionEvent evt) {
        Project project = this.getCurrentProject();
        DefaultListModel listModel = (DefaultListModel)this.sourceDirList.getModel();
        int[] selIndices = this.sourceDirList.getSelectedIndices();
        for (int i = selIndices.length - 1; i >= 0; --i) {
            int sel = selIndices[i];
            project.removeSourceDir(sel);
            listModel.remove(sel);
        }
    }

    private void removeJarButtonActionPerformed(ActionEvent evt) {
        Project project = this.getCurrentProject();
        DefaultListModel listModel = (DefaultListModel)this.jarFileList.getModel();
        int[] selIndices = this.jarFileList.getSelectedIndices();
        for (int i = selIndices.length - 1; i >= 0; --i) {
            int sel = selIndices[i];
            project.removeFile(sel);
            listModel.remove(sel);
        }
    }

    private void addSourceDirButtonActionPerformed(ActionEvent evt) {
        this.addSourceDirToList();
    }

    private void addJarButtonActionPerformed(ActionEvent evt) {
        this.addJarToList();
    }

    private void exitForm(WindowEvent evt) {
        this.exitFindBugs();
    }

    private void equalizeControls(JComponent[] components) {
        Dimension d;
        int minX = 0;
        int minY = 0;
        for (JComponent comp : components) {
            comp.setMaximumSize(null);
            comp.setMinimumSize(null);
            comp.setPreferredSize(null);
            d = comp.getPreferredSize();
            if (d.width > minX) {
                minX = d.width;
            }
            if (d.height <= minY) continue;
            minY = d.height;
        }
        d = new Dimension(minX, minY);
        for (JComponent comp : components) {
            comp.setMinimumSize(d);
            comp.setMaximumSize(d);
            comp.setPreferredSize(d);
        }
    }

    private void bugTreeSelectionChanged(TreeSelectionEvent e) {
        BugInstance selected = this.getCurrentBugInstance();
        if (selected != null) {
            this.synchBugInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRecentProjectItemActionPerformed(ActionEvent evt) {
        if (!this.closeProjectHook(this.getCurrentProject(), L10N.getLocalString("msg.openproject_txt", "Open Project"))) {
            return;
        }
        JMenuItem recentProjectItem = (JMenuItem)evt.getSource();
        File file = new File(recentProjectItem.getText());
        try {
            System.setProperty("user.dir", file.getParent());
            Project project = new Project();
            project.read(file.getPath());
            this.setProject(project);
            UserPreferences.getUserPreferences().useProject(file.getPath());
        }
        catch (IOException e) {
            UserPreferences.getUserPreferences().removeProject(file.getPath());
            this.logger.logMessage(2, MessageFormat.format(L10N.getLocalString("msg.couldnotopenproject_txt", "Could not open project: {0}"), e.getMessage()));
        }
        finally {
            this.rebuildRecentProjectsMenu();
        }
    }

    private boolean moveEntriesUp(JList entryList) {
        int[] selIndices = entryList.getSelectedIndices();
        if (selIndices.length == 0) {
            return false;
        }
        boolean changed = false;
        int lastInsertPos = -1;
        DefaultListModel model = (DefaultListModel)entryList.getModel();
        for (int i = 0; i < selIndices.length; ++i) {
            int sel = selIndices[i];
            if (sel - 1 > lastInsertPos) {
                model.add(sel - 1, model.remove(sel));
                selIndices[i] = sel - 1;
                changed = true;
            }
            lastInsertPos = selIndices[i];
        }
        entryList.setSelectedIndices(selIndices);
        return changed;
    }

    private boolean moveEntriesDown(JList entryList) {
        int[] selIndices = entryList.getSelectedIndices();
        if (selIndices.length == 0) {
            return false;
        }
        boolean changed = false;
        DefaultListModel model = (DefaultListModel)entryList.getModel();
        int lastInsertPos = model.getSize();
        for (int i = selIndices.length - 1; i >= 0; --i) {
            int sel = selIndices[i];
            if (sel + 1 < lastInsertPos) {
                model.add(sel + 1, model.remove(sel));
                selIndices[i] = sel + 1;
                changed = true;
            }
            lastInsertPos = selIndices[i];
        }
        entryList.setSelectedIndices(selIndices);
        return changed;
    }

    private void resyncAuxClasspathEntries() {
        Project project = this.getCurrentProject();
        int numEntries = project.getNumAuxClasspathEntries();
        while (numEntries-- > 0) {
            project.removeAuxClasspathEntry(0);
        }
        DefaultListModel model = (DefaultListModel)this.classpathEntryList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            project.addAuxClasspathEntry((String)model.get(i));
        }
    }

    private void resyncSourceEntries() {
        Project project = this.getCurrentProject();
        int numEntries = project.getNumSourceDirs();
        while (numEntries-- > 0) {
            project.removeSourceDir(0);
        }
        DefaultListModel model = (DefaultListModel)this.sourceDirList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            project.addSourceDir((String)model.get(i));
        }
    }

    private void localiseButton(AbstractButton button, String key, String defaultString, boolean setMnemonic) {
        L10N.localiseButton(button, key, defaultString, setMnemonic);
    }

    private void postInitComponents() {
        block8: {
            this.logger = new ConsoleLogger(this);
            Collection<String> bugCategoryCollection = I18N.instance().getBugCategories();
            this.bugCategoryCheckBoxList = new JCheckBoxMenuItem[bugCategoryCollection.size()];
            this.bugCategoryList = new String[bugCategoryCollection.size()];
            int count = 0;
            for (String bugCategory : bugCategoryCollection) {
                String bugCategoryDescription = I18N.instance().getBugCategoryDescription(bugCategory);
                final JCheckBoxMenuItem item = new JCheckBoxMenuItem(bugCategoryDescription, true);
                item.setFont(BUTTON_FONT);
                item.setSelected(this.getFilterSettings().containsCategory(bugCategory));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        FindBugsFrame.this.toggleBugCategory(item);
                    }
                });
                this.filterWarningsMenu.add(item);
                this.bugCategoryCheckBoxList[count] = item;
                this.bugCategoryList[count] = bugCategory;
                ++count;
            }
            this.viewPanelLayout = (CardLayout)this.viewPanel.getLayout();
            for (JTree bugTree : this.bugTreeList = new JTree[]{this.byClassBugTree, this.byPackageBugTree, this.byBugTypeBugTree, this.byBugCategoryBugTree}) {
                bugTree.getSelectionModel().setSelectionMode(1);
                bugTree.setCellRenderer(BugCellRenderer.instance());
                bugTree.setRootVisible(false);
                bugTree.setShowsRootHandles(true);
                bugTree.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent e) {
                        FindBugsFrame.this.bugTreeSelectionChanged(e);
                    }
                });
            }
            this.jarFileList.setModel(new DefaultListModel());
            this.sourceDirList.setModel(new DefaultListModel());
            this.classpathEntryList.setModel(new DefaultListModel());
            final DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(this.sourceTextArea.getSelectionColor()){

                public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
                    try {
                        Shape extent = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                        Rectangle rect = extent.getBounds();
                        rect.x = 0;
                        rect.width = bounds.getBounds().width;
                        g.setColor(this.getColor());
                        g.fillRect(rect.x, rect.y, rect.width, rect.height);
                        return rect;
                    }
                    catch (BadLocationException e) {
                        return null;
                    }
                }
            };
            DefaultHighlighter sourceHighlighter = new DefaultHighlighter(){

                public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
                    return super.addHighlight(p0, p1, painter);
                }
            };
            this.sourceTextArea.setHighlighter(sourceHighlighter);
            this.updateTitle(this.getCurrentProject());
            ClassLoader classLoader = this.getClass().getClassLoader();
            ImageIcon logoIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/logo_umd.png"));
            this.logoLabel.setIcon(logoIcon);
            int MENU_MASK = FindBugsFrame.getMenuMask();
            this.newProjectItem.setAccelerator(KeyStroke.getKeyStroke(78, MENU_MASK));
            this.openProjectItem.setAccelerator(KeyStroke.getKeyStroke(79, MENU_MASK));
            this.saveProjectItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_MASK));
            this.closeProjectItem.setAccelerator(KeyStroke.getKeyStroke(87, MENU_MASK));
            this.reloadProjectItem.setAccelerator(KeyStroke.getKeyStroke(82, MENU_MASK));
            this.cutItem.setAccelerator(KeyStroke.getKeyStroke(88, MENU_MASK));
            this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, MENU_MASK));
            this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, MENU_MASK));
            this.selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, MENU_MASK));
            if (MAC_OS_X) {
                this.saveProjectAsItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_MASK | 1));
                this.loadBugsItem.setAccelerator(KeyStroke.getKeyStroke(79, MENU_MASK | 8));
                this.saveBugsItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_MASK | 8));
                this.growBoxSpacer.setMinimumSize(new Dimension(16, 16));
                this.fileMenu.remove(this.exitItem);
                this.fileMenu.remove(this.jSeparator6);
                this.theMenuBar.remove(this.helpMenu);
                try {
                    Class<?> osxAdapter = Class.forName("edu.umd.cs.findbugs.gui.OSXAdapter");
                    Class[] defArgs = new Class[]{FindBugsFrame.class};
                    Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                    if (registerMethod != null) {
                        Object[] args = new Object[]{this};
                        registerMethod.invoke(osxAdapter, args);
                    }
                }
                catch (NoClassDefFoundError e) {
                    System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                }
                catch (ClassNotFoundException e) {
                    System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                }
                catch (Exception e) {
                    System.err.println("Exception while loading the OSXAdapter: " + e);
                    if (!FindBugs.DEBUG) break block8;
                    e.printStackTrace();
                }
            }
        }
    }

    private void rebuildRecentProjectsMenu() {
        UserPreferences prefs = UserPreferences.getUserPreferences();
        final List<String> recentProjects = prefs.getRecentProjects();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindBugsFrame.this.recentProjectsMenu.removeAll();
                Font ft = BUTTON_FONT;
                if (recentProjects.size() == 0) {
                    JMenuItem emptyItem = new JMenuItem(L10N.getLocalString("menu.empty_item", "Empty"));
                    emptyItem.setFont(ft);
                    emptyItem.setEnabled(false);
                    FindBugsFrame.this.recentProjectsMenu.add(emptyItem);
                } else {
                    for (String recentProject : recentProjects) {
                        JMenuItem projectItem = new JMenuItem(recentProject);
                        projectItem.setFont(ft);
                        projectItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent evt) {
                                FindBugsFrame.this.openRecentProjectItemActionPerformed(evt);
                            }
                        });
                        FindBugsFrame.this.recentProjectsMenu.add(projectItem);
                    }
                }
            }
        });
    }

    private static <E> E getTreeSelectionOf(JTree tree, Class<E> c) {
        TreePath selPath = tree.getSelectionPath();
        if (selPath == null) {
            return null;
        }
        Object[] nodeList = selPath.getPath();
        for (int i = nodeList.length - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeList[i];
            Object nodeInfo = node.getUserObject();
            if (nodeInfo == null || nodeInfo.getClass() != c) continue;
            return c.cast(nodeInfo);
        }
        return null;
    }

    private Project getCurrentProject() {
        return this.currentProject;
    }

    private AnalysisRun getCurrentAnalysisRun() {
        return this.currentAnalysisRun;
    }

    private BugInstance getCurrentBugInstance() {
        JTree bugTree = this.getCurrentBugTree();
        if (bugTree != null) {
            return FindBugsFrame.getTreeSelectionOf(bugTree, BugInstance.class);
        }
        return null;
    }

    private boolean isSplitterMaximized(JSplitPane splitter, PropertyChangeEvent evt) {
        Integer location = (Integer)evt.getNewValue();
        int height = splitter.getHeight();
        int hopefullyMaxDivider = height - (splitter.getDividerSize() + 3);
        boolean isMaximized = location >= hopefullyMaxDivider;
        return isMaximized;
    }

    private void checkBugDetailsVisibility() {
        if (this.viewBugDetailsItem.isSelected()) {
            this.bugTreeBugDetailsSplitter.resetToPreferredSizes();
        } else {
            this.bugTreeBugDetailsSplitter.setDividerLocation(1.0);
        }
    }

    private JTree getCurrentBugTree() {
        JScrollPane selected = (JScrollPane)this.groupByTabbedPane.getSelectedComponent();
        Component view = selected.getViewport().getView();
        if (view instanceof JTree) {
            return (JTree)view;
        }
        return null;
    }

    private void setPriorityThreshold(int threshold) {
        if (threshold != this.getFilterSettings().getMinPriorityAsInt()) {
            this.getFilterSettings().setMinPriority(ProjectFilterSettings.getIntPriorityAsString(threshold));
            if (this.currentAnalysisRun != null) {
                this.synchAnalysisRun(this.currentAnalysisRun);
            }
        }
    }

    private void ableEditMenu() {
        String view = this.getView();
        if (view != null && view.equals("EditProjectPanel")) {
            if (this.selectedComponent != null) {
                boolean hasSelection = false;
                if (this.selectedComponent instanceof JList) {
                    JList list = (JList)this.selectedComponent;
                    hasSelection = list.getSelectedIndices().length > 0;
                } else if (this.selectedComponent instanceof JTextField) {
                    JTextField tf = (JTextField)this.selectedComponent;
                    hasSelection = tf.getSelectedText() != null && tf.getSelectedText().length() > 0;
                }
                this.cutItem.setEnabled(hasSelection);
                this.copyItem.setEnabled(hasSelection);
                this.selectAllItem.setEnabled(true);
            }
        } else {
            this.cutItem.setEnabled(false);
            this.copyItem.setEnabled(true);
            this.pasteItem.setEnabled(false);
            this.selectAllItem.setEnabled(false);
        }
    }

    private void setProject(Project project) {
        this.currentProject = project;
        if (project != null) {
            this.synchProject(project);
            this.setView("EditProjectPanel");
            this.editMenu.setEnabled(true);
            this.viewProjectItem.setEnabled(true);
            this.viewProjectItem.setSelected(true);
            this.viewBugsItem.setEnabled(false);
            this.viewBugsItem.setSelected(false);
        } else {
            this.editMenu.setEnabled(false);
            this.viewProjectItem.setEnabled(false);
            this.viewProjectItem.setSelected(false);
            this.viewBugsItem.setEnabled(false);
            this.viewBugsItem.setSelected(false);
            this.setView("EmptyPanel");
        }
        this.updateTitle(project);
        this.ableEditMenu();
    }

    private void updateTitle(Project project) {
        if (project == null) {
            this.setTitle(L10N.getLocalString("dlg.noproject_lbl", "FindBugs - no project"));
        } else {
            this.setTitle("FindBugs - " + project.toString());
        }
    }

    private boolean saveProject(Project project, String dialogTitle) {
        return this.saveProject(project, dialogTitle, false);
    }

    private boolean saveProject(Project project, String dialogTitle, boolean chooseFilename) {
        try {
            boolean useRelativePaths;
            File file;
            if (project == null) {
                return true;
            }
            String fileName = project.getProjectFileName();
            if (!fileName.startsWith("<") && !chooseFilename) {
                file = new File(fileName);
                useRelativePaths = project.getOption("relative_paths");
            } else {
                JRadioButton relativePaths = new JRadioButton(L10N.getLocalString("msg.userelativepaths_txt", "Use Relative Paths"));
                relativePaths.setSelected(project.getOption("relative_paths"));
                JFileChooser chooser = this.createFileChooser(relativePaths);
                chooser.setFileFilter(projectFileFilter);
                int result = this.chooseFile(chooser, dialogTitle);
                if (result == 1) {
                    return false;
                }
                file = chooser.getSelectedFile();
                fileName = Project.transformFilename(file.getPath());
                file = new File(fileName);
                useRelativePaths = relativePaths.isSelected();
            }
            project.write(file.getPath(), useRelativePaths, file.getParent());
            this.logger.logMessage(0, "Project saved");
            project.setProjectFileName(file.getPath());
            UserPreferences prefs = UserPreferences.getUserPreferences();
            prefs.useProject(file.getPath());
            prefs.read();
            this.rebuildRecentProjectsMenu();
            this.updateTitle(project);
            return true;
        }
        catch (IOException e) {
            this.logger.logMessage(2, "Could not save project: " + e.toString());
            JOptionPane.showMessageDialog(this, "Error saving project: " + e.toString(), "Error", 0);
            return false;
        }
    }

    private boolean closeProjectHook(Project project, String savePromptTitle) {
        if (project == null || !project.isModified()) {
            return true;
        }
        int option = JOptionPane.showConfirmDialog(this, L10N.getLocalString("msg.saveprojectquery_txt", "Save Project?"), savePromptTitle, 1, 3);
        if (option == 2) {
            return false;
        }
        if (option == 0) {
            boolean result = this.saveProject(project, "Save Project");
            if (result) {
                JOptionPane.showMessageDialog(this, "Project was successfully saved.");
            }
            return result;
        }
        return true;
    }

    private void synchProject(Project project) {
        this.jarNameTextField.setText("");
        this.srcDirTextField.setText("");
        this.classpathEntryTextField.setText("");
        DefaultListModel jarListModel = (DefaultListModel)this.jarFileList.getModel();
        jarListModel.clear();
        for (int i = 0; i < project.getFileCount(); ++i) {
            jarListModel.addElement(project.getFile(i));
        }
        DefaultListModel srcDirListModel = (DefaultListModel)this.sourceDirList.getModel();
        srcDirListModel.clear();
        for (int i = 0; i < project.getNumSourceDirs(); ++i) {
            srcDirListModel.addElement(project.getSourceDir(i));
        }
        DefaultListModel classpathEntryListModel = (DefaultListModel)this.classpathEntryList.getModel();
        classpathEntryListModel.clear();
        for (int i = 0; i < project.getNumAuxClasspathEntries(); ++i) {
            classpathEntryListModel.addElement(project.getAuxClasspathEntry(i));
        }
    }

    private void synchAnalysisRun(AnalysisRun analysisRun) {
        for (int i = 0; i < GROUP_BY_ORDER_LIST.length; ++i) {
            DefaultMutableTreeNode bugRootNode = new DefaultMutableTreeNode();
            DefaultTreeModel bugTreeModel = new DefaultTreeModel(bugRootNode);
            String groupByOrder = GROUP_BY_ORDER_LIST[i];
            analysisRun.setTreeModel(groupByOrder, bugTreeModel);
            this.populateAnalysisRunTreeModel(analysisRun, groupByOrder);
            if (i >= this.bugTreeList.length) continue;
            this.bugTreeList[i].setModel(bugTreeModel);
        }
        this.currentAnalysisRun = analysisRun;
        this.setSummary(analysisRun.getSummary());
        this.setView("BugTree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSummary(String summaryXML) {
        this.bugSummaryEditorPane.setContentType("text/html");
        StringReader reader = null;
        try {
            if (summaryXML != null) {
                reader = new StringReader(summaryXML);
                this.bugSummaryEditorPane.read(reader, (Object)"html summary");
            } else {
                this.bugSummaryEditorPane.setText("");
            }
        }
        catch (IOException e) {
            this.bugSummaryEditorPane.setText("Could not set summary: " + e.getMessage());
            this.logger.logMessage(1, e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void populateAnalysisRunTreeModel(AnalysisRun analysisRun, final String groupBy) {
        Cursor orig = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        final DefaultTreeModel bugTreeModel = analysisRun.getTreeModel(groupBy);
        final DefaultMutableTreeNode bugRootNode = (DefaultMutableTreeNode)bugTreeModel.getRoot();
        bugRootNode.removeAllChildren();
        TreeSet<BugInstance> sortedCollection = new TreeSet<BugInstance>(this.getBugInstanceComparator(groupBy));
        for (BugInstance bugInstance : analysisRun.getBugInstances()) {
            if (!this.getFilterSettings().displayWarning(bugInstance)) continue;
            sortedCollection.add(bugInstance);
        }
        Grouper.Callback<BugInstance> callback = new Grouper.Callback<BugInstance>(){
            private BugInstanceGroup currentGroup;
            private DefaultMutableTreeNode currentGroupNode;

            @Override
            public void startGroup(BugInstance member) {
                String groupName;
                if (groupBy == FindBugsFrame.GROUP_BY_CLASS) {
                    groupName = member.getPrimaryClass().getClassName();
                } else if (groupBy == FindBugsFrame.GROUP_BY_PACKAGE) {
                    groupName = member.getPrimaryClass().getPackageName();
                    if (groupName.equals("")) {
                        groupName = "Unnamed package";
                    }
                } else if (groupBy == FindBugsFrame.GROUP_BY_BUG_TYPE) {
                    String desc = member.toString();
                    String shortBugType = desc.substring(0, desc.indexOf(58));
                    String bugTypeDescription = I18N.instance().getBugTypeDescription(shortBugType);
                    groupName = shortBugType + ": " + bugTypeDescription;
                } else if (groupBy == FindBugsFrame.GROUP_BY_BUG_CATEGORY) {
                    BugPattern pattern = member.getBugPattern();
                    if (pattern == null) {
                        if (FindBugs.DEBUG) {
                            System.out.println("Unknown bug pattern " + member.getType());
                        }
                        groupName = "Unknown category";
                    } else {
                        groupName = I18N.instance().getBugCategoryDescription(pattern.getCategory());
                    }
                } else {
                    throw new IllegalStateException("Unknown sort order: " + groupBy);
                }
                this.currentGroup = new BugInstanceGroup(groupBy, groupName);
                this.currentGroupNode = new DefaultMutableTreeNode(this.currentGroup);
                bugTreeModel.insertNodeInto(this.currentGroupNode, bugRootNode, bugRootNode.getChildCount());
                this.insertIntoGroup(member);
            }

            @Override
            public void addToGroup(BugInstance member) {
                this.insertIntoGroup(member);
            }

            private void insertIntoGroup(BugInstance member) {
                int count = this.currentGroup.getMemberCount();
                this.currentGroup.incrementMemberCount();
                BugTreeNode bugNode = new BugTreeNode(member);
                if (BUG_COUNT) {
                    bugNode.setCount(count);
                }
                bugTreeModel.insertNodeInto(bugNode, this.currentGroupNode, this.currentGroupNode.getChildCount());
                Iterator<BugAnnotation> j = member.annotationIterator();
                while (j.hasNext()) {
                    BugAnnotation annotation = j.next();
                    DefaultMutableTreeNode annotationNode = new DefaultMutableTreeNode(annotation);
                    bugTreeModel.insertNodeInto(annotationNode, bugNode, bugNode.getChildCount());
                }
            }
        };
        Grouper<BugInstance> grouper = new Grouper<BugInstance>(callback);
        Comparator<BugInstance> groupComparator = this.getGroupComparator(groupBy);
        grouper.group(sortedCollection, groupComparator);
        bugTreeModel.nodeStructureChanged(bugRootNode);
        this.setCursor(orig);
    }

    private Comparator<BugInstance> getBugInstanceComparator(String sortOrder) {
        if (sortOrder.equals(GROUP_BY_CLASS)) {
            return bugInstanceByClassComparator;
        }
        if (sortOrder.equals(GROUP_BY_PACKAGE)) {
            return bugInstanceByPackageComparator;
        }
        if (sortOrder.equals(GROUP_BY_BUG_TYPE)) {
            return bugInstanceByTypeComparator;
        }
        if (sortOrder.equals(GROUP_BY_BUG_CATEGORY)) {
            return bugInstanceByCategoryComparator;
        }
        throw new IllegalArgumentException("Bad sort order: " + sortOrder);
    }

    private Comparator<BugInstance> getGroupComparator(String groupBy) {
        if (groupBy.equals(GROUP_BY_CLASS)) {
            return bugInstanceClassComparator;
        }
        if (groupBy.equals(GROUP_BY_PACKAGE)) {
            return bugInstancePackageComparator;
        }
        if (groupBy.equals(GROUP_BY_BUG_TYPE)) {
            return bugInstanceTypeComparator;
        }
        if (groupBy.equals(GROUP_BY_BUG_CATEGORY)) {
            return bugInstanceCategoryComparator;
        }
        throw new IllegalArgumentException("Bad sort order: " + groupBy);
    }

    private void setView(String viewName) {
        this.viewPanelLayout.show(this.viewPanel, viewName);
        boolean viewingBugs = viewName.equals("BugTree");
        if (viewingBugs) {
            this.checkBugDetailsVisibility();
        }
        this.viewProjectItem.setSelected(!viewingBugs);
        if (viewingBugs) {
            this.viewBugsItem.setEnabled(true);
        }
        this.viewBugsItem.setSelected(viewingBugs);
        this.currentView = viewName;
        this.ableEditMenu();
    }

    private String getView() {
        return this.currentView;
    }

    private void addJarToList() {
        String[] jarDirs;
        String dirs = this.jarNameTextField.getText();
        for (String jarFile : jarDirs = this.parsePaths(dirs)) {
            if (jarFile.equals("")) continue;
            this.addJarToProject(jarFile);
        }
        this.jarNameTextField.setText("");
    }

    private void addSrcToProject(String srcFile) {
        Project project = this.getCurrentProject();
        if (project.addSourceDir(srcFile)) {
            DefaultListModel listModel = (DefaultListModel)this.sourceDirList.getModel();
            listModel.addElement(srcFile);
        }
    }

    private void addJarToProject(String jarFile) {
        Project project = this.getCurrentProject();
        if (project.addFile(jarFile)) {
            DefaultListModel listModel = (DefaultListModel)this.jarFileList.getModel();
            listModel.addElement(jarFile);
        }
    }

    private String[] parsePaths(String paths) {
        return paths.split(SystemProperties.getProperty("path.separator"));
    }

    private void addSourceDirToList() {
        String[] sourceDirs;
        String dirs = this.srcDirTextField.getText();
        for (String sourceDir : sourceDirs = this.parsePaths(dirs)) {
            Project project;
            if (sourceDir.equals("") || !(project = this.getCurrentProject()).addSourceDir(sourceDir)) continue;
            DefaultListModel listModel = (DefaultListModel)this.sourceDirList.getModel();
            listModel.addElement(sourceDir);
        }
        this.srcDirTextField.setText("");
    }

    private void addClasspathEntryToList() {
        String[] classDirs;
        String dirs = this.classpathEntryTextField.getText();
        for (String classpathEntry : classDirs = this.parsePaths(dirs)) {
            if (classpathEntry.equals("")) continue;
            this.addClasspathEntryToProject(classpathEntry);
        }
        this.classpathEntryTextField.setText("");
    }

    private void addClasspathEntryToProject(String classpathEntry) {
        Project project = this.getCurrentProject();
        if (project.addAuxClasspathEntry(classpathEntry)) {
            DefaultListModel listModel = (DefaultListModel)this.classpathEntryList.getModel();
            listModel.addElement(classpathEntry);
        }
    }

    private void synchBugInstance() {
        BugInstance selected = this.getCurrentBugInstance();
        if (selected == null) {
            return;
        }
        if (!this.viewBugDetailsItem.isSelected()) {
            return;
        }
        JTree bugTree = this.getCurrentBugTree();
        if (bugTree == null) {
            return;
        }
        SourceLineAnnotation srcLine = null;
        TreePath selPath = bugTree.getSelectionPath();
        if (selPath != null) {
            Object leaf = ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
            if (leaf instanceof SourceLineAnnotation) {
                srcLine = (SourceLineAnnotation)leaf;
            } else if (leaf instanceof BugAnnotationWithSourceLines) {
                srcLine = ((BugAnnotationWithSourceLines)leaf).getSourceLines();
            }
            if (srcLine == null) {
                srcLine = selected.getPrimarySourceLineAnnotation();
            }
        }
        if (srcLine == null || srcLine != this.currentSourceLineAnnotation) {
            Project project = this.getCurrentProject();
            AnalysisRun analysisRun = this.getCurrentAnalysisRun();
            if (project == null) {
                throw new IllegalStateException("null project!");
            }
            if (analysisRun == null) {
                throw new IllegalStateException("null analysis run!");
            }
            try {
                boolean success = this.viewSource(project, analysisRun, srcLine);
                this.sourceTextArea.setEnabled(success);
                if (!success) {
                    this.sourceTextArea.setText("No source line information for this bug");
                }
            }
            catch (IOException e) {
                this.sourceTextArea.setText("Could not find source: " + e.getMessage());
                this.logger.logMessage(1, e.getMessage());
            }
            this.currentSourceLineAnnotation = srcLine;
        }
        this.showBugInfo(selected);
        this.synchBugAnnotation(selected);
        this.currentBugInstance = selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean viewSource(Project project, AnalysisRun analysisRun, final SourceLineAnnotation srcLine) throws IOException {
        InputStream in;
        String sourceFile;
        this.sourceTextArea.setText("");
        if (srcLine == null) {
            return false;
        }
        this.sourceFinder.setSourceBaseList(project.getSourceDirList());
        try {
            SourceFile source = this.sourceFinder.findSourceFile(srcLine);
            sourceFile = source.getFullFileName();
            in = source.getInputStream();
        }
        catch (IOException e) {
            this.logger.logMessage(1, "No source file for class " + srcLine.getClassName());
            return false;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            this.sourceTextArea.read(reader, sourceFile);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (srcLine.isUnknown()) {
            return true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    int startLine = srcLine.getStartLine() - 1;
                    int endLine = srcLine.getEndLine();
                    JViewport viewport = FindBugsFrame.this.sourceTextAreaScrollPane.getViewport();
                    Rectangle viewportRect = viewport.getViewRect();
                    int topRow = FindBugsFrame.this.sourceTextArea.getLineOfOffset(FindBugsFrame.this.sourceTextArea.viewToModel(viewportRect.getLocation()));
                    int bottomRow = FindBugsFrame.this.sourceTextArea.getLineOfOffset(FindBugsFrame.this.sourceTextArea.viewToModel(new Point(viewportRect.x, viewportRect.y + viewportRect.height - 1)));
                    int numRowsVisible = bottomRow - topRow;
                    int viewLine = Math.max(startLine - (numRowsVisible > 0 ? numRowsVisible / 2 : 0), 0);
                    int viewBegin = FindBugsFrame.this.sourceTextArea.getLineStartOffset(viewLine);
                    Rectangle viewRect = FindBugsFrame.this.sourceTextArea.modelToView(viewBegin);
                    viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                    int selBegin = FindBugsFrame.this.sourceTextArea.getLineStartOffset(startLine);
                    int selEnd = FindBugsFrame.this.sourceTextArea.getLineStartOffset(endLine);
                    FindBugsFrame.this.sourceTextArea.select(selBegin, selEnd);
                    FindBugsFrame.this.sourceTextArea.getCaret().setSelectionVisible(true);
                }
                catch (BadLocationException e) {
                    FindBugsFrame.this.logger.logMessage(2, e.toString());
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showBugInfo(BugInstance bugInstance) {
        String bugDetailsKey = bugInstance.getType();
        if (bugDetailsKey.equals(this.currentBugDetailsKey)) {
            return;
        }
        String html = I18N.instance().getDetailHTML(bugDetailsKey);
        this.bugDescriptionEditorPane.setContentType("text/html");
        this.currentBugDetailsKey = bugDetailsKey;
        StringReader reader = new StringReader(html);
        try {
            this.bugDescriptionEditorPane.read(reader, (Object)"html bug description");
        }
        catch (IOException e) {
            this.bugDescriptionEditorPane.setText("Could not find bug description: " + e.getMessage());
            this.logger.logMessage(1, e.getMessage());
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchBugAnnotation(BugInstance selected) {
        String userAnnotation;
        if (this.currentBugInstance != null) {
            String text = this.annotationTextArea.getText();
            this.currentBugInstance.setAnnotationText(text);
        }
        if ((userAnnotation = selected.getAnnotationText()) == null || userAnnotation.length() == 0) {
            this.annotationTextArea.setText("");
            return;
        }
        StringReader reader = new StringReader(userAnnotation);
        try {
            this.annotationTextArea.read(reader, "user annotation");
        }
        catch (IOException e) {
            this.annotationTextArea.setText("Could not find user annotation: " + e.getMessage());
            this.logger.logMessage(1, e.getMessage());
        }
        finally {
            reader.close();
        }
    }

    private void toggleBugCategory(JCheckBoxMenuItem checkBox) {
        int index;
        for (index = 0; index < this.bugCategoryCheckBoxList.length && this.bugCategoryCheckBoxList[index] != checkBox; ++index) {
        }
        if (index == this.bugCategoryCheckBoxList.length) {
            this.error("Could not find bug category checkbox");
            return;
        }
        boolean selected = checkBox.isSelected();
        String bugCategory = this.bugCategoryList[index];
        if (selected) {
            this.getFilterSettings().addCategory(bugCategory);
        } else {
            this.getFilterSettings().removeCategory(bugCategory);
        }
        if (this.currentAnalysisRun != null) {
            this.synchAnalysisRun(this.currentAnalysisRun);
        }
    }

    void about() {
        AboutDialog dialog = new AboutDialog(this, this.logger, true);
        dialog.setSize(600, 554);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    void exitFindBugs() {
        UserPreferences.getUserPreferences().write();
        System.exit(0);
    }

    private JFileChooser createFileChooser() {
        return new JFileChooser(this.currentDirectory);
    }

    private JFileChooser createFileChooser(final JComponent extraComp) {
        return new JFileChooser(this.currentDirectory){
            private static final long serialVersionUID = 1L;

            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                dialog.getContentPane().add((Component)extraComp, "South");
                dialog.setLocation(300, 200);
                dialog.setResizable(false);
                return dialog;
            }
        };
    }

    private int chooseFile(JFileChooser dialog, String dialogTitle) {
        int outcome = dialog.showDialog(this, dialogTitle);
        return this.updateCurrentDirectoryFromDialog(dialog, outcome);
    }

    private int chooseFileToOpen(JFileChooser dialog) {
        int outcome = dialog.showOpenDialog(this);
        return this.updateCurrentDirectoryFromDialog(dialog, outcome);
    }

    private int updateCurrentDirectoryFromDialog(JFileChooser dialog, int outcome) {
        if (outcome != 1) {
            File selectedFile = dialog.getSelectedFile();
            this.currentDirectory = selectedFile.getParentFile();
        }
        return outcome;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    @Override
    public void writeToLog(String message) {
    }

    public File verifyFileSelection(File pickedFile) {
        if (pickedFile.exists()) {
            return pickedFile;
        }
        File parent = pickedFile.getParentFile();
        if (parent != null && parent.getName().equals(pickedFile.getName())) {
            return parent;
        }
        return pickedFile;
    }

    public ProjectFilterSettings getFilterSettings() {
        return UserPreferences.getUserPreferences().getFilterSettings();
    }

    public int getPriorityThreshold() {
        return this.getFilterSettings().getMinPriorityAsInt();
    }

    public AnalysisFeatureSetting[] getSettingList() {
        return this.settingList;
    }

    public static void main(String[] args) throws IOException {
        Project project = null;
        SwingCommandLine commandLine = new SwingCommandLine();
        try {
            commandLine.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            FindBugsFrame.showSynopsis();
            ShowHelp.showGeneralOptions();
            FindBugsFrame.showCommandLineOptions();
            System.exit(1);
        }
        catch (CommandLine.HelpRequestedException e) {
            FindBugsFrame.showSynopsis();
            ShowHelp.showGeneralOptions();
            FindBugsFrame.showCommandLineOptions();
            System.exit(1);
        }
        if (commandLine.getProject().getFileCount() > 0) {
            project = commandLine.getProject();
        }
        DetectorFactoryCollection.instance();
        FindBugsFrame frame = new FindBugsFrame();
        if (project != null) {
            frame.setProject(project);
        } else if (commandLine.getBugsFilename().length() > 0) {
            try {
                File bugsFile = new File(commandLine.getBugsFilename());
                frame.loadBugsFromFile(bugsFile);
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        } else if (SystemProperties.getProperty("findbugs.loadBugsFromURL") != null) {
            try {
                String urlspec = SystemProperties.getProperty("findbugs.loadBugsFromURL");
                frame.loadBugsFromURL(urlspec);
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
        frame.setPriority(commandLine.getPriority());
        if (commandLine.getSettingList() != null) {
            frame.settingList = commandLine.getSettingList();
            if (Arrays.equals(frame.settingList, FindBugs.MIN_EFFORT)) {
                frame.minEffortItem.setSelected(true);
            } else if (Arrays.equals(frame.settingList, FindBugs.MAX_EFFORT)) {
                frame.maxEffortItem.setSelected(true);
            }
        }
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public void setPriority(int priority) {
        this.analysisPriority = priority;
    }

    public static void showCommandLineOptions() {
        System.out.println("GUI options:");
        new SwingCommandLine().printUsage(System.out);
    }

    public static void showSynopsis() {
        System.out.println("Usage: findbugs [general options] [gui options]");
    }

    private static int getMenuMask() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    static {
        archiveExtensionSet.add(".jar");
        archiveExtensionSet.add(".zip");
        archiveExtensionSet.add(".ear");
        archiveExtensionSet.add(".war");
        archiveExtensionSet.add(".sar");
        archiveAndDirectoryFilter = new ArchiveAndDirectoryFilter();
        GROUP_BY_ORDER_LIST = new String[]{GROUP_BY_CLASS, GROUP_BY_PACKAGE, GROUP_BY_BUG_TYPE, GROUP_BY_BUG_CATEGORY};
        BUG_COUNT = SystemProperties.getBoolean("findbugs.gui.bugCount");
        MAC_OS_X = SystemProperties.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    private static class SwingCommandLine
    extends FindBugsCommandLine {
        String bugsFilename = "";
        private int priority = 4;

        public SwingCommandLine() {
            this.addSwitch("-debug", "enable debug output");
            this.addSwitchWithOptionalExtraPart("-look", "plastic|gtk|native", "set look and feel");
            this.addOption("-project", "project file", "load given project");
            this.addOption("-priority", "thread priority", "set analysis thread's priority level (default is 4)");
            this.addOption("-loadbugs", "bugs xml filename", "load given bugs xml file");
        }

        public String getBugsFilename() {
            return this.bugsFilename;
        }

        public int getPriority() {
            return this.priority;
        }

        protected void handleOption(String option, String optionExtraPart) {
            if (option.equals("-debug")) {
                System.out.println("Setting findbugs.debug=true");
                System.setProperty("findbugs.debug", "true");
            } else if (option.equals("-look")) {
                String arg = optionExtraPart;
                String theme = null;
                if (arg.equals("plastic")) {
                    theme = "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
                } else if (arg.equals("gtk")) {
                    theme = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                } else if (arg.equals("native")) {
                    theme = UIManager.getSystemLookAndFeelClassName();
                } else {
                    System.err.println("Style '" + arg + "' not supported");
                }
                if (theme != null) {
                    try {
                        UIManager.setLookAndFeel(theme);
                    }
                    catch (Exception e) {
                        System.err.println("Couldn't load " + arg + " look and feel: " + e.toString());
                    }
                }
            } else {
                super.handleOption(option, optionExtraPart);
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-loadbugs")) {
                this.bugsFilename = argument;
            } else if (option.equals("-priority")) {
                int num;
                try {
                    num = Integer.parseInt(argument);
                }
                catch (NumberFormatException e) {
                    num = 4;
                }
                this.priority = num;
            } else {
                super.handleOptionWithArgument(option, argument);
            }
        }
    }

    private static class ArchiveAndDirectoryFilter
    extends FileFilter {
        private ArchiveAndDirectoryFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String fileName = file.getName();
            int dot = fileName.lastIndexOf(46);
            if (dot < 0) {
                return false;
            }
            String extension = fileName.substring(dot);
            return archiveExtensionSet.contains(extension);
        }

        public String getDescription() {
            return L10N.getLocalString("dlg.javaarchives_lbl", "Java archives (*.jar,*.zip,*.ear,*.war,*.sar)");
        }
    }

    private static class XMLFileFilter
    extends FileFilter {
        private XMLFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".xml");
        }

        public String getDescription() {
            return L10N.getLocalString("dlg.xmlsavedbugs_lbl", "XML saved bug files");
        }
    }

    private static class AuxClasspathEntryFileFilter
    extends FileFilter {
        private AuxClasspathEntryFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jar");
        }

        public String getDescription() {
            return L10N.getLocalString("dlg.jarsanddirectories_lbl", "Jar files and directories");
        }
    }

    private static class ProjectFileFilter
    extends FileFilter {
        private ProjectFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".fb");
        }

        public String getDescription() {
            return L10N.getLocalString("dlg.findbugsprojects_lbl", "FindBugs projects (*.fb)");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByCategoryComparator
    implements Comparator<BugInstance>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BugInstanceByCategoryComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstanceCategoryComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByTypeComparator
    implements Comparator<BugInstance>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BugInstanceByTypeComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstanceTypeComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByPackageComparator
    implements Comparator<BugInstance> {
        private BugInstanceByPackageComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstancePackageComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByClassComparator
    implements Comparator<BugInstance>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BugInstanceByClassComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstanceClassComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceCategoryComparator
    implements Comparator<BugInstance>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BugInstanceCategoryComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            return this.getCategory(lhs).compareTo(this.getCategory(rhs));
        }

        private String getCategory(BugInstance warning) {
            BugPattern bugPattern = warning.getBugPattern();
            if (bugPattern == null) {
                if (FindBugs.DEBUG) {
                    System.out.println("Unknown bug pattern for bug type: " + warning.getType());
                }
                return "";
            }
            return bugPattern.getCategory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceTypeComparator
    implements Comparator<BugInstance>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BugInstanceTypeComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            String lhsString = lhs.toString();
            String rhsString = rhs.toString();
            return lhsString.substring(0, lhsString.indexOf(58)).compareTo(rhsString.substring(0, rhsString.indexOf(58)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstancePackageComparator
    implements Comparator<BugInstance>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BugInstancePackageComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            return lhs.getPrimaryClass().getPackageName().compareTo(rhs.getPrimaryClass().getPackageName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceClassComparator
    implements Comparator<BugInstance> {
        private BugInstanceClassComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            return lhs.getPrimaryClass().compareTo(rhs.getPrimaryClass());
        }
    }

    private class BugTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private int count;

        public BugTreeNode(BugInstance bugInstance) {
            super(bugInstance);
            this.count = -1;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String toString() {
            try {
                BugInstance bugInstance = (BugInstance)this.getUserObject();
                StringBuilder result = new StringBuilder();
                if (this.count >= 0) {
                    result.append(this.count);
                    result.append(": ");
                }
                if (bugInstance.isExperimental()) {
                    result.append(L10N.getLocalString("msg.exp_txt", "EXP: "));
                }
                result.append(FindBugsFrame.this.fullDescriptionsItem.isSelected() ? bugInstance.getMessage() : bugInstance.toString());
                return result.toString();
            }
            catch (Exception e) {
                return MessageFormat.format(L10N.getLocalString("msg.errorformatting_txt", "Error formatting message for bug: "), e.toString());
            }
        }
    }
}

