/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.io.Serializable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.jmx.JChannelMBean;
import org.jgroups.jmx.JmxConfigurator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JChannel
implements JChannelMBean {
    org.jgroups.JChannel channel;
    String props = null;
    String group_name = "TestGroup";
    String object_name = null;
    Log log = LogFactory.getLog(this.getClass());
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    private String mbean_server_name = null;

    public JChannel() {
    }

    public JChannel(org.jgroups.JChannel channel) {
        this.channel = channel;
        this.setValues();
    }

    protected final void setValues() {
        if (this.channel != null) {
            this.props = this.getProperties();
            this.group_name = this.channel.getClusterName();
            this.receive_blocks = this.getReceiveBlockEvents();
            this.receive_local_msgs = this.getReceiveLocalMessages();
            this.auto_reconnect = this.getAutoReconnect();
            this.auto_getstate = this.getAutoGetState();
        }
    }

    @Override
    public org.jgroups.JChannel getChannel() {
        return this.channel;
    }

    @Override
    public String getVersion() {
        return Version.printDescription();
    }

    public String getMBeanServerName() {
        return this.mbean_server_name;
    }

    public void setMBeanServerName(String n) {
        this.mbean_server_name = n;
    }

    @Override
    public String getProperties() {
        this.props = this.channel.getProperties();
        return this.props;
    }

    @Override
    public void setProperties(String props) {
        this.props = props;
    }

    @Override
    public String getObjectName() {
        return this.object_name;
    }

    @Override
    public void setObjectName(String name) {
        this.object_name = name;
    }

    @Override
    public int getNumberOfTasksInTimer() {
        return this.channel.getNumberOfTasksInTimer();
    }

    @Override
    public String dumpTimerQueue() {
        return this.channel.dumpTimerQueue();
    }

    @Override
    public void setClusterConfig(Element config) {
        StringBuilder buffer = new StringBuilder();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        this.setProperties(buffer.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting cluster properties from xml to: " + this.props));
        }
    }

    @Override
    public String getGroupName() {
        if (this.channel != null) {
            this.group_name = this.channel.getClusterName();
        }
        return this.group_name;
    }

    @Override
    public void setGroupName(String group_name) {
        this.group_name = group_name;
    }

    @Override
    public String getClusterName() {
        return this.getGroupName();
    }

    @Override
    public void setClusterName(String cluster_name) {
        this.setGroupName(cluster_name);
    }

    @Override
    public boolean getReceiveBlockEvents() {
        if (this.channel != null) {
            this.receive_blocks = (Boolean)this.channel.getOpt(0);
        }
        return this.receive_blocks;
    }

    @Override
    public void setReceiveBlockEvents(boolean flag) {
        this.receive_blocks = flag;
        if (this.channel != null) {
            this.channel.setOpt(0, flag);
        }
    }

    @Override
    public boolean getReceiveLocalMessages() {
        if (this.channel != null) {
            this.receive_local_msgs = (Boolean)this.channel.getOpt(3);
        }
        return this.receive_local_msgs;
    }

    @Override
    public void setReceiveLocalMessages(boolean flag) {
        this.receive_local_msgs = flag;
        if (this.channel != null) {
            this.channel.setOpt(3, flag);
        }
    }

    @Override
    public boolean getAutoReconnect() {
        if (this.channel != null) {
            this.auto_reconnect = (Boolean)this.channel.getOpt(5);
        }
        return this.auto_reconnect;
    }

    @Override
    public void setAutoReconnect(boolean flag) {
        this.auto_reconnect = flag;
        if (this.channel != null) {
            this.channel.setOpt(5, flag);
        }
    }

    @Override
    public boolean getAutoGetState() {
        if (this.channel != null) {
            this.auto_getstate = (Boolean)this.channel.getOpt(6);
        }
        return this.auto_getstate;
    }

    @Override
    public void setAutoGetState(boolean flag) {
        this.auto_getstate = flag;
        if (this.channel != null) {
            this.channel.setOpt(6, flag);
        }
    }

    @Override
    public boolean getStatsEnabled() {
        return this.channel.statsEnabled();
    }

    @Override
    public void setStatsEnabled(boolean flag) {
        this.channel.enableStats(flag);
    }

    @Override
    public Map dumpStats() {
        return this.channel.dumpStats();
    }

    @Override
    public void resetStats() {
        this.channel.resetStats();
    }

    @Override
    public long getSentMessages() {
        return this.channel.getSentMessages();
    }

    @Override
    public long getSentBytes() {
        return this.channel.getSentBytes();
    }

    @Override
    public long getReceivedMessages() {
        return this.channel.getReceivedMessages();
    }

    @Override
    public long getReceivedBytes() {
        return this.channel.getReceivedBytes();
    }

    @Override
    public int getTimerThreads() {
        return this.channel.getTimerThreads();
    }

    @Override
    public void create() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = new org.jgroups.JChannel(this.props);
        this.setOptions();
        this.setValues();
        MBeanServer server = MBeanServerFactory.findMBeanServer(this.mbean_server_name).get(0);
        JmxConfigurator.registerProtocols(server, this.channel, this.getObjectName());
    }

    @Override
    public void start() throws Exception {
        this.channel.connect(this.group_name);
    }

    @Override
    public void stop() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    @Override
    public void destroy() {
        MBeanServer server = MBeanServerFactory.findMBeanServer(this.mbean_server_name).get(0);
        JmxConfigurator.unregisterProtocols(server, this.channel, this.getObjectName());
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public View getView() {
        return this.channel.getView();
    }

    @Override
    public String getViewAsString() {
        View v = this.channel.getView();
        return v != null ? v.toString() : "n/a";
    }

    @Override
    public Address getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public String getLocalAddressAsString() {
        Address addr = this.getLocalAddress();
        return addr != null ? addr.toString() : "n/a";
    }

    @Override
    public void setChannelListener(ChannelListener channel_listener) {
        if (this.channel != null) {
            this.channel.addChannelListener(channel_listener);
        }
    }

    public void addChannelListener(ChannelListener listener) {
        if (this.channel != null) {
            this.channel.addChannelListener(listener);
        }
    }

    public void removeChannelListener(ChannelListener l) {
        if (this.channel != null) {
            this.channel.removeChannelListener(l);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public int getNumMessages() {
        return this.channel.getNumMessages();
    }

    @Override
    public String dumpQueue() {
        return this.channel.dumpQueue();
    }

    @Override
    public String printProtocolSpec(boolean include_properties) {
        return this.channel.printProtocolSpec(include_properties);
    }

    @Override
    public String toString(boolean print_details) {
        return this.channel.toString(print_details);
    }

    @Override
    public void connect(String channel_name) throws ChannelException {
        this.channel.connect(channel_name);
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void shutdown() {
        this.channel.shutdown();
    }

    @Override
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.channel.send(msg);
    }

    @Override
    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.channel.send(dst, src, obj);
    }

    @Override
    public void sendToAll(String msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(null, null, (Serializable)((Object)msg));
    }

    @Override
    public void down(Event evt) {
        this.channel.down(evt);
    }

    @Override
    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        return this.channel.receive(timeout);
    }

    @Override
    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        return this.channel.peek(timeout);
    }

    @Override
    public void blockOk() {
        this.channel.blockOk();
    }

    @Override
    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.channel.getState(target, timeout);
    }

    @Override
    public void returnState(byte[] state) {
        this.channel.returnState(state);
    }

    @Override
    public void returnState(byte[] state, String state_id) {
        this.channel.returnState(state, state_id);
    }

    private void setOptions() {
        this.channel.setOpt(0, this.receive_blocks);
        this.channel.setOpt(3, this.receive_local_msgs);
        this.channel.setOpt(5, this.auto_reconnect);
        this.channel.setOpt(6, this.auto_getstate);
    }
}

