/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.server.jbossas5;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;

/**
 * SPI factory delegating to kernel for bean lookups
 * 
 * @author richard.opalka@jboss.com
 * @author Heiko.Braun@jboss.com
 */
public class KernelAwareSPIFactory
{
   @SuppressWarnings("unchecked")
   public <T> T getKernelProvidedSPI(String beanName, Class<T> spiArtifact)
   {
      KernelController controller = KernelLocator.getKernel().getController();
      ControllerContext ctx = controller.getInstalledContext(beanName);
      return (T)ctx.getTarget();
   }
}