/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jboss.soa.bpel.samples.quickstart.account;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * Account system endpoint implementation bean.
 * 
 * @author Alejandro Guizar
 * @version $Revision: 227 $ $Date: 2006/09/27 03:53:01 $
 */
@WebService(endpointInterface = "org.jboss.soa.bpel.samples.quickstart.account.AccountSystem", targetNamespace = "http://jbpm.org/examples/account", serviceName = "AccountService", portName = "AccountSystemPort")
public class AccountSystem_Impl implements AccountSystem {

	private static Map<String, Double> accounts = loadAccounts("accounts.xml");

	public boolean checkAccess(String customerName) {
		return accounts.containsKey(customerName);
	}

	public double queryBalance(String customerName) {
		return getBalance(customerName);
	}

	public double updateBalance(AccountOperation body) {
		String customerName = body.getCustomerName();
		double newBalance = getBalance(customerName) + body.getAmount();
		accounts.put(customerName, new Double(newBalance));
		return newBalance;
	}

	private double getBalance(String customerName) {
		Double balance = (Double) accounts.get(customerName);
		return balance.doubleValue();
	}

	private static Map<String, Double> loadAccounts(String resourceName) {
		try {
			// parse the accounts document
			DocumentBuilder domBuilder =
					DocumentBuilderFactory.newInstance().newDocumentBuilder();
			URL resource = AccountSystem_Impl.class.getResource(resourceName);
			if (resource == null) return Collections.emptyMap();
			Document accountsDocument = domBuilder.parse(resource.toString());
			// give everyone an initial balance of $50
			Double initialBalance = new Double(50);
			// iterate over the accounts
			Map<String, Double> accounts = new HashMap<String, Double>();
			Element accountsElem = accountsDocument.getDocumentElement();
			NodeList accountElems = accountsElem.getElementsByTagName("account");
			for (int i = 0, n = accountElems.getLength(); i < n; i++) {
				Element accountElem = (Element) accountElems.item(i);
				// create account, assign initial balance
				String customerName = accountElem.getAttribute("holder");
				accounts.put(customerName, initialBalance);
			}
			return accounts;
		}
		catch (ParserConfigurationException e) {
			// default configuration for document builder should work
			throw new AssertionError(e);
		}
		catch (SAXException e) {
			return Collections.emptyMap();
		}
		catch (IOException e) {
			return Collections.emptyMap();
		}
	}
}
