/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.gateway;

import junit.framework.TestCase;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.testutils.AbstractTestRunner;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.Client;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBRIntegratedUnitTest extends TestCase {

    protected void setUp() throws Exception {
        System.setProperty(Environment.DEFAULT_INVM_SCOPE, "GLOBAL");
    }

    protected void tearDown() throws Exception {
        System.setProperty(Environment.DEFAULT_INVM_SCOPE, "NONE");
    }

    public void test_JBESB_1428_01() throws Exception {
        new AbstractTestRunner() {
            public void test() throws Exception {
                String response = (String) sendMessageToServer("http://localhost:8769", "Hi there!!");
                assertEquals("<ack/>", response);
            }
        }.setServiceConfig("jbr-async-config-01.xml").run();
    }

/*
    public void test_JBESB_1428_02() throws Exception {
        new AbstractTestRunner() {
            public void test() throws Exception {
                String response = (String) sendMessageToServer("http://localhost:8769", "Hi there!!");
                assertEquals("<async_ack_from-file/>", response);
            }
        }.setServiceConfig("jbr-async-config-02.xml").run();
    }
*/

    private Object sendMessageToServer(String url, Object messagePayload) throws Exception {
        InvokerLocator locator = new InvokerLocator(url);

        Client remotingClient = null;
        try {
            remotingClient = new Client(locator);
            remotingClient.connect();

            try {
                return remotingClient.invoke(messagePayload);
            } catch (Throwable throwable) {
                throwable.printStackTrace();
                fail("Error making JBR Client invocation.");
                throw new Exception(); // keep the compiler happy!!
            }
        } finally {
            if(remotingClient != null) {
                remotingClient.disconnect();
            }
        }
    }

}
