/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Cache;

import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import static org.jboss.cache.notifications.event.Event.Type.*;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Daniel Bevenius
 * @author Tom Cunningham
 *
 */
public class DeleteOnEvictTreeCacheListenerIntegrationTest 
{
	@SuppressWarnings("unused")
	private Logger log = Logger .getLogger( DeleteOnEvictTreeCacheListenerIntegrationTest.class );
	
	private static DeleteOnEvictTreeCacheListener listener;
	private static Cache cache;
	
	private static final String FQN = "test/junit";
	private String key = "testKey";
	private String value = "testValue";
	private Fqn fqnTest = new Fqn ( new Object[] { FQN, key, value} );
	
	@Test
	public void nodeEvict() throws CacheException
	{
	        Node rootNode = cache.getRoot();
	        Node testNode = rootNode.addChild(fqnTest);
		testNode.put(key, value );
		String getValue = (String) cache.get(fqnTest, key);
		assertEquals( "The value should have been added!",  getValue, value);
		
		EventImpl nre = new EventImpl();
		nre.setFqn(fqnTest);
		nre.setType(Event.Type.NODE_REMOVED);
		listener.nodeEvicted(nre);
		getValue = (String) cache.get( fqnTest, key);
		assertFalse( "The value should have been removed upon eviction!",   getValue != null);
		
		getValue = (String) cache.get( fqnTest, false );
		assertNull ( "The node should have been removed from the cache store", getValue );
	}
	
	@Test
	public void testCacheRestart() throws Exception
	{
            Node rootNode = cache.getRoot();
            Node testNode = rootNode.addChild(fqnTest);
            testNode.put(key, value );

	    Object valueBeforeCacheShutdown = cache.get( fqnTest, key );
	    cache.stop();
	    cache.start();
	    Object valueAfterCacheShutdown = cache.get( fqnTest, key );
	    assertTrue( "Objects should be cleared after shutdown", valueAfterCacheShutdown == null );
	}
	
	@BeforeClass
	public static void classSetup() throws Exception
	{
		FtpFileCacheTestUtil.startDB();
		startCache();
	}
	
	private static void startCache() throws Exception
	{
	        CacheFactory factory = DefaultCacheFactory.getInstance();
                cache = factory.createCache();

		listener = new DeleteOnEvictTreeCacheListener( cache );
		cache.addCacheListener( listener );
		FtpFileCacheTestUtil.createTreeCache( cache, FtpFileCacheTestUtil.getCacheConfigFile() );
		cache.start();
	}
	
	private static void stopCache()
	{
		cache.stop();
		cache.destroy();
	}
	
	@AfterClass
	public static void classTearDown() throws Exception
	{
            stopCache();

	    FtpFileCacheTestUtil.stopDB();
	}
	
	public static junit.framework.Test suite() 
	{
		return new JUnit4TestAdapter( DeleteOnEvictTreeCacheListenerIntegrationTest.class );
	}
	
}
