/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.listeners.jca;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

import junit.framework.JUnit4TestAdapter;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * JCA EndpointProxy unit tests.
 * 
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class EndpointProxyUnitTest
{
    private Method onMessage ;
    
    @Before
    public void setUp()
        throws Exception
    {
        onMessage = MessageListener.class.getMethod("onMessage", Message.class) ;
    }
    
    @Test
    public void testToString()
        throws Exception
    {
        final TestMessageEndpoint endpoint = getMessageEndpoint() ;
        endpoint.beforeDelivery(onMessage) ;
        endpoint.onMessage(null) ;
        endpoint.toString() ;
        endpoint.afterDelivery() ;
    }
    
    @Test
    public void testEquals()
        throws Exception
    {
        final TestMessageEndpoint endpoint = getMessageEndpoint() ;
        endpoint.beforeDelivery(onMessage) ;
        endpoint.onMessage(null) ;
        endpoint.equals(null) ;
        endpoint.afterDelivery() ;
    }
    
    @Test
    public void testHashCode()
        throws Exception
    {
        final TestMessageEndpoint endpoint = getMessageEndpoint() ;
        endpoint.beforeDelivery(onMessage) ;
        endpoint.onMessage(null) ;
        endpoint.hashCode() ;
        endpoint.afterDelivery() ;
    }
    
    private TestMessageEndpoint getMessageEndpoint()
        throws Exception
    {
        final EndpointProxy proxy = new EndpointProxy() ;
        proxy.setMessageEndpointFactory(new TestMessageEndpointFactory()) ;
        proxy.setContainer(new TestEndpointContainer()) ;
        
        final ClassLoader loader = Thread.currentThread().getContextClassLoader() ;
        
        proxy.setLoader(loader) ;
        Class<?>[] interfaces = {TestMessageEndpoint.class};
        Class<TestMessageEndpoint> proxyClass = (Class<TestMessageEndpoint>) Proxy.getProxyClass(loader, interfaces);
        final Class<?>[] constructorParams = {InvocationHandler.class};
        
        final Object[] args = {proxy} ;
        final Constructor<TestMessageEndpoint> proxyConstructor;
        try
        {
           proxyConstructor = proxyClass.getConstructor(constructorParams);
        }
        catch (NoSuchMethodException e)
        {
           throw new RuntimeException(e);
        }
        return proxyConstructor.newInstance(args) ;
    }
    
    private interface TestMessageEndpoint extends MessageEndpoint, MessageListener
    {
    }
    
    private static final class TestMessageEndpointFactory implements MessageEndpointFactory
    {

        @Override
        public MessageEndpoint createEndpoint(final XAResource resource)
                throws UnavailableException
        {
            return null ;
        }

        @Override
        public boolean isDeliveryTransacted(final Method method)
                throws NoSuchMethodException
        {
            return false ;
        }
    }
    
    private static final class TestEndpointContainer implements EndpointContainer
    {
        @Override
        public String getDescription()
        {
            return "TestEndpointContainer" ;
        }

        @Override
        public Object invoke(final Method method, final Object[] args) throws Throwable
        {
            return null ;
        }

        @Override
        public boolean isDeliveryTransacted(final Method method)
                throws NoSuchMethodException
        {
            return false ;
        }
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(EndpointProxyUnitTest.class);
    }
}
