/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.smooks.resource;

import java.io.IOException;
import java.io.InputStream;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.junit.Assert;
import org.junit.Test;
import org.milyn.Smooks;
import org.xml.sax.SAXException;

/**
 * Tests for SmooksResource
 */
public class SmooksResourceUnitTest
{
    @Test
    public void smooksInputStream()
        throws LifecycleResourceException, SAXException, IOException
    {
        final InputStream is = getClass().getResourceAsStream("smooks-resource-test.xml") ;
        
        final Thread currentThread = Thread.currentThread() ;
        final ClassLoader current = currentThread.getContextClassLoader() ;
        final TestClassLoader testClassLoader = new TestClassLoader(current) ;
        currentThread.setContextClassLoader(testClassLoader) ;
        try
        {
            final Smooks smooks = SmooksResource.createSmooksResource(is) ;
            try
            {
                Assert.assertTrue("Context ClassLoader was not used", testClassLoader.isInvoked()) ;
            }
            finally
            {
                SmooksResource.closeSmooksResource(smooks) ;
            }
        }
        finally
        {
            currentThread.setContextClassLoader(current) ;
        }
    }
    
    @Test
    public void smooksStringConfig()
        throws LifecycleResourceException, SAXException, IOException
    {
        final String config = getClass().getPackage().getName().replace('.', '/') + "/smooks-resource-test.xml" ;
        
        final Thread currentThread = Thread.currentThread() ;
        final ClassLoader current = currentThread.getContextClassLoader() ;
        final TestClassLoader testClassLoader = new TestClassLoader(current) ;
        currentThread.setContextClassLoader(testClassLoader) ;
        try
        {
            final Smooks smooks = SmooksResource.createSmooksResource(config) ;
            try
            {
                Assert.assertTrue("Context ClassLoader was not used", testClassLoader.isInvoked()) ;
            }
            finally
            {
                SmooksResource.closeSmooksResource(smooks) ;
            }
        }
        finally
        {
            currentThread.setContextClassLoader(current) ;
        }
    }

    private static class TestClassLoader extends ClassLoader
    {
        private boolean invoked ;
        
        TestClassLoader(final ClassLoader parent)
        {
            super(parent) ;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve)
            throws ClassNotFoundException
        {
            if (TestObject.class.getCanonicalName().equals(name))
            {
                invoked = true ;
            }
            return super.loadClass(name, resolve) ;
        }
        
        boolean isInvoked()
        {
            return invoked ;
        }
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter( SmooksResourceUnitTest.class );
    }
}
