/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.visitors;

import static org.jboss.soa.esb.visitors.ServiceDelegator.SERVICE_CATEGORY_NAME_ATTR;
import static org.jboss.soa.esb.visitors.ServiceDelegator.SERVICE_NAME_ATTR;
import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.junit.Before;
import org.junit.Test;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;

/**
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>				
 *
 */
public class DOMServiceDelegateVisitorUnitTest
{
	private DOMServiceDelegateVisitor visitor;
    private SmooksResourceConfiguration resourceConfig;
    
    private String serviceCategoryName = "testCategoryName";
    private String serviceName = "testServiceName";
    
	@Test ( expected = SmooksConfigurationException.class )
	public void setConfigurationNegative()
	{
		resourceConfig.setParameter( SERVICE_CATEGORY_NAME_ATTR, serviceCategoryName );
		resourceConfig.setParameter( SERVICE_NAME_ATTR, serviceName );
		visitor.setConfiguration( resourceConfig );
	}
	
	@Test 
	public void setConfiguration()
	{
		resourceConfig.setParameter( SERVICE_CATEGORY_NAME_ATTR, serviceCategoryName );
		resourceConfig.setParameter( SERVICE_NAME_ATTR, serviceName );
		resourceConfig.setParameter( DOMServiceDelegateVisitor.SEND_IN_VISIT_AFTER, "true" );
		visitor.setConfiguration( resourceConfig );
	}
	
	@Before
	public void createServiceDelegatVistorInstance() throws MessageDeliverException
	{
		visitor = new DOMServiceDelegateVisitor(); 
		ServiceDelegator invoker = new ServiceDelegator() {
			protected ServiceInvoker createServiceInvoker( String serviceCategoryName, String serviceName ) throws MessageDeliverException
			{
				return null;
			}
		};
		visitor.setServiceDelegator( invoker );
	}
	
	@Before
	public void createSmooksResourceConfiguration()
	{
		final String resource = ServiceDelegator.class.getName();
		resourceConfig = new SmooksResourceConfiguration( "Order", resource );
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( DOMServiceDelegateVisitorUnitTest.class );
	}
}
