/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.services.soapui;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.xml.sax.SAXException;

/**
 *
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class JBESB_3719_SoapUIClientServiceMBeanUnitTest extends TestCase {

    private static final String WSDL_LOCATAION = "src/test/java/org/jboss/soa/esb/services/soapui";
    private Properties properties;

    protected void setUp() throws Exception {
        properties = new Properties();
    }

    public void test_ignore_http_bindings() throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        File wsdlFile = new File(WSDL_LOCATAION + "/helloworld_http_bindings.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();
 
        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());
        Map<Object, Object> paras = new HashMap<Object, Object>();
        paras.put("sayHiReponse.arg0", "response");
        String str = mbean.buildResponse(wsdlFile.toURL().toString(), "HelloWorldPubServiceOp", null, paras, properties, null, null);
    }
    
    public void test_ignore_http_bindings1() throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        File wsdlFile = new File(WSDL_LOCATAION + "/helloworld_http_bindings1.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();
 
        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());
        Map<Object, Object> paras = new HashMap<Object, Object>();
        paras.put("sayHiReponse.arg0", "response");
        String str = mbean.buildResponse(wsdlFile.toURL().toString(), "HelloWorldPubServiceOp", null, paras, properties, null, null);
    }
}
