/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.webservice_consumer1.test.SendEsbMessage;

import org.jboss.soa.esb.samples.quickstart.webservice_consumer1.test.SendJMSMessage;

/**
 * CI test for the webservice_consumer1 quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class WebServiceConsumer1Test extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "Jimbo";

    private static final String HELLO_SOAP_PRE =
        "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:hello=\"http://webservice_proxy_routed/hello\">" +
                "<soapenv:Header/>" +
                "<soapenv:Body>" +
                        "<hello:sayHello>" +
                                "<toWhom>";

    private static final String HELLO_SOAP_POST =
                                "</toWhom>" +
                        "</hello:sayHello>" +
                "</soapenv:Body>" +
        "</soapenv:Envelope>";

    private static final String GOODBYE_SOAP_PRE =
        "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:goodbye=\"http://webservice_proxy_routed/goodbye\">" +
                "<soapenv:Header/>" +
                "<soapenv:Body>" +
                        "<goodbye:sayGoodbye>" +
                                "<toWhom>";

    private static final String GOODBYE_SOAP_POST =
                                "</toWhom>" +
                        "</goodbye:sayGoodbye>" +
                "</soapenv:Body>" +
        "</soapenv:Envelope>";

    
	
	public WebServiceConsumer1Test(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendMessage();
	    String[] sinkMessages = waitForMessages(1, 30000);
	    assertTrue("Expected to find string " + JMS_MESSAGE + " found " + sinkMessages[0],
	    		sinkMessages[0].contains(JMS_MESSAGE));
	}

	public void sendMessage() throws Exception {
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(JMS_MESSAGE);
		sm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(WebServiceConsumer1Test.class, "QuickstartMessageStoreServer.sar, Quickstart_webservice_consumer1.esb");
	}
}
