/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.jboss.soa.bpel.samples.quickstart.ordering.ws;

import javax.ejb.EJB;
import javax.ejb.Stateless;

//import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.jboss.soa.bpel.sample.quickstart.ordering.ejb.OrderingBeanLocal;

/**
 *
 * @author mbaluch
 */
@Stateless
@WebService(name="OrderingWS", targetNamespace="http://jboss.org/bpel/ordering")
public class OrderingService {

    @EJB(beanName="OrderingEJB")
    private OrderingBeanLocal ejbRef;

    /**
     * Web service operation
     */
    @WebMethod(operationName = "createOrder")
    public Long createOrder(@WebParam(name = "itemId") Long itemId, @WebParam(name = "quantity") int quantity) {
	long l = ejbRef.createOrder(itemId, quantity);
        return l;
    }

    /**
     * Web service operation
     */
    @WebMethod(operationName = "setState")
//    @Oneway
    public String setState(@WebParam(name = "orderId") Long orderId, @WebParam(name = "state") String state) {
        ejbRef.setState(orderId, state);
        return getState(orderId);
    }

    /**
     * Web service operation
     */
    @WebMethod(operationName = "getState")
    public String getState(@WebParam(name = "orderId") Long orderId) {
        return ejbRef.getState(orderId);
    }

    /**
     * Web service operation
     */
    @WebMethod(operationName = "getItemInfo")
    public int getItemInfo(@WebParam(name = "id") Long id) {
        return ejbRef.getItemInfo(id);
    }

}
