/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.EnvelopeBuilderDOM;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.spi.util.ServiceLoader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogicalMessageImpl
implements LogicalMessage {
    private static final Logger log = Logger.getLogger(LogicalMessageImpl.class);
    private Style style;
    private MessageAbstraction message;

    public LogicalMessageImpl(MessageAbstraction message, Style style) {
        this.style = style;
        this.message = message;
    }

    public Source getPayload() {
        Source source = null;
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPElement bodyElement = (SOAPElement)soapBody.getFirstChild();
            if (this.style == Style.RPC) {
                source = new DOMSource((Node)bodyElement);
            } else {
                SOAPContentElement contentElement = (SOAPContentElement)bodyElement;
                source = contentElement.getXMLFragment().getSource();
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            HTTPMessageImpl httpMessage = (HTTPMessageImpl)this.message;
            source = httpMessage.getXmlFragment().getSource();
        }
        return source;
    }

    public void setPayload(Source source) {
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPElement bodyElement = (SOAPElement)soapBody.getFirstChild();
            try {
                if (this.style == Style.RPC) {
                    try {
                        soapBody.removeContents();
                        EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName());
                        envBuilder.setStyle(this.style);
                        Element domBodyElement = DOMUtils.sourceToElement(source);
                        envBuilder.buildBodyElementRpc(soapBody, domBodyElement);
                    }
                    catch (IOException ex) {
                        WSException.rethrow(ex);
                    }
                }
                SOAPContentElement contentElement = (SOAPContentElement)bodyElement;
                contentElement.setXMLFragment(new XMLFragment(source));
            }
            catch (SOAPException ex) {
                throw new WebServiceException("Cannot set xml payload", (Throwable)ex);
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            HTTPMessageImpl httpMessage = (HTTPMessageImpl)this.message;
            httpMessage.setXmlFragment(new XMLFragment(source));
        }
        MessageContextAssociation.peekMessageContext().setModified(true);
    }

    public Object getPayload(JAXBContext jaxbContext) {
        Object payload = null;
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPContentElement bodyElement = (SOAPContentElement)((Object)soapBody.getFirstChild());
            if (bodyElement != null) {
                payload = bodyElement.getObjectValue();
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            throw new NotImplementedException();
        }
        return payload;
    }

    public void setPayload(Object payload, JAXBContext jaxbContext) {
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPContentElement bodyElement = (SOAPContentElement)((Object)soapBody.getFirstChild());
            if (bodyElement != null) {
                bodyElement.setObjectValue(payload);
                MessageContextAssociation.peekMessageContext().setModified(true);
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            throw new NotImplementedException();
        }
    }

    private SOAPBodyImpl getSOAPBody(SOAPMessage soapMessage) {
        SOAPBodyImpl soapBody = null;
        try {
            soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
        }
        catch (SOAPException ex) {
            WSException.rethrow(ex);
        }
        return soapBody;
    }
}

