/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.cext.Cleaner;
import org.jruby.cext.GC;
import org.jruby.cext.Native;
import org.jruby.runtime.builtin.IRubyObject;

public final class Handle
extends Cleaner {
    private static final long FIXNUM_MAX = Integer.getInteger("sun.arch.data.model") == 64 ? 0x3FFFFFFFFFFFFFFFL : 0x3FFFFFFFL;
    private static final long FIXNUM_MIN = Integer.getInteger("sun.arch.data.model") == 64 ? -4611686018427387904L : -1073741824L;
    private static final long FIXNUM_FLAG = 1L;
    private static final int FIXNUM_SHIFT = 1;
    private static final int SYMBOL_SHIFT = 8;
    private static final long SYMBOL_FLAG = 14L;
    private static final long Qfalse = 0L;
    private static final long Qtrue = 2L;
    private static final long Qnil = 4L;
    private final Ruby runtime;
    private final long address;

    static Handle newHandle(Ruby runtime, Object rubyObject, long nativeHandle) {
        return new Handle(runtime, rubyObject, nativeHandle);
    }

    private Handle(Ruby runtime, Object obj, long address2) {
        super(obj);
        this.runtime = runtime;
        this.address = address2;
    }

    public final long getAddress() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Handle other = (Handle)obj;
        return this.address == other.address;
    }

    public int hashCode() {
        int hash2 = 3;
        hash2 = 37 * hash2 + (int)(this.address ^ this.address >>> 32);
        return hash2;
    }

    public String toString() {
        return "Native ruby object " + Long.toString(this.address);
    }

    void dispose() {
        Native.freeHandle(this.address);
    }

    static Handle valueOf(IRubyObject obj) {
        long nativeHandle;
        Handle h = GC.lookup(obj);
        if (h != null) {
            return h;
        }
        Ruby runtime = obj.getRuntime();
        if (obj instanceof RubyObject) {
            int type2 = ((RubyObject)obj).getNativeTypeIndex();
            switch (type2) {
                case 1: {
                    long val = ((RubyFixnum)obj).getLongValue();
                    nativeHandle = val <= FIXNUM_MAX && val >= FIXNUM_MIN ? val << 1 | 1L : Native.getInstance(runtime).newFixnumHandle(obj, val);
                    break;
                }
                case 11: {
                    nativeHandle = Native.getInstance(runtime).newFloatHandle(obj, ((RubyNumeric)obj).getDoubleValue());
                    break;
                }
                case 8: {
                    nativeHandle = (long)((RubySymbol)obj).getId() << 8 | 0xEL;
                    break;
                }
                case 26: {
                    nativeHandle = Native.getInstance(runtime).newIOHandle(obj, (int)((RubyIO)obj).fileno(runtime.getCurrentContext()).getLongValue(), ((RubyIO)obj).getOpenFile().getMode());
                    break;
                }
                default: {
                    nativeHandle = Native.getInstance(runtime).newHandle(obj, type2);
                    break;
                }
            }
        } else {
            nativeHandle = Native.getInstance(runtime).newHandle(obj, 14);
        }
        Handle handle = Handle.newHandle(runtime, obj, nativeHandle);
        GC.register(obj, handle);
        return handle;
    }

    static long nativeHandle(IRubyObject obj) {
        if (obj.getClass() == RubyFixnum.class) {
            long val = ((RubyFixnum)obj).getLongValue();
            if (val <= FIXNUM_MAX && val >= FIXNUM_MIN) {
                return val << 1 | 1L;
            }
        } else {
            if (obj.getClass() == RubySymbol.class) {
                return (long)((RubySymbol)obj).getId() << 8 | 0xEL;
            }
            if (obj.getClass() == RubyBoolean.class) {
                return obj.isTrue() ? 2L : 0L;
            }
            if (obj.getClass() == RubyNil.class) {
                return 4L;
            }
        }
        return Handle.valueOf(obj).getAddress();
    }
}

