/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.MessageDigest;
import javax.security.auth.x500.X500Principal;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.x509.X509Name;

public class Name {
    public X509Name name;

    public Name(X500Principal nm) {
        try {
            this.name = new X509Name((ASN1Sequence)new ASN1InputStream(nm.getEncoded()).readObject());
        }
        catch (Exception e) {
            this.name = null;
        }
    }

    public Name(X509Name nm) {
        this.name = nm;
    }

    public long hash() {
        try {
            byte[] bytes2 = this.name.getEncoded();
            byte[] md = null;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md = md5.digest(bytes2);
            long result2 = 0L;
            result2 |= (long)(md[3] & 0xFF);
            result2 <<= 8;
            result2 |= (long)(md[2] & 0xFF);
            result2 <<= 8;
            result2 |= (long)(md[1] & 0xFF);
            result2 <<= 8;
            return (result2 |= (long)(md[0] & 0xFF)) & 0xFFFFFFFFFFFFFFFFL;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean isEqual(X500Principal oname) {
        try {
            return new X500Principal(this.name.getEncoded()).equals(oname);
        }
        catch (Exception e) {
            return false;
        }
    }
}

