/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetConnectedException;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UDPSocket"}, parent="IPSocket")
public class RubyUDPSocket
extends RubyIPSocket {
    private static ObjectAllocator UDPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUDPSocket(runtime, klass);
        }
    };

    static void createUDPSocket(Ruby runtime) {
        RubyClass rb_cUDPSocket = runtime.defineClass("UDPSocket", runtime.getClass("IPSocket"), UDPSOCKET_ALLOCATOR);
        rb_cUDPSocket.includeModule(runtime.getClass("Socket").getConstant("Constants"));
        rb_cUDPSocket.defineAnnotatedMethods(RubyUDPSocket.class);
        runtime.getObject().setConstant("UDPsocket", rb_cUDPSocket);
    }

    public RubyUDPSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            DatagramChannel channel = DatagramChannel.open();
            this.initSocket(runtime, new ChannelDescriptor((Channel)channel, RubyUDPSocket.newModeFlags(runtime, ModeFlags.RDWR)));
        }
        catch (ConnectException e) {
            throw runtime.newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject protocol2) {
        return this.initialize(context);
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject host, IRubyObject _port) {
        Ruby runtime = context.runtime;
        InetSocketAddress addr2 = null;
        try {
            Channel channel = this.getChannel();
            int port = SocketUtils.portToInt(_port);
            if (host.isNil() || host instanceof RubyString && ((RubyString)host).isEmpty()) {
                addr2 = new InetSocketAddress(port);
            } else if (host instanceof RubyFixnum) {
                RubyModule socketMod;
                int intAddr = RubyNumeric.fix2int(host);
                if (intAddr == RubyNumeric.fix2int((socketMod = runtime.getModule("Socket")).getConstant("INADDR_ANY"))) {
                    addr2 = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port);
                }
            } else {
                addr2 = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), port);
            }
            if (this.multicastStateManager == null) {
                ((DatagramChannel)channel).socket().bind(addr2);
            } else {
                this.multicastStateManager.rebindToPort(port);
            }
            return RubyFixnum.zero(runtime);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "bind: name or service not known");
        }
        catch (SocketException e) {
            throw SocketUtils.sockerr(runtime, "bind: name or service not known");
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "bind: name or service not known");
        }
        catch (Error e) {
            if (e.getCause() instanceof SocketException) {
                throw SocketUtils.sockerr(runtime, "bind: name or service not known");
            }
            throw e;
        }
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject host, IRubyObject port) {
        Ruby runtime = context.runtime;
        try {
            InetSocketAddress addr2 = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), SocketUtils.portToInt(port));
            ((DatagramChannel)this.getChannel()).connect(addr2);
            return RubyFixnum.zero(runtime);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "connect: name or service not known");
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "connect: name or service not known");
        }
    }

    @JRubyMethod
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject _length) {
        Ruby runtime = context.runtime;
        try {
            int length2 = RubyNumeric.fix2int(_length);
            ReceiveTuple tuple = this.doReceiveNonblockTuple(runtime, length2);
            IRubyObject addressArray = this.addrFor(context, tuple.sender, false);
            return runtime.newArray((IRubyObject)tuple.result, addressArray);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "recvfrom: name or service not known");
        }
        catch (PortUnreachableException e) {
            throw runtime.newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "recvfrom: name or service not known");
        }
    }

    @JRubyMethod
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom_nonblock(context, _length);
    }

    @JRubyMethod
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags) {
        Ruby runtime = context.runtime;
        try {
            RubyString data2 = _mesg.convertToString();
            ByteBuffer buf = ByteBuffer.wrap(data2.getBytes());
            int written = ((DatagramChannel)this.getChannel()).write(buf);
            return runtime.newFixnum(written);
        }
        catch (NotYetConnectedException nyce) {
            throw runtime.newErrnoEDESTADDRREQError("send(2)");
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "send: name or service not known");
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "send: name or service not known");
        }
    }

    @JRubyMethod
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags, IRubyObject _to) {
        return this.send(context, _mesg, _flags);
    }

    @JRubyMethod(required=2, optional=2)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject _mesg = args2[0];
        IRubyObject _flags = args2[1];
        try {
            int written;
            Service service;
            if (args2.length == 2 || args2.length == 3) {
                return this.send(context, _mesg, _flags);
            }
            IRubyObject _host = args2[2];
            IRubyObject _port = args2[3];
            RubyString nameStr = _host.convertToString();
            RubyString data2 = _mesg.convertToString();
            ByteBuffer buf = ByteBuffer.wrap(data2.getBytes());
            byte[] buf2 = data2.getBytes();
            DatagramPacket sendDP = null;
            int port = _port instanceof RubyString ? ((service = Service.getServiceByName(_port.asJavaString(), "udp")) != null ? service.getPort() : (int)_port.convertToInteger("to_i").getLongValue()) : (int)_port.convertToInteger().getLongValue();
            InetAddress address2 = SocketUtils.getRubyInetAddress(nameStr.getByteList());
            InetSocketAddress addr2 = new InetSocketAddress(address2, port);
            if (this.multicastStateManager == null) {
                written = ((DatagramChannel)this.getChannel()).send(buf, addr2);
            } else {
                sendDP = new DatagramPacket(buf2, buf2.length, address2, port);
                this.multicastStateManager.rebindToPort(port);
                MulticastSocket ms = this.multicastStateManager.getMulticastSocket();
                ms.send(sendDP);
                written = sendDP.getLength();
            }
            return runtime.newFixnum(written);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "send: name or service not known");
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "send: name or service not known");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        block3: {
            RubyUDPSocket sock = (RubyUDPSocket)recv2.callMethod(context, "new", args2);
            if (!block.isGiven()) {
                return sock;
            }
            try {
                iRubyObject = block.yield(context, sock);
                Object var7_6 = null;
                if (!sock.openFile.isOpen()) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (!sock.openFile.isOpen()) break block4;
                    sock.close();
                }
                throw throwable;
            }
            sock.close();
        }
        return iRubyObject;
    }

    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        Ruby runtime = context.runtime;
        try {
            int length2 = RubyNumeric.fix2int(_length);
            ReceiveTuple tuple = this.doReceiveTuple(runtime, length2);
            IRubyObject addressArray = this.addrFor(context, tuple.sender, false);
            return runtime.newArray((IRubyObject)tuple.result, addressArray);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "recvfrom: name or service not known");
        }
        catch (PortUnreachableException e) {
            throw runtime.newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "recvfrom: name or service not known");
        }
    }

    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    public IRubyObject recv(ThreadContext context, IRubyObject _length) {
        Ruby runtime = context.runtime;
        try {
            return this.doReceive(runtime, RubyNumeric.fix2int(_length));
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "recv: name or service not known");
        }
    }

    public IRubyObject recv(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recv(context, _length);
    }

    private ReceiveTuple doReceiveTuple(Ruby runtime, int length2) throws IOException {
        ReceiveTuple tuple = new ReceiveTuple();
        if (this.multicastStateManager == null) {
            this.doReceive(runtime, length2, tuple);
        } else {
            this.doReceiveMulticast(runtime, length2, tuple);
        }
        return tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiveTuple doReceiveNonblockTuple(Ruby runtime, int length2) throws IOException {
        DatagramChannel channel = (DatagramChannel)this.getChannel();
        Object object = channel.blockingLock();
        synchronized (object) {
            ReceiveTuple receiveTuple;
            boolean oldBlocking = channel.isBlocking();
            channel.configureBlocking(false);
            try {
                receiveTuple = this.doReceiveTuple(runtime, length2);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                channel.configureBlocking(oldBlocking);
                throw throwable;
            }
            channel.configureBlocking(oldBlocking);
            return receiveTuple;
        }
    }

    private IRubyObject doReceive(Ruby runtime, int length2) throws IOException {
        return this.doReceive(runtime, length2, null);
    }

    private IRubyObject doReceive(Ruby runtime, int length2, ReceiveTuple tuple) throws IOException {
        ByteBuffer buf;
        DatagramChannel channel = (DatagramChannel)this.getChannel();
        InetSocketAddress sender = (InetSocketAddress)channel.receive(buf = ByteBuffer.allocate(length2));
        if (sender == null) {
            if (runtime.is1_9()) {
                throw runtime.newErrnoEAGAINReadableError("recvfrom(2) would block");
            }
            throw runtime.newErrnoEAGAINError("recvfrom(2) would block");
        }
        if (sender == null) {
            throw runtime.newErrnoECONNRESETError();
        }
        RubyString result2 = runtime.newString(new ByteList(buf.array(), 0, buf.position()));
        if (tuple != null) {
            tuple.result = result2;
            tuple.sender = sender;
        }
        return result2;
    }

    private IRubyObject doReceiveMulticast(Ruby runtime, int length2, ReceiveTuple tuple) throws IOException {
        byte[] buf2 = new byte[length2];
        DatagramPacket recv2 = new DatagramPacket(buf2, buf2.length);
        MulticastSocket ms = this.multicastStateManager.getMulticastSocket();
        try {
            ms.receive(recv2);
        }
        catch (IllegalBlockingModeException ibme) {
            if (runtime.is1_9()) {
                throw runtime.newErrnoEAGAINReadableError("multicast UDP does not support nonblocking");
            }
            throw runtime.newErrnoEAGAINError("multicast UDP does not support nonblocking");
        }
        InetSocketAddress sender = (InetSocketAddress)recv2.getSocketAddress();
        if (sender == null) {
            throw runtime.newErrnoECONNRESETError();
        }
        RubyString result2 = runtime.newString(new ByteList(recv2.getData(), 0, recv2.getLength()));
        if (tuple != null) {
            tuple.result = result2;
            tuple.sender = sender;
        }
        return result2;
    }

    @Deprecated
    public IRubyObject bind(IRubyObject host, IRubyObject port) {
        return this.bind(this.getRuntime().getCurrentContext(), host, port);
    }

    @Deprecated
    public IRubyObject connect(IRubyObject host, IRubyObject port) {
        return this.connect(this.getRuntime().getCurrentContext(), host, port);
    }

    @Deprecated
    public IRubyObject recvfrom(IRubyObject[] args2) {
        return this.recvfrom(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public IRubyObject send(IRubyObject[] args2) {
        return this.send(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyUDPSocket.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    private static class ReceiveTuple {
        RubyString result;
        InetSocketAddress sender;

        ReceiveTuple() {
        }

        ReceiveTuple(RubyString result2, InetSocketAddress sender) {
            this.result = result2;
            this.sender = sender;
        }
    }
}

