/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstMissingInstr
extends CallInstr
implements ResultInstr {
    private String missingConst;

    public ConstMissingInstr(Variable result2, Operand currentModule, String missingConst) {
        super(Operation.CONST_MISSING, CallType.FUNCTIONAL, result2, new MethAddr("const_missing"), currentModule, new Operand[]{new Symbol(missingConst)}, null);
        this.missingConst = missingConst;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.receiver};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.receiver = this.receiver.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new ConstMissingInstr(ii.getRenamedVariable(this.result), this.receiver.cloneForInlining(ii), this.missingConst);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.receiver + "," + this.missingConst + ")";
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        RubyModule module = (RubyModule)this.receiver.retrieve(context, self, currDynScope, temp);
        return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(this.missingConst));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ConstMissingInstr(this);
    }
}

