/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby19;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReceiveOptArgBase;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveOptArgInstr19
extends ReceiveOptArgBase {
    public final int minArgsLength;

    public ReceiveOptArgInstr19(Variable result2, int index2, int minArgsLength) {
        super(result2, index2);
        this.minArgsLength = minArgsLength;
    }

    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.argIndex + ", " + this.minArgsLength + ")";
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        if (ii.canMapArgsStatically()) {
            int n = ii.getArgsCount();
            return new CopyInstr(ii.getRenamedVariable(this.result), this.minArgsLength <= n ? ii.getArg(this.argIndex) : UndefinedValue.UNDEFINED);
        }
        return new OptArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, this.minArgsLength);
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ReceiveOptArgInstr19(ii.getRenamedVariable(this.result), this.argIndex, this.minArgsLength);
    }

    public Object receiveOptArg(IRubyObject[] args2) {
        return this.minArgsLength <= args2.length ? args2[this.argIndex] : UndefinedValue.UNDEFINED;
    }

    public void visit(IRVisitor visitor) {
        visitor.ReceiveOptArgInstr19(this);
    }
}

