/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.LoadLocalVarPlacementProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddLocalVarLoadStoreInstructions
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = new ArrayList<Class<? extends CompilerPass>>(){
        {
            this.add(LiveVariableAnalysis.class);
        }
    };

    @Override
    public String getLabel() {
        return "Add Local Variable Load/Store Instructions";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope s2, Object ... data2) {
        StoreLocalVarPlacementProblem slvp = new StoreLocalVarPlacementProblem();
        slvp.setup(s2);
        slvp.compute_MOP_Solution();
        HashMap<Operand, Operand> varRenameMap = new HashMap<Operand, Operand>();
        slvp.addStores(varRenameMap);
        LoadLocalVarPlacementProblem llvp = new LoadLocalVarPlacementProblem();
        llvp.setup(s2);
        llvp.compute_MOP_Solution();
        llvp.addLoads(varRenameMap);
        for (BasicBlock b : s2.getCFG().getBasicBlocks()) {
            for (Instr i2 : b.getInstrs()) {
                i2.renameVars(varRenameMap);
            }
        }
        for (IRClosure c : s2.getClosures()) {
            this.execute(c, new Object[0]);
        }
        s2.setDataFlowSolution("Placement of local-var stores", slvp);
        return slvp;
    }

    @Override
    public Object previouslyRun(IRScope scope) {
        return scope.getDataFlowSolution("Placement of local-var stores");
    }

    @Override
    public void invalidate(IRScope scope) {
        scope.setDataFlowSolution("Placement of local-var stores", null);
    }
}

