/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.transformations.inlining;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.runtime.Arity;

public class InlinerInfo {
    private static Integer globalInlineCount = 0;
    private CFG callerCFG;
    private CallBase call;
    private Operand[] callArgs;
    private boolean canMapArgsStatically;
    private Variable argsArray;
    private Map<Label, Label> lblRenameMap;
    private Map<Variable, Variable> varRenameMap;
    private Map<BasicBlock, BasicBlock> bbRenameMap;
    private List yieldSites;
    private Operand callReceiver;
    private String inlineVarPrefix;
    private Operand yieldArg;
    private Variable yieldResult;
    private boolean inClosureInlineMode;
    private boolean inClosureCloneMode;
    private IRClosure clonedClosure;

    private static boolean containsSplat(Operand[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!(args2[i2] instanceof Splat)) continue;
            return true;
        }
        return false;
    }

    public InlinerInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InlinerInfo(CallBase call2, CFG c) {
        this.varRenameMap = new HashMap<Variable, Variable>();
        this.lblRenameMap = new HashMap<Label, Label>();
        this.bbRenameMap = new HashMap<BasicBlock, BasicBlock>();
        this.yieldSites = new ArrayList();
        this.call = call2;
        this.callArgs = call2.getCallArgs();
        this.callerCFG = c;
        this.callReceiver = call2.getReceiver();
        this.inClosureCloneMode = false;
        this.inClosureInlineMode = false;
        this.canMapArgsStatically = !InlinerInfo.containsSplat(this.callArgs);
        this.argsArray = this.canMapArgsStatically ? null : this.getInlineHostScope().getNewTemporaryVariable();
        Integer n = globalInlineCount;
        synchronized (n) {
            this.inlineVarPrefix = "%in" + globalInlineCount + "_";
            Integer n2 = globalInlineCount;
            Integer n3 = globalInlineCount = Integer.valueOf(globalInlineCount + 1);
        }
    }

    public InlinerInfo cloneForInliningClosure() {
        InlinerInfo clone = new InlinerInfo();
        clone.varRenameMap = new HashMap<Variable, Variable>();
        clone.lblRenameMap = new HashMap<Label, Label>();
        clone.bbRenameMap = new HashMap<BasicBlock, BasicBlock>();
        clone.call = this.call;
        clone.callArgs = this.callArgs;
        clone.callerCFG = this.callerCFG;
        clone.callReceiver = this.callReceiver;
        clone.inClosureCloneMode = false;
        clone.inClosureInlineMode = true;
        clone.canMapArgsStatically = false;
        return clone;
    }

    public InlinerInfo cloneForCloningClosure(IRClosure clonedClosure) {
        InlinerInfo clone = new InlinerInfo();
        clone.varRenameMap = new HashMap<Variable, Variable>();
        for (Variable v : this.varRenameMap.keySet()) {
            clone.varRenameMap.put(v, this.varRenameMap.get(v));
        }
        clone.lblRenameMap = new HashMap<Label, Label>();
        clone.clonedClosure = clonedClosure;
        clone.inClosureCloneMode = true;
        clone.inClosureInlineMode = false;
        clone.canMapArgsStatically = false;
        return clone;
    }

    public IRScope getInlineHostScope() {
        return this.callerCFG.getScope();
    }

    public IRScope getNewLexicalParentForClosure() {
        return this.inClosureCloneMode ? this.clonedClosure : this.getInlineHostScope();
    }

    public Label getRenamedLabel(Label l) {
        Label newLbl = this.lblRenameMap.get(l);
        if (newLbl == null) {
            newLbl = this.inClosureCloneMode ? l.clone() : this.getInlineHostScope().getNewLabel();
            this.lblRenameMap.put(l, newLbl);
        }
        return newLbl;
    }

    public void setupYieldArgsAndYieldResult(YieldInstr yi, BasicBlock yieldBB, Arity blockArity) {
        int blockArityValue = blockArity.getValue();
        Operand yieldInstrArg = yi.getYieldArg();
        if (yieldInstrArg == UndefinedValue.UNDEFINED || blockArityValue == 0) {
            this.yieldArg = new Array();
        } else if (yieldInstrArg instanceof Array) {
            this.yieldArg = yieldInstrArg;
            if (((Array)yieldInstrArg).size() == blockArityValue) {
                this.canMapArgsStatically = true;
            }
        } else {
            IRScope callerScope = this.getInlineHostScope();
            boolean needSpecialProcessing = blockArityValue != -1 && blockArityValue != 1;
            TemporaryVariable yieldArgArray = callerScope.getNewTemporaryVariable();
            yieldBB.addInstr(new ToAryInstr(yieldArgArray, yieldInstrArg, callerScope.getManager().getTrue()));
            this.yieldArg = yieldArgArray;
        }
        this.yieldResult = yi.getResult();
    }

    public Variable getRenamedVariable(Variable v) {
        Variable newVar = this.varRenameMap.get(v);
        if (newVar == null) {
            if (this.inClosureCloneMode) {
                newVar = v.cloneForCloningClosure(this);
            } else if (this.inClosureInlineMode) {
                if (v instanceof LocalVariable) {
                    LocalVariable lv = (LocalVariable)v;
                    int depth = lv.getScopeDepth();
                    newVar = this.getInlineHostScope().getLocalVariable(lv.getName(), depth > 1 ? depth - 1 : 0);
                } else {
                    newVar = this.getInlineHostScope().getNewTemporaryVariable();
                }
            } else {
                newVar = this.getInlineHostScope().getNewInlineVariable(this.inlineVarPrefix, v);
            }
            this.varRenameMap.put(v, newVar);
        } else if (this.inClosureCloneMode && v instanceof LocalVariable) {
            LocalVariable l_v = (LocalVariable)v;
            LocalVariable l_newVar = (LocalVariable)newVar;
            if (l_v.getScopeDepth() != l_newVar.getScopeDepth()) {
                newVar = l_newVar.cloneForDepth(l_v.getScopeDepth());
            }
        }
        return newVar;
    }

    public BasicBlock getRenamedBB(BasicBlock bb) {
        return this.bbRenameMap.get(bb);
    }

    public BasicBlock getOrCreateRenamedBB(BasicBlock bb) {
        BasicBlock renamedBB = this.getRenamedBB(bb);
        if (renamedBB == null) {
            renamedBB = new BasicBlock(this.callerCFG, this.getRenamedLabel(bb.getLabel()));
            if (bb.isRescueEntry()) {
                renamedBB.markRescueEntryBB();
            }
            this.bbRenameMap.put(bb, renamedBB);
        }
        return renamedBB;
    }

    public boolean canMapArgsStatically() {
        return this.canMapArgsStatically;
    }

    public Operand getArgs() {
        return this.inClosureInlineMode ? this.yieldArg : this.argsArray;
    }

    public int getArgsCount() {
        return this.canMapArgsStatically ? (this.inClosureInlineMode ? ((Array)this.yieldArg).size() : this.callArgs.length) : -1;
    }

    public Operand getArg(int index2) {
        int n = this.getArgsCount();
        return index2 < n ? (this.inClosureInlineMode ? ((Array)this.yieldArg).get(index2) : this.callArgs[index2]) : null;
    }

    public Operand getArg(int argIndex, boolean restOfArgArray) {
        if (!restOfArgArray) {
            return this.getArg(argIndex);
        }
        if (this.inClosureInlineMode) {
            throw new RuntimeException("Cannot get rest yield arg at inline time!");
        }
        if (argIndex >= this.callArgs.length) {
            return new Array();
        }
        Operand[] tmp = new Operand[this.callArgs.length - argIndex];
        for (int j = argIndex; j < this.callArgs.length; ++j) {
            tmp[j - argIndex] = this.callArgs[j];
        }
        return new Array(tmp);
    }

    public Operand getSelfValue(Self self) {
        return this.inClosureCloneMode ? self : this.callReceiver;
    }

    public Operand getCallClosure() {
        return this.call.getClosureArg(this.callerCFG.getScope().getManager().getNil());
    }

    public IRClosure getClonedClosure() {
        return this.clonedClosure;
    }

    public Variable getCallResultVariable() {
        return this.call instanceof ResultInstr ? ((ResultInstr)((Object)this.call)).getResult() : null;
    }

    public void recordYieldSite(BasicBlock bb, YieldInstr i2) {
        this.yieldSites.add(new Tuple<BasicBlock, YieldInstr>(bb, i2));
    }

    public List getYieldSites() {
        return this.yieldSites;
    }

    public Variable getYieldResult() {
        return this.yieldResult;
    }
}

