/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1;

import java.io.IOException;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DEROutputStream;
import org.jruby.org.bouncycastle.asn1.DERString;

public class DERPrintableString
extends ASN1Object
implements DERString {
    String string;

    public static DERPrintableString getInstance(Object object) {
        if (object == null || object instanceof DERPrintableString) {
            return (DERPrintableString)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERPrintableString) {
            return DERPrintableString.getInstance(dERObject);
        }
        return new DERPrintableString(ASN1OctetString.getInstance(dERObject).getOctets());
    }

    public DERPrintableString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int j = 0; j != cArray.length; ++j) {
            cArray[j] = (char)(byArray[j] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERPrintableString(String string2) {
        this(string2, false);
    }

    public DERPrintableString(String string2, boolean bl) {
        if (bl && !DERPrintableString.isPrintableString(string2)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int j = 0; j != cArray.length; ++j) {
            byArray[j] = (byte)cArray[j];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(19, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString dERPrintableString = (DERPrintableString)dERObject;
        return this.getString().equals(dERPrintableString.getString());
    }

    public String toString() {
        return this.string;
    }

    public static boolean isPrintableString(String string2) {
        block3: for (int j = string2.length() - 1; j >= 0; --j) {
            char c = string2.charAt(j);
            if (c > '\u007f') {
                return false;
            }
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            switch (c) {
                case ' ': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

