/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.ocsp;

import java.util.Date;
import org.jruby.org.bouncycastle.asn1.DERGeneralizedTime;
import org.jruby.org.bouncycastle.asn1.ocsp.RevokedInfo;
import org.jruby.org.bouncycastle.asn1.x509.CRLReason;
import org.jruby.org.bouncycastle.cert.ocsp.CertificateStatus;
import org.jruby.org.bouncycastle.cert.ocsp.OCSPUtils;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo revokedInfo) {
        this.info = revokedInfo;
    }

    public RevokedStatus(Date date, int n) {
        this.info = new RevokedInfo(new DERGeneralizedTime(date), new CRLReason(n));
    }

    public Date getRevocationTime() {
        return OCSPUtils.extractDate(this.info.getRevocationTime());
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

