/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.IOException;
import java.math.BigInteger;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.jruby.org.bouncycastle.asn1.x500.X500Name;
import org.jruby.org.bouncycastle.asn1.x509.X509Extension;
import org.jruby.org.bouncycastle.cert.X509CertificateHolder;
import org.jruby.org.bouncycastle.cms.KeyTransRecipientInformation;
import org.jruby.org.bouncycastle.cms.RecipientId;
import org.jruby.org.bouncycastle.crypto.digests.SHA1Digest;
import org.jruby.org.bouncycastle.util.Arrays;

public class KeyTransRecipientId
extends RecipientId {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public KeyTransRecipientId(byte[] byArray) {
        super(0);
        super.setSubjectKeyIdentifier(new DEROctetString(byArray).getDEREncoded());
        this.subjectKeyId = byArray;
    }

    public KeyTransRecipientId(X500Name x500Name, BigInteger bigInteger) {
        super(0);
        this.issuer = x500Name;
        this.serialNumber = bigInteger;
        try {
            this.setIssuer(x500Name.getDEREncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid issuer: " + iOException.getMessage());
        }
        this.setSerialNumber(bigInteger);
    }

    public int hashCode() {
        int n = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            n ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            n ^= this.issuer.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyTransRecipientId)) {
            return false;
        }
        KeyTransRecipientId keyTransRecipientId = (KeyTransRecipientId)object;
        return Arrays.areEqual(this.subjectKeyId, keyTransRecipientId.subjectKeyId) && this.equalsObj(this.serialNumber, keyTransRecipientId.serialNumber) && this.equalsObj(this.issuer, keyTransRecipientId.issuer);
    }

    private boolean equalsObj(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public boolean match(Object object) {
        if (object instanceof X509CertificateHolder) {
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = x509CertificateHolder.getIssuerAndSerialNumber();
                return issuerAndSerialNumber.getName().equals(this.issuer) && issuerAndSerialNumber.getSerialNumber().getValue().equals(this.getSerialNumber());
            }
            if (this.getSubjectKeyIdentifier() != null) {
                X509Extension x509Extension = x509CertificateHolder.getExtension(X509Extension.subjectKeyIdentifier);
                if (x509Extension == null) {
                    SHA1Digest sHA1Digest = new SHA1Digest();
                    byte[] byArray = new byte[sHA1Digest.getDigestSize()];
                    byte[] byArray2 = x509CertificateHolder.getSubjectPublicKeyInfo().getDEREncoded();
                    sHA1Digest.update(byArray2, 0, byArray2.length);
                    sHA1Digest.doFinal(byArray, 0);
                    return Arrays.areEqual(this.subjectKeyId, byArray);
                }
                byte[] byArray = ASN1OctetString.getInstance(x509Extension.getParsedValue()).getOctets();
                return Arrays.areEqual(this.subjectKeyId, byArray);
            }
        } else {
            if (object instanceof byte[]) {
                return Arrays.areEqual(this.subjectKeyId, (byte[])object);
            }
            if (object instanceof KeyTransRecipientInformation) {
                return ((KeyTransRecipientInformation)object).getRID().equals(this);
            }
        }
        return false;
    }
}

