/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import org.jruby.org.bouncycastle.crypto.BasicAgreement;
import org.jruby.org.bouncycastle.crypto.CipherParameters;
import org.jruby.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.jruby.org.bouncycastle.crypto.params.DHParameters;
import org.jruby.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.jruby.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.jruby.org.bouncycastle.crypto.params.ParametersWithRandom;

public class DHBasicAgreement
implements BasicAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.dhParams = this.key.getParameters();
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)cipherParameters;
        if (!dHPublicKeyParameters.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return dHPublicKeyParameters.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

