/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.security.AccessControlException;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.platform.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;

public class LoadService19
extends LoadService {
    private boolean canGetAbsolutePath = true;

    public LoadService19(Ruby runtime) {
        super(runtime);
    }

    protected String resolveLoadName(LoadServiceResource foundResource, String previousPath) {
        if (this.canGetAbsolutePath) {
            try {
                String path2 = foundResource.getAbsolutePath();
                if (Platform.IS_WINDOWS) {
                    path2 = path2.replace('\\', '/');
                }
                return path2;
            }
            catch (AccessControlException ace) {
                this.runtime.getWarnings().warn("can't canonicalize loaded names due to security restrictions; disabling");
                this.canGetAbsolutePath = false;
            }
        }
        return super.resolveLoadName(foundResource, previousPath);
    }

    protected String getFileName(JRubyFile file2, String nameWithSuffix) {
        return file2.getAbsolutePath();
    }

    protected String getLoadPathEntry(IRubyObject entry) {
        return RubyFile.get_path(entry.getRuntime().getCurrentContext(), entry).asJavaString();
    }
}

