/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DefaultDSLMapping;

public abstract class DSLMappingFile {
    private DSLMapping mapping = new DefaultDSLMapping();
    private List errors = Collections.emptyList();

    public DSLMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(DSLMapping mapping) {
        this.mapping = mapping;
    }

    public List getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected void setErrors(List errors) {
        this.errors = errors;
    }

    public abstract boolean parseAndLoad(Reader var1) throws IOException;

    public void saveMapping(Writer out) throws IOException {
        Iterator<DSLMappingEntry> it = this.mapping.getEntries().iterator();
        while (it.hasNext()) {
            out.write(it.next().toString());
            out.write("\n");
        }
    }

    public static void saveMapping(Writer out, DSLMapping mapping) throws IOException {
        Iterator<DSLMappingEntry> it = mapping.getEntries().iterator();
        while (it.hasNext()) {
            out.write(it.next().toString());
            out.write("\n");
        }
    }

    public String dumpFile() {
        StringBuilder buf = new StringBuilder();
        Iterator<DSLMappingEntry> it = this.mapping.getEntries().iterator();
        while (it.hasNext()) {
            buf.append(it.next());
            buf.append("\n");
        }
        return buf.toString();
    }
}

