/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.util.HashMap;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.command.OPTS_MLST;
import org.apache.ftpserver.command.OPTS_UTF8;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.Command;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPTS
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)OPTS.class);
    private static final HashMap COMMAND_MAP = new HashMap(16);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        String argument = request.getArgument();
        if (argument == null) {
            out.write(FtpReplyUtil.translate(session, 501, "OPTS", null));
            return;
        }
        int spaceIndex = argument.indexOf(32);
        if (spaceIndex != -1) {
            argument = argument.substring(0, spaceIndex);
        }
        argument = argument.toUpperCase();
        String optsRequest = "OPTS_" + argument;
        Command command = (Command)COMMAND_MAP.get(optsRequest);
        try {
            if (command != null) {
                command.execute(connection, request, session, out);
            } else {
                session.resetState();
                out.write(FtpReplyUtil.translate(session, 502, "OPTS.not.implemented", argument));
            }
        }
        catch (Exception ex) {
            this.LOG.warn("OPTS.execute()", (Throwable)ex);
            session.resetState();
            out.write(FtpReplyUtil.translate(session, 500, "OPTS", null));
        }
    }

    static {
        COMMAND_MAP.put("OPTS_MLST", new OPTS_MLST());
        COMMAND_MAP.put("OPTS_UTF8", new OPTS_UTF8());
    }
}

