/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.wsf.stack.cxf.security.authentication.AuthenticationManagerLoader;
import org.picketbox.config.PicketBoxConfiguration;
import org.picketbox.exceptions.ConfigurationStreamNullException;
import org.picketbox.factories.SecurityFactory;

public class SubjectCreatingInterceptor
extends AbstractUsernameTokenAuthenticatingInterceptor {
    private static final Logger log = Logger.getLogger(SubjectCreatingInterceptor.class);
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "JBossWS";
    private AuthenticationManagerLoader aml = null;
    private String securityDomainName = "JBossWS";

    public SubjectCreatingInterceptor() {
        this(Collections.emptyMap());
    }

    public SubjectCreatingInterceptor(Map<String, Object> properties) {
        super(properties);
        try {
            this.aml = (AuthenticationManagerLoader)AuthenticationManagerLoader.class.newInstance();
        }
        catch (Exception ex) {
            String msg = "AuthenticationManager can not be loaded";
            log.error((Object)msg);
            throw new SecurityException(msg);
        }
    }

    public Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) {
        AuthenticationManager am = this.aml.getManager(this.securityDomainName);
        SimplePrincipal principal = new SimplePrincipal(name);
        Subject subject = new Subject();
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)("About to authenticate, using security domain '" + am.getSecurityDomain() + "'"));
        }
        if (!am.isValid((Principal)principal, (Object)password, subject)) {
            String msg = "Authentication failed, principal=" + principal.getName();
            log.error((Object)msg);
            throw new SecurityException(msg);
        }
        if (TRACE) {
            log.trace((Object)("Authenticated, principal=" + name));
        }
        return subject;
    }

    public void setSecurityConfigFile(String configFilePath) {
        SecurityFactory.prepare();
        try {
            PicketBoxConfiguration idtrustConfig = new PicketBoxConfiguration();
            idtrustConfig.load(configFilePath);
        }
        catch (ConfigurationStreamNullException ex) {
            throw new SecurityException("Unable to load the configuration file " + configFilePath);
        }
        catch (Exception ex) {
            throw new SecurityException("Unable to read the configuration file " + configFilePath, ex);
        }
        finally {
            SecurityFactory.release();
        }
    }

    public void setSecurityDomainName(String domainName) {
        this.securityDomainName = domainName;
    }
}

