/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.AssertionsListener;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.support.action.ActionSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AssertionsPanel
extends JPanel {
    private AssertionListModel assertionListModel;
    private JList assertionList;
    private JPopupMenu assertionListPopup;
    private final Assertable assertable;

    public AssertionsPanel(Assertable assertable) {
        super(new BorderLayout());
        this.assertable = assertable;
        this.assertionListModel = new AssertionListModel();
        this.assertionList = new JList(this.assertionListModel);
        this.assertionList.setToolTipText("Assertions for this request");
        this.assertionList.setCellRenderer(new AssertionCellRenderer());
        this.assertionListPopup = new JPopupMenu();
        this.assertionListPopup.add(new AddAssertionAction(assertable));
        this.assertionListPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                while (AssertionsPanel.this.assertionListPopup.getComponentCount() > 1) {
                    AssertionsPanel.this.assertionListPopup.remove(1);
                }
                if (AssertionsPanel.this.assertionListModel.getSize() == 0) {
                    return;
                }
                int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                WsdlMessageAssertion assertion = AssertionsPanel.this.assertionListModel.getAssertionAt(ix);
                ActionSupport.addActions(assertion.getActions(), AssertionsPanel.this.assertionListPopup);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.assertionList.setComponentPopupMenu(this.assertionListPopup);
        this.assertionList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int ix = AssertionsPanel.this.assertionList.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                Object obj = AssertionsPanel.this.assertionList.getModel().getElementAt(ix);
                if (obj instanceof WsdlMessageAssertion) {
                    WsdlMessageAssertion assertion = (WsdlMessageAssertion)obj;
                    if (assertion.isConfigurable()) {
                        assertion.configure();
                    }
                    return;
                }
                if (obj instanceof AssertionError) {
                    AssertionError error = (AssertionError)obj;
                    if (error.getLineNumber() >= 0) {
                        AssertionsPanel.this.selectError(error);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.add((Component)new JScrollPane(this.assertionList), "Center");
    }

    public void setEnabled(boolean enabled) {
        this.assertionList.setEnabled(enabled);
    }

    protected void selectError(AssertionError error) {
    }

    public void release() {
        this.assertionListModel.release();
    }

    private class AssertionListModel
    extends AbstractListModel
    implements PropertyChangeListener,
    AssertionsListener {
        private List<Object> items = new ArrayList<Object>();

        public AssertionListModel() {
            this.init();
        }

        public int getSize() {
            return this.items.size();
        }

        public Object getElementAt(int index) {
            return index >= this.items.size() ? null : this.items.get(index);
        }

        public WsdlMessageAssertion getAssertionAt(int index) {
            Object object = this.items.get(index);
            while (object instanceof AssertionError && index > 0) {
                object = this.items.get(--index);
            }
            return (WsdlMessageAssertion)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                this.release();
                this.init();
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }

        private void init() {
            AssertionsPanel.this.assertable.addAssertionsListener(this);
            for (int c = 0; c < AssertionsPanel.this.assertable.getAssertionCount(); ++c) {
                WsdlMessageAssertion assertion = AssertionsPanel.this.assertable.getAssertionAt(c);
                this.addAssertion(assertion);
            }
        }

        public void release() {
            this.items.clear();
            for (int c = 0; c < AssertionsPanel.this.assertable.getAssertionCount(); ++c) {
                WsdlMessageAssertion assertion = AssertionsPanel.this.assertable.getAssertionAt(c);
                assertion.removePropertyChangeListener(this);
            }
            AssertionsPanel.this.assertable.removeAssertionsListener(this);
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.refresh();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AssertionListModel.this.refresh();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assertionAdded(WsdlMessageAssertion assertion) {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                int sz = this.getSize();
                this.addAssertion(assertion);
                this.fireIntervalAdded(this, sz, this.items.size() - 1);
            }
        }

        private void addAssertion(WsdlMessageAssertion assertion) {
            assertion.addPropertyChangeListener(this);
            this.items.add(assertion);
            AssertionError[] errors = assertion.getErrors();
            if (errors != null) {
                for (int i = 0; i < errors.length; ++i) {
                    this.items.add(errors[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assertionRemoved(WsdlMessageAssertion assertion) {
            AssertionListModel assertionListModel = this;
            synchronized (assertionListModel) {
                int ix = this.items.indexOf(assertion);
                if (ix == -1) {
                    return;
                }
                assertion.removePropertyChangeListener(this);
                this.items.remove(ix);
                this.fireIntervalRemoved(this, ix, ix);
                while (ix < this.items.size() && this.items.get(ix) instanceof AssertionError) {
                    this.items.remove(ix);
                    this.fireIntervalRemoved(this, ix, ix);
                }
            }
        }
    }

    private static class AssertionCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private AssertionCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof WsdlMessageAssertion) {
                WsdlMessageAssertion assertion = (WsdlMessageAssertion)value;
                this.setText(assertion.getName() + " - " + assertion.getStatus().toString());
                this.setIcon(assertion.getIcon());
            } else if (value instanceof AssertionError) {
                AssertionError assertion = (AssertionError)value;
                this.setText(" -> " + assertion.toString());
                this.setIcon(null);
            } else if (value instanceof String) {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

