/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.config.OperationConfig;
import com.eviware.soapui.config.PartsConfig;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.submit.transports.http.AttachmentDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MultipartAttachmentDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.XOPPartDataSource;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlValidator;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentUtils {
    private static final Logger log = Logger.getLogger(AttachmentUtils.class);
    private static final QName XMLMIME_CONTENTTYPE_200505 = new QName("http://www.w3.org/2005/05/xmlmime", "contentType");
    private static final QName XMLMIME_CONTENTTYPE_200411 = new QName("http://www.w3.org/2004/11/xmlmime", "contentType");
    private static final QName SWAREF_QNAME = new QName("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef");
    public static final QName XOP_HREF_QNAME = new QName("href");
    private static final QName XOP_INCLUDE_QNAME = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    public static final String ROOTPART_SOAPUI_ORG = "<rootpart@soapui.org>";
    public static final Session JAVAMAIL_SESSION = Session.getDefaultInstance((Properties)new Properties());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareMessagePart(AttachmentContainer container, MimeMultipart mp, MessageXmlPart messagePart, StringToStringMap contentIds) throws Exception, MessagingException {
        boolean isXop = false;
        XmlCursor cursor = messagePart.newCursor();
        try {
            while (!cursor.isEnddoc()) {
                if (cursor.isContainer()) {
                    if (messagePart.isAttachmentPart()) {
                        String href = cursor.getAttributeText(XOP_HREF_QNAME);
                        if (href != null && href.length() > 0) {
                            contentIds.put(messagePart.getPart().getName(), href);
                        }
                        break;
                    }
                    SchemaType schemaType = cursor.getObject().schemaType();
                    if (AttachmentUtils.isSwaRefType(schemaType)) {
                        String textContent = cursor.getTextValue();
                        if (textContent.startsWith("cid:")) {
                            textContent = textContent.substring(4);
                            try {
                                new URI(textContent);
                                contentIds.put(textContent, textContent);
                            }
                            catch (RuntimeException e) {
                                String contentId = textContent + "@soapui.org";
                                cursor.setTextValue("cid:" + contentId);
                                contentIds.put(textContent, contentId);
                            }
                        }
                    } else if (AttachmentUtils.isXopInclude(schemaType)) {
                        String contentId = cursor.getAttributeText(new QName("href"));
                        if (contentId != null && contentId.length() > 0) {
                            contentIds.put(contentId, contentId);
                            isXop = true;
                            Attachment[] attachments = container.getAttachmentsForPart(contentId);
                            if (attachments.length == 1) {
                                String contentType;
                                XmlCursor cur = cursor.newCursor();
                                if (cur.toParent() && (contentType = AttachmentUtils.getXmlMimeContentType(cur)) != null && contentType.length() > 0) {
                                    attachments[0].setContentType(contentType);
                                }
                                cur.dispose();
                            }
                        }
                    } else if (SchemaUtils.isBinaryType(schemaType)) {
                        String xmimeContentType = AttachmentUtils.getXmlMimeContentType(cursor);
                        String textContent = cursor.getTextValue();
                        Attachment attachment = null;
                        boolean isXopAttachment = false;
                        if (textContent.startsWith("file:")) {
                            String filename = textContent.substring(5);
                            if (xmimeContentType == null) {
                                AttachmentUtils.inlineData(cursor, schemaType, new FileInputStream(filename));
                            } else if (container.isMtomEnabled()) {
                                PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
                                part.setDataHandler(new DataHandler((DataSource)new XOPPartDataSource(new File(filename), xmimeContentType, schemaType)));
                                part.setContentID("<" + filename + ">");
                                mp.addBodyPart((BodyPart)part);
                                isXopAttachment = true;
                            }
                        } else if (textContent.startsWith("cid:")) {
                            Attachment[] attachments = container.getAttachmentsForPart(textContent = textContent.substring(4));
                            if (attachments.length == 1) {
                                attachment = attachments[0];
                            } else if (attachments.length > 1) {
                                attachment = AttachmentUtils.buildMulitpartAttachment(attachments);
                            }
                            isXopAttachment = xmimeContentType != null;
                            contentIds.put(textContent, textContent);
                        } else if (container.isMtomEnabled() && xmimeContentType != null) {
                            PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
                            part.setDataHandler(new DataHandler((DataSource)new XOPPartDataSource(textContent, xmimeContentType, schemaType)));
                            textContent = "http://www.soapui.org/" + System.nanoTime();
                            part.setContentID("<" + textContent + ">");
                            mp.addBodyPart((BodyPart)part);
                            isXopAttachment = true;
                        }
                        if (isXopAttachment && container.isMtomEnabled()) {
                            AttachmentUtils.buildXopInclude(cursor, textContent);
                            isXop = true;
                        } else if (attachment != null) {
                            AttachmentUtils.inlineAttachment(cursor, schemaType, attachment);
                        }
                    }
                }
                cursor.toNextToken();
            }
        }
        finally {
            cursor.dispose();
        }
        return isXop;
    }

    private static void inlineAttachment(XmlCursor cursor, SchemaType schemaType, Attachment attachment) throws IOException {
        AttachmentUtils.inlineData(cursor, schemaType, attachment.getInputStream());
    }

    private static void inlineData(XmlCursor cursor, SchemaType schemaType, InputStream in) throws IOException {
        String content = null;
        byte[] data = Tools.readAll(in, -1L).toByteArray();
        if (SchemaUtils.isInstanceOf(schemaType, XmlHexBinary.type)) {
            content = new String(Hex.encodeHex((byte[])data));
        } else if (SchemaUtils.isInstanceOf(schemaType, XmlBase64Binary.type)) {
            content = new String(Base64.encodeBase64((byte[])data));
        }
        XmlCursor c = cursor.newCursor();
        c.setTextValue(content);
        c.dispose();
    }

    private static void buildXopInclude(XmlCursor cursor, String contentId) {
        XmlCursor c = cursor.newCursor();
        c.removeXmlContents();
        c.toFirstContentToken();
        c.beginElement(XOP_INCLUDE_QNAME);
        c.insertAttributeWithValue(XOP_HREF_QNAME, "cid:" + contentId);
        c.toNextSibling();
        c.removeXml();
        c.dispose();
    }

    private static Attachment buildMulitpartAttachment(Attachment[] attachments) {
        System.out.println("buildMulitpartAttachment(Attachment[] attachments) not implemented!");
        return null;
    }

    public static String buildRootPartContentType(String action, SoapVersion soapVersion) {
        return "application/xop+xml; charset=UTF-8; type=\"" + soapVersion.getContentType() + "; action=\\\"" + action + "\\\"\"";
    }

    public static String buildMTOMContentType(String header, String action, SoapVersion soapVersion) {
        if (action == null) {
            action = "";
        }
        int ix = header.indexOf("boundary");
        return "multipart/related; type=\"application/xop+xml\"; start=\"<rootpart@soapui.org>\"; startinfo=\"" + soapVersion.getContentType() + "; action=\\\"" + action + "\\\"\"; " + header.substring(ix);
    }

    public static boolean isSwaRefType(SchemaType schemaType) {
        return schemaType.getName() != null && schemaType.getName().equals(SWAREF_QNAME);
    }

    public static String getXmlMimeContentType(XmlCursor cursor) {
        String attributeText = cursor.getAttributeText(XMLMIME_CONTENTTYPE_200411);
        if (attributeText == null) {
            attributeText = cursor.getAttributeText(XMLMIME_CONTENTTYPE_200505);
        }
        return attributeText;
    }

    public static boolean isXopInclude(SchemaType schemaType) {
        return XOP_INCLUDE_QNAME.equals(schemaType.getName());
    }

    public static List<WsdlAttachmentPart> extractAttachmentParts(WsdlOperation operation, String requestContent, boolean addAnonymous) {
        ArrayList<WsdlAttachmentPart> result = new ArrayList<WsdlAttachmentPart>();
        PartsConfig requestParts = ((OperationConfig)operation.getConfig()).getRequestParts();
        if (requestParts != null) {
            for (PartsConfig.Part part : requestParts.getPartList()) {
                WsdlAttachmentPart attachmentPart = new WsdlAttachmentPart(part.getName(), part.getContentTypeList());
                attachmentPart.setType(Attachment.AttachmentType.MIME);
                result.add(attachmentPart);
            }
        }
        if (requestContent.length() > 0) {
            WsdlContext wsdlContext = operation.getInterface().getWsdlContext();
            WsdlValidator validator = new WsdlValidator(wsdlContext);
            try {
                XmlObject[] requestDocuments;
                for (XmlObject partDoc : requestDocuments = validator.getInputParts(requestContent, operation.getName())) {
                    XmlCursor cursor = partDoc.newCursor();
                    while (!cursor.isEnddoc()) {
                        SchemaType schemaType;
                        if (cursor.isContainer() && (schemaType = cursor.getObject().schemaType()) != null) {
                            WsdlAttachmentPart attachmentPart;
                            String contentId;
                            String attributeText = AttachmentUtils.getXmlMimeContentType(cursor);
                            if (SchemaUtils.isBinaryType(schemaType)) {
                                contentId = cursor.getTextValue();
                                if (contentId.startsWith("cid:")) {
                                    attachmentPart = new WsdlAttachmentPart(contentId.substring(4), attributeText);
                                    attachmentPart.setType(attributeText == null ? Attachment.AttachmentType.CONTENT : Attachment.AttachmentType.XOP);
                                    result.add(attachmentPart);
                                }
                            } else if (AttachmentUtils.isXopInclude(schemaType)) {
                                contentId = cursor.getAttributeText(new QName("href"));
                                if (contentId != null && contentId.length() > 0) {
                                    attachmentPart = new WsdlAttachmentPart(contentId, attributeText);
                                    attachmentPart.setType(Attachment.AttachmentType.XOP);
                                    result.add(attachmentPart);
                                }
                            } else if (AttachmentUtils.isSwaRefType(schemaType) && (contentId = cursor.getTextValue()).startsWith("cid:")) {
                                attachmentPart = new WsdlAttachmentPart(contentId.substring(4), attributeText);
                                attachmentPart.setType(Attachment.AttachmentType.SWAREF);
                                result.add(attachmentPart);
                            }
                        }
                        cursor.toNextToken();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn((Object)e.toString());
            }
        }
        if (addAnonymous) {
            result.add(new WsdlAttachmentPart());
        }
        return result;
    }

    public static void addMimeParts(AttachmentContainer container, MimeMultipart mp, StringToStringMap contentIds) throws MessagingException {
        if (!container.isMultipartEnabled()) {
            for (int c = 0; c < container.getAttachmentCount(); ++c) {
                Attachment att = container.getAttachmentAt(c);
                AttachmentUtils.addSingleAttachment(mp, contentIds, att);
            }
        } else {
            HashMap attachmentsMap = new HashMap();
            for (int c = 0; c < container.getAttachmentCount(); ++c) {
                Attachment att = container.getAttachmentAt(c);
                String partName = att.getPart();
                if (!attachmentsMap.containsKey(partName)) {
                    attachmentsMap.put(partName, new ArrayList());
                }
                ((List)attachmentsMap.get(partName)).add(att);
            }
            Iterator i = attachmentsMap.keySet().iterator();
            while (i.hasNext()) {
                List attachments = (List)attachmentsMap.get(i.next());
                if (attachments.size() == 1) {
                    Attachment att = (Attachment)attachments.get(0);
                    AttachmentUtils.addSingleAttachment(mp, contentIds, att);
                    continue;
                }
                if (attachments.size() <= 1) continue;
                AttachmentUtils.addMultipartAttachment(mp, contentIds, attachments);
            }
        }
    }

    public static void addMultipartAttachment(MimeMultipart mp, StringToStringMap contentIds, List<Attachment> attachments) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("mixed");
        for (int c = 0; c < attachments.size(); ++c) {
            Attachment att = attachments.get(c);
            String contentType = att.getContentType();
            MimeBodyPart part = contentType.startsWith("text/") ? new MimeBodyPart() : new PreencodedMimeBodyPart("binary");
            part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(att)));
            AttachmentUtils.initPartContentId(contentIds, part, att, false);
            multipart.addBodyPart((BodyPart)part);
        }
        PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
        part.setDataHandler(new DataHandler((DataSource)new MultipartAttachmentDataSource(multipart)));
        Attachment attachment = attachments.get(0);
        AttachmentUtils.initPartContentId(contentIds, (MimeBodyPart)part, attachment, true);
        mp.addBodyPart((BodyPart)part);
    }

    public static void initPartContentId(StringToStringMap contentIds, MimeBodyPart part, Attachment attachment, boolean isMultipart) throws MessagingException {
        String partName = attachment.getPart();
        String contentID = attachment.getContentID();
        if (contentID != null) {
            int ix = contentID.indexOf(32);
            if (ix != -1) {
                part.setContentID("<" + (isMultipart ? contentID.substring(ix + 1) : contentID.substring(0, ix)) + ">");
            } else {
                part.setContentID(contentID);
            }
        } else if (partName != null && !partName.equals("<anonymous>")) {
            if (contentIds.containsKey(partName)) {
                part.setContentID("<" + (String)contentIds.get(partName) + ">");
            } else {
                part.setContentID("<" + partName + "=" + System.nanoTime() + "@soapui.org>");
            }
        }
    }

    public static void addSingleAttachment(MimeMultipart mp, StringToStringMap contentIds, Attachment att) throws MessagingException {
        String contentType = att.getContentType();
        MimeBodyPart part = contentType.startsWith("text/") ? new MimeBodyPart() : new PreencodedMimeBodyPart("binary");
        part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(att)));
        AttachmentUtils.initPartContentId(contentIds, part, att, false);
        mp.addBodyPart((BodyPart)part);
    }
}

