/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.transport;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.transport.InVMException;
import org.jboss.internal.soa.esb.couriers.transport.InVMTransport;
import org.jboss.internal.soa.esb.couriers.tx.InVMXAResource;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.message.Message;

public class InVMTemporaryTransport {
    private static final Logger LOGGER = Logger.getLogger(InVMTemporaryTransport.class);
    private static final long DEFAULT_EXPIRY_TIME = 300000L;
    private final long expiryTime;
    private final Map<String, InVMEntry> serviceIdToEntry = new HashMap<String, InVMEntry>();
    private final LinkedHashSet<InVMQueueEntry> orderedEntries = new LinkedHashSet();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile ReaperThread reaperThread;
    private static InVMTemporaryTransport instance = new InVMTemporaryTransport();

    public InVMTemporaryTransport() {
        PropertyManager prop = ModulePropertyManager.getPropertyManager("transports");
        String value = prop.getProperty("org.jboss.soa.esb.invm.expiryTime");
        long expiryTime = 300000L;
        if (value != null) {
            try {
                long parsedExpiryTime = Long.parseLong(value);
                if (parsedExpiryTime > 0L) {
                    expiryTime = parsedExpiryTime;
                } else {
                    LOGGER.warn((Object)"Invalid InVM expiry time, using default");
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.warn((Object)"Failed to parse InVM expiry time, using default");
            }
        }
        this.expiryTime = expiryTime;
        LOGGER.debug((Object)("InVM expiry time set to " + expiryTime));
    }

    public static InVMTemporaryTransport getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(InVMEpr inVMEpr, Message message) throws InVMException {
        InVMEntry entry;
        String serviceId = inVMEpr.getAddr().getAddress();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Delivering message to " + serviceId));
        }
        Object addedObject = InVMTransport.toDeliveryObject(message, inVMEpr.getPassByValue());
        if (InVMTransport.isTransactional()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Delivering transactional message to " + serviceId));
            }
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            try {
                txStrategy.enlistResource(new InVMXAResource(inVMEpr, addedObject, InVMXAResource.Operation.INSERT));
            }
            catch (TransactionStrategyException tse) {
                throw new InVMException("Unexpected error enlisting transaction resource", tse);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Delivering message direct to " + serviceId + " queue"));
        }
        long lockstep = inVMEpr.getLockstep() ? inVMEpr.getLockstepWaitTime() : 0L;
        this.acquireReadLock();
        try {
            entry = this.getEntry(serviceId);
            entry.incDelivery();
        }
        finally {
            this.releaseReadLock();
        }
        this.deliver(entry, addedObject, lockstep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message pickup(InVMEpr inVMEpr, long millis) throws InVMException {
        InVMEntry entry;
        String serviceId = inVMEpr.getAddr().getAddress();
        this.acquireReadLock();
        try {
            entry = this.getEntry(serviceId);
            entry.incPickup();
        }
        finally {
            this.releaseReadLock();
        }
        InVMQueueEntry queueEntry = entry.pickup(millis);
        this.clearEntry(entry, queueEntry);
        if (queueEntry != null) {
            Object msgObject;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Pickup of message from " + serviceId));
            }
            if ((msgObject = queueEntry.getValue()) != null) {
                Message message = InVMTransport.fromDeliveryObject(msgObject, inVMEpr.getPassByValue());
                if (InVMTransport.isTransactional()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Pickup enlisting transactional resource for service " + serviceId));
                    }
                    TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
                    try {
                        txStrategy.enlistResource(new InVMXAResource(inVMEpr, msgObject, InVMXAResource.Operation.REMOVE));
                    }
                    catch (TransactionStrategyException tse) {
                        throw new InVMException("Unexpected error enlisting transaction resource", tse);
                    }
                }
                return message;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverTx(InVMEpr inVMEpr, Object msgObject) throws InVMException {
        InVMEntry entry;
        String serviceId = inVMEpr.getAddr().getAddress();
        this.acquireReadLock();
        try {
            entry = this.getEntry(serviceId);
            entry.incDelivery();
        }
        finally {
            this.releaseReadLock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Transactional redelivery of message to " + serviceId));
        }
        this.deliver(entry, msgObject, 0L);
    }

    public void startReaper() {
        LOGGER.info((Object)"Starting reaper thread");
        this.reaperThread = new ReaperThread();
        this.reaperThread.start();
    }

    public void stopReaper() {
        ReaperThread currentReaperThread = this.reaperThread;
        this.reaperThread = null;
        if (currentReaperThread != null) {
            LOGGER.info((Object)"Stopping reaper thread");
            currentReaperThread.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(InVMEntry entry, Object value, long lockstep) throws InVMException {
        InVMQueueEntry queueEntry = entry.deliver(value, lockstep, this.expiryTime);
        if (entry.isActive(queueEntry)) {
            ReaperThread currentReaperThread;
            boolean notifyReaper;
            this.acquireWriteLock();
            try {
                if (entry.isActive(queueEntry)) {
                    notifyReaper = this.orderedEntries.isEmpty();
                    this.orderedEntries.add(queueEntry);
                } else {
                    notifyReaper = false;
                }
            }
            finally {
                this.releaseWriteLock();
            }
            if (notifyReaper && (currentReaperThread = this.reaperThread) != null) {
                currentReaperThread.entriesUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServiceIdToEntrySize() {
        this.acquireReadLock();
        try {
            int n = this.serviceIdToEntry.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrderedEntriesSize() {
        this.acquireReadLock();
        try {
            int n = this.orderedEntries.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void acquireReadLock() {
        this.lock.readLock().lock();
    }

    private void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    private void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    private void promoteToWriteLock() {
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
    }

    private void demoteToReadLock() {
        this.lock.readLock().lock();
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InVMEntry getEntry(String serviceId) {
        InVMEntry entry = this.serviceIdToEntry.get(serviceId);
        if (entry == null) {
            this.promoteToWriteLock();
            try {
                entry = new InVMEntry(serviceId);
                InVMEntry current = this.serviceIdToEntry.put(serviceId, entry);
                if (current != null && current != entry) {
                    entry = current;
                    this.serviceIdToEntry.put(serviceId, current);
                }
            }
            finally {
                this.demoteToReadLock();
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEntry(InVMEntry entry, InVMQueueEntry queueEntry) {
        this.acquireWriteLock();
        try {
            String serviceId;
            InVMEntry current;
            if (queueEntry != null) {
                this.orderedEntries.remove(queueEntry);
            }
            if (entry.isFree() && (current = this.serviceIdToEntry.remove(serviceId = entry.getServiceId())) != null && current != entry) {
                this.serviceIdToEntry.put(serviceId, current);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private class ReaperThread
    extends Thread {
        private AtomicBoolean shutdown = new AtomicBoolean();
        private Lock lock = new ReentrantLock();
        private Condition notifyCondition = this.lock.newCondition();
        private boolean notify;

        private ReaperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.shutdown.get()) {
                long nextExpiry;
                block12: {
                    nextExpiry = Long.MAX_VALUE;
                    InVMTemporaryTransport.this.acquireWriteLock();
                    try {
                        Iterator orderedEntriesIter = InVMTemporaryTransport.this.orderedEntries.iterator();
                        if (!orderedEntriesIter.hasNext()) break block12;
                        long now = System.currentTimeMillis();
                        do {
                            InVMQueueEntry queueEntry;
                            long expiryTime;
                            if ((expiryTime = (queueEntry = (InVMQueueEntry)orderedEntriesIter.next()).getExpiryTime()) > now) {
                                nextExpiry = expiryTime;
                                break;
                            }
                            orderedEntriesIter.remove();
                            InVMEntry entry = queueEntry.getEntry();
                            entry.expire(queueEntry);
                            InVMTemporaryTransport.this.clearEntry(queueEntry.getEntry(), null);
                        } while (orderedEntriesIter.hasNext());
                    }
                    finally {
                        InVMTemporaryTransport.this.releaseWriteLock();
                    }
                }
                LOGGER.debug((Object)("Reaper thread next expiry: " + nextExpiry));
                this.lock.lock();
                try {
                    long delay;
                    if (!this.notify && !this.shutdown.get() && (delay = nextExpiry - System.currentTimeMillis()) > 0L) {
                        try {
                            this.notifyCondition.await(delay, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    this.notify = false;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void entriesUpdated() {
            this.lock.lock();
            try {
                this.notify = true;
                this.notifyCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            this.shutdown.set(true);
            this.lock.lock();
            try {
                this.notifyCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class InVMEntry {
        private final Lock lock = new ReentrantLock();
        private final Condition waitingCondition = this.lock.newCondition();
        private final Queue<InVMQueueEntry> entries = new LinkedList<InVMQueueEntry>();
        private final String serviceId;
        private int numWaiters;
        private int numDeliveries;
        private int numPickups;

        InVMEntry(String serviceId) {
            this.serviceId = serviceId;
        }

        String getServiceId() {
            return this.serviceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incDelivery() {
            this.lock.lock();
            try {
                ++this.numDeliveries;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incPickup() {
            this.lock.lock();
            try {
                ++this.numPickups;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isFree() {
            this.lock.lock();
            try {
                boolean bl = this.numDeliveries == 0 && this.numPickups == 0 && this.numWaiters == 0 && this.entries.size() == 0;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InVMQueueEntry deliver(Object value, long lockstep, long expiryTime) throws InVMException {
            this.lock.lock();
            try {
                --this.numDeliveries;
                Condition condition = lockstep > 0L ? this.lock.newCondition() : null;
                InVMQueueEntry queueEntry = new InVMQueueEntry(this, value, condition, System.currentTimeMillis() + expiryTime);
                if (!this.entries.offer(queueEntry)) {
                    throw new InVMException("Failed to append message to InVM queue");
                }
                if (this.numWaiters > 0) {
                    this.waitingCondition.signal();
                }
                if (condition != null) {
                    try {
                        condition.await(lockstep, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn((Object)("Waiting delivery thread interupted while waiting on message pickup on InVM queue '" + this.serviceId + "'.  Exiting pickup wait state."));
                    }
                }
                InVMQueueEntry inVMQueueEntry = queueEntry;
                return inVMQueueEntry;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InVMQueueEntry pickup(long millis) throws InVMException {
            long end = System.currentTimeMillis() + millis;
            this.lock.lock();
            try {
                InVMQueueEntry entry;
                long delay;
                --this.numPickups;
                if (this.entries.isEmpty() && (delay = end - System.currentTimeMillis()) > 0L) {
                    ++this.numWaiters;
                    try {
                        this.waitingCondition.await(delay, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ioe) {
                    }
                    finally {
                        --this.numWaiters;
                    }
                }
                if ((entry = this.entries.poll()) != null) {
                    entry.setInactive();
                    Condition condition = entry.getCondition();
                    if (condition != null) {
                        condition.signal();
                    }
                    InVMQueueEntry inVMQueueEntry = entry;
                    return inVMQueueEntry;
                }
                InVMQueueEntry inVMQueueEntry = null;
                return inVMQueueEntry;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isActive(InVMQueueEntry queueEntry) {
            this.lock.lock();
            try {
                boolean bl = !queueEntry.isInactive();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void expire(InVMQueueEntry queueEntry) {
            this.lock.lock();
            try {
                if (this.entries.remove(queueEntry)) {
                    queueEntry.setInactive();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class InVMQueueEntry {
        private final InVMEntry entry;
        private final Object value;
        private final Condition condition;
        private final long expiry;
        private boolean inactive;

        InVMQueueEntry(InVMEntry entry, Object value, Condition condition, long expiry) {
            this.entry = entry;
            this.value = value;
            this.condition = condition;
            this.expiry = expiry;
        }

        InVMEntry getEntry() {
            return this.entry;
        }

        Object getValue() {
            return this.value;
        }

        Condition getCondition() {
            return this.condition;
        }

        long getExpiryTime() {
            return this.expiry;
        }

        void setInactive() {
            this.inactive = true;
        }

        boolean isInactive() {
            return this.inactive;
        }
    }
}

