/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.serialized;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.jboss.internal.soa.esb.message.format.serialized.AttachmentImpl;
import org.jboss.internal.soa.esb.message.format.serialized.BodyImpl;
import org.jboss.internal.soa.esb.message.format.serialized.ContextImpl;
import org.jboss.internal.soa.esb.message.format.serialized.FaultImpl;
import org.jboss.internal.soa.esb.message.format.serialized.HeaderImpl;
import org.jboss.internal.soa.esb.message.format.serialized.PropertiesImpl;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.message.Attachment;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.ByReferenceMessage;
import org.jboss.soa.esb.message.Context;
import org.jboss.soa.esb.message.Fault;
import org.jboss.soa.esb.message.Header;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.util.ContextObjectInputStream;

public class MessageImpl
implements ByReferenceMessage,
Externalizable {
    private static final long serialVersionUID = 0L;
    private HeaderImpl _theHeader = new HeaderImpl();
    private ContextImpl _theContext;
    private BodyImpl _theBody;
    private FaultImpl _theFault;
    private AttachmentImpl _theAttachment;
    private Properties _theProperties;

    public MessageImpl() {
        this._theContext = new ContextImpl();
        this._theBody = new BodyImpl();
        this._theFault = new FaultImpl(this._theBody);
        this._theAttachment = new AttachmentImpl();
        this._theProperties = new PropertiesImpl();
    }

    private MessageImpl(MessageImpl message) {
        Call origCall = message._theHeader.getCall();
        Call call = new Call(origCall.getTo());
        call.setAction(origCall.getAction());
        call.setFaultTo(origCall.getFaultTo());
        call.setFrom(origCall.getFrom());
        call.setMessageID(origCall.getMessageID());
        call.setRelatesTo(origCall.getRelatesTo());
        call.setReplyTo(origCall.getReplyTo());
        this._theHeader.setCall(call);
        this._theContext = new ContextImpl(message._theContext);
        this._theBody = message._theBody;
        this._theFault = message._theFault;
        this._theAttachment = message._theAttachment;
        this._theProperties = message._theProperties;
    }

    public Header getHeader() {
        return this._theHeader;
    }

    public Context getContext() {
        return this._theContext;
    }

    public Body getBody() {
        return this._theBody;
    }

    public Fault getFault() {
        return this._theFault;
    }

    public Attachment getAttachment() {
        return this._theAttachment;
    }

    public URI getType() {
        return MessageType.JAVA_SERIALIZED;
    }

    public Properties getProperties() {
        return this._theProperties;
    }

    public Message copy() throws IOException {
        ByteArrayOutputStream bostream = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(bostream);
        output.writeObject(this);
        ByteArrayInputStream bistream = new ByteArrayInputStream(bostream.toByteArray());
        ContextObjectInputStream input = new ContextObjectInputStream(bistream);
        try {
            return (MessageImpl)input.readObject();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            IOException ioe = new IOException("Unexpected exception during copying");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public String toString() {
        return "message: [ JAVA_SERIALIZED ]\n" + this._theHeader.toString() + "\n" + this._theContext.toString() + "\n" + this._theBody.toString() + "\n" + this._theFault.toString() + "\n" + this._theAttachment.toString() + "\n" + this._theProperties.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._theHeader);
        out.writeObject(this._theContext);
        out.writeObject(this._theBody);
        out.writeObject(this._theFault);
        out.writeObject(this._theAttachment);
        out.writeObject(this._theProperties);
    }

    public void readExternal(ObjectInput in) throws IOException {
        try {
            this._theHeader = (HeaderImpl)in.readObject();
            this._theContext = (ContextImpl)in.readObject();
            this._theBody = (BodyImpl)in.readObject();
            this._theFault = (FaultImpl)in.readObject();
            this._theAttachment = (AttachmentImpl)in.readObject();
            this._theProperties = (PropertiesImpl)in.readObject();
            this._theFault.setBody(this._theBody);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            IOException ioe = new IOException("Unexpected exception during readExternal");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public Message reference() {
        return new MessageImpl(this);
    }

    void replaceBody(BodyImpl body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this._theBody = body;
    }
}

