/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.cbr;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.soa.esb.actions.cbr.AbstractPropertyRulesRouter;
import org.jboss.soa.esb.actions.cbr.RoutingRule;
import org.jboss.soa.esb.services.routing.MessageRouterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexRouter
extends AbstractPropertyRulesRouter {
    @Override
    public Map<String, RoutingRule> buildRoutingMap(Properties rules) throws MessageRouterException {
        HashMap<String, RoutingRule> routingMap = new HashMap<String, RoutingRule>();
        Set<Map.Entry<Object, Object>> ruleSet = rules.entrySet();
        for (Map.Entry<Object, Object> rule : ruleSet) {
            String destinationName = (String)rule.getKey();
            String expression = (String)rule.getValue();
            routingMap.put(destinationName, new RegexRoutingRule(Pattern.compile(expression, 32)));
        }
        return routingMap;
    }

    private class RegexRoutingRule
    implements RoutingRule {
        private Pattern regexExpression;

        private RegexRoutingRule(Pattern regexExpression) {
            this.regexExpression = regexExpression;
        }

        public boolean evaluate(Object objectToTest) throws MessageRouterException {
            if (objectToTest instanceof CharSequence) {
                return this.regexExpression.matcher((CharSequence)objectToTest).matches();
            }
            RegexRouter.this.logger.debug((Object)("Unsupported Regex evaluation type '" + objectToTest.getClass().getName() + "'.  Only supports CharSequence types."));
            return false;
        }
    }
}

