/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.LifecycleUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.config.model.ModelParser;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static String getStringFromStream(InputStream is) throws Exception {
        byte[] bytes = StreamUtils.readStream(is);
        return new String(bytes, "UTF-8");
    }

    public static ManagedLifecycleController create(URL jbossEsbXml) {
        String configXml = null;
        try {
            configXml = Configuration.getStringFromStream(jbossEsbXml.openStream());
            return Configuration.create(configXml);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load jbossesb.xml file: " + jbossEsbXml, e);
        }
    }

    public static String getMep(ConfigTree listenerConfig) {
        String mep = listenerConfig.getAttribute("mep");
        if (mep != null) {
            return mep;
        }
        return "RequestResponse";
    }

    public static ManagedLifecycleController create(String configXml) {
        return Configuration.create(configXml, null);
    }

    public static ManagedLifecycleController create(String configXml, ObjectName serviceName) {
        return Configuration.create(configXml, serviceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedLifecycleController create(String configXml, ObjectName serviceName, List<ContractReferencePublisher> publishers) {
        try {
            StringReader config = new StringReader(configXml);
            if (ModelParser.getParser().validate(config)) {
                ByteArrayOutputStream listenerXml = new ByteArrayOutputStream();
                ByteArrayOutputStream gatewayXml = new ByteArrayOutputStream();
                Generator generator = new Generator(new ByteArrayInputStream(configXml.getBytes()), listenerXml, gatewayXml);
                generator.generate();
                byte[] listenerBytes = listenerXml.toByteArray();
                ByteArrayInputStream listenerIs = new ByteArrayInputStream(listenerBytes);
                ConfigTree listenerConfig = ConfigTree.fromInputStream(listenerIs);
                if (serviceName != null) {
                    listenerConfig.setAttribute("deployment", serviceName.getKeyProperty("deployment"));
                }
                List<ManagedLifecycle> instances = LifecycleUtil.getListeners(listenerConfig);
                byte[] gatewayBytes = gatewayXml.toByteArray();
                ByteArrayInputStream gatewayIs = new ByteArrayInputStream(gatewayBytes);
                ConfigTree gatewayConfig = ConfigTree.fromInputStream(gatewayIs);
                instances.addAll(LifecycleUtil.getGateways(gatewayConfig));
                ManagedLifecycleController controller = new ManagedLifecycleController(instances);
                boolean success = false;
                try {
                    ServicePublisher.addServicePublishers(controller, generator.getModel().getServicePublishers());
                    ServicePublisher.addContractReferencePublishers(controller, publishers);
                    success = true;
                }
                finally {
                    if (!success) {
                        ServicePublisher.removeServicePublishers(controller);
                    }
                }
                return controller;
            }
            throw new IllegalStateException("ESB file had validation errors.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

