/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.deployers.mc.as6.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import org.jboss.internal.soa.esb.util.StreamUtils;
//import org.jboss.vfs.MemoryFileFactory;
import org.jboss.vfs.VirtualFile;

/**
 * Util methods for interacting with JBoss VFS
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public final class VfsUtil
{
    /**
     * Protocol for VFS in-memory URLs.
     */
    private static final String IN_MEMORY_PROTOCOL = "vfsmemory";
    
    private VfsUtil() {}
    
    /**
     * Creates a new in-memory virtual file system or returns an already existing one..
     * 
     * @param url The url which of which this host property will be the root of the fs.
     * @return VirtualFile The {@link VirtualFile} that represents the root of the fs.
     * @throws IOException
     */
    /*
    public static VirtualFile createInMemoryFs(final VirtualFile inMemRootDir, final URL rootUrl) throws IOException
    {
    	
    	VirtualFile file = inMemRootDir.getChild(rootUrl);
        
    	return file;
    	//return MemoryFileFactory.createRoot(rootUrl).getRoot();
    }
    */
    
    /**
     * Will add the fileContent to the in-memory rootUrl a the location specified by filePath. 
     * </p>
     * 
     * @param rootUrl The root of the in-memory fs.
     * @param filePath The path relative to the rootUrl.
     * @param fileContent The contents of the file to add.
     * @return {@link VirtualFile} A reference to the newly created file in the in-memory file system.
     * @throws MalformedURLException
     */
    /*
    public static VirtualFile addFile(final URL rootUrl, final String filePath, final byte[] fileContent) throws MalformedURLException
    {
        final URL fileUrl = new URL(rootUrl + "/" + filePath);
        return MemoryFileFactory.putFile(fileUrl, fileContent);
    }
    */

    /**
     * A simple method that creates a new url with a protocol of 'vfsmemory'.
     * 
     * @param root Will be the name (hostname) of the root in-memory file system. 
     * @return {@link URL} An url that represents a root of an in-memory file system.
     * @throws MalformedURLException
     */
    public static URL createInMemUrl(final String root) throws MalformedURLException
    {
        return new URL(IN_MEMORY_PROTOCOL, root, "");
    }
    
    public static URL createInMemUrl(final String root, final String path) throws MalformedURLException
    {
        return new URL(IN_MEMORY_PROTOCOL, root, "/" + path);
    }
    
    public static URL createInMemUrl(final URL root, final String path) throws MalformedURLException
    {
        return new URL(IN_MEMORY_PROTOCOL, root.getHost(), root.getPath() + "/" + path);
    }
    /*
    public static void addFiles(final List<VirtualFile> files, final URL destUrl, final String subPath) throws IOException, URISyntaxException
    {
        addFiles(files, destUrl, subPath, null);
    }
    
    public static void addFiles(final List<VirtualFile> files, final URL destUrl, final String subPath, final String pathPrefix) throws IOException, URISyntaxException
    {
        for (final VirtualFile file : files)
        {
            String path = subpath(file.getPathName(), subPath, pathPrefix);
            addFile(file, destUrl, path);
        }
    }
    
    public static void addFiles(final Map<VirtualFile, String> filesToNamesMap, final URL destUrl, final String pathPrefix) throws IOException, URISyntaxException
    {
        Set<Entry<VirtualFile, String>> entrySet = filesToNamesMap.entrySet();
        for (Entry<VirtualFile, String> entry : entrySet)
        {
            VirtualFile file = entry.getKey();
            String path = entry.getValue();
            addFile(file, destUrl, pathPrefix + path);
        }
    }
    
    private static void addFile(final VirtualFile file, final URL destUrl, final String path) throws IOException
    {
        InputStream in = null;
        try
        {
            in = file.openStream();
            final URL newUrl = createInMemUrl(destUrl.getHost(), path);
            MemoryFileFactory.putFile(newUrl, StreamUtils.readStream(in));
        }
        finally
        {
            in.close();
        }
    }

*/
    
    static String subpath(final String path, final String pathName, final String pathPrefix)
    {
        if (path == null || pathName == null)
        {
            return path;
        }
        
        final int idx = path.indexOf(pathName);
        final String subpath ;
        if (idx != -1)
        {
            subpath = path.substring(idx + pathName.length());
        }
        else
        {
            subpath = path ;
        }
        if (pathPrefix == null)
        {
            return subpath;
        }
        else if (subpath.startsWith("/")) 
        {
            return pathPrefix + subpath;
        }
        else
        {
            return pathPrefix + "/" + subpath;
        }
    }
    
    static String subpath(final String path, final String pathName)
    {
        return subpath(path, pathName, null);
    }

}
