/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2009
 */
package org.jboss.internal.soa.esb.publish;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.Service;

/**
 * Base class for ContractReferencePublisher.
 * 
 * @author dward at jboss.org
 */
public abstract class AbstractContractReferencePublisher implements ContractReferencePublisher
{
	
	private final Service service;
	private final String description;
	
    private static final char[] UNSAFE_CHARS = { '%', ' ', '\"', '#', '<', '>',
        '[',  '\\', ']', '^', '`', '{', '|', '}', '~' };
	
	public AbstractContractReferencePublisher(Service service, String description)
	{
		this.service = service;
		this.description = description;
	}

	/**
	 * Encode unsafe URI characters
	 * @param unencodedStr un-encoded string
	 * @return encoded string
	 */
	public String encode(String unencodedStr) {
		String result = unencodedStr;
		
		for (char c : UNSAFE_CHARS) {
		     char [] chars = new char[1]; //convert string to individual chars
		     chars[0] = c;
		     
		     String bin = new String();
		     for(int j=0; j<chars.length; j++) {
			    bin += "%" + Integer.toHexString(chars[j]);  //convert char to hex value
		     }			
			
			
			result = result.replace((new Character(c)).toString(), bin);
		}
		
		return result;
	}
	
	
	public final Service getService()
	{
		return service;
	}
	
	public final String getDescription()
	{
		return description;
	}
	
	public final URI getServiceURI()
	{
		String endpointAddress = getEndpointAddress();
		if (endpointAddress != null)
		{
			URI uri = null;
			try
			{
				uri = new URI(encode(endpointAddress));
			}
			catch (URISyntaxException use)
			{
				use.printStackTrace();
			} 
			return uri;
		}
		return null;
	}
	
	public final URI getServiceContractURI()
	{
		String endpointAddress = getEndpointAddress();
		if (endpointAddress != null)
		{
			URI uri = null;
			try
			{
				uri = new URI(encode(endpointAddress) + "?wsdl");
			}
			catch (URISyntaxException use)
			{
				use.printStackTrace();
			} 
			return uri;
		}
		return null;
	}
	
	public abstract String getEndpointAddress();

}
