/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.soa.esb.listeners.config;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.http.HttpServletRequest;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.publish.ContractInfo;
import org.jboss.internal.soa.esb.publish.ContractPublisher;
import org.jboss.internal.soa.esb.publish.ServletContractPublisher;
import org.jboss.soa.esb.addressing.EPR;

/**
 * ServicePublisher ContractInfo cache.
 * 
 * @author dward at jboss.org
 */
public class ServicePublisherContractInfoCache
{
	
	private final Map<Key,ContractInfo> CACHE = new ConcurrentHashMap<Key,ContractInfo>();
	
	public ServicePublisherContractInfoCache() {}
	
	public synchronized ContractInfo getContractInfo(ServicePublisher servicePublisher, EPR epr)
	{
		return getContractInfo(servicePublisher, epr, null);
	}
	
	public synchronized ContractInfo getContractInfo(ServicePublisher servicePublisher, EPR epr, HttpServletRequest request)
	{
		Key key = new Key(servicePublisher, epr, request);
		ContractInfo value = CACHE.get(key);
		if (value == null)
		{
			ContractPublisher contractPublisher = servicePublisher.getContractPublisher();
			if (contractPublisher != null)
			{
				if (contractPublisher instanceof ServletContractPublisher && request != null)
				{
					value = ( (ServletContractPublisher)contractPublisher ).getContractInfo(epr, request);
				}
				else
				{
					value = contractPublisher.getContractInfo(epr);
				}
				if (value != null)
				{
					CACHE.put(key, value);
				}
			}
		}
		return value;
	}
	
	public synchronized void removeContractInfos(ServicePublisher servicePublisher)
	{
		Set<Key> keySet = CACHE.keySet();
		for (Key key : keySet)
		{
			if ( key.servicePublisher.equals(servicePublisher) )
			{
				keySet.remove(key);
			}
		}
	}
	
	private static class Key
	{

		private ServicePublisher servicePublisher;
		private EPR epr;
		private String serviceCat;
		private String serviceName;
		private String protocol;
		
		private Key(ServicePublisher servicePublisher, EPR epr, HttpServletRequest request)
		{
			AssertArgument.isNotNull(servicePublisher, "servicePublisher");
			AssertArgument.isNotNull(epr, "epr");
			this.servicePublisher = servicePublisher;
			this.epr = epr;
			serviceCat = getParameter(request, "serviceCat");
			serviceName = getParameter(request, "serviceName");
			protocol = getParameter(request, "protocol");
		}
		
		private static String getParameter(HttpServletRequest request, String name)
		{
			String value = null;
			if (request != null)
			{
				value = request.getParameter(name);
				if (value != null)
				{
					value = value.trim();
					if (value.length() == 0)
					{
						value = null;
					}
				}
			}
			return value;
		}

		// Eclipse-generated
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			Key other = (Key) obj;
			if (epr == null) {
				if (other.epr != null)
					return false;
			} else if (!epr.equals(other.epr))
				return false;
			if (protocol == null) {
				if (other.protocol != null)
					return false;
			} else if (!protocol.equals(other.protocol))
				return false;
			if (serviceCat == null) {
				if (other.serviceCat != null)
					return false;
			} else if (!serviceCat.equals(other.serviceCat))
				return false;
			if (serviceName == null) {
				if (other.serviceName != null)
					return false;
			} else if (!serviceName.equals(other.serviceName))
				return false;
			if (servicePublisher == null) {
				if (other.servicePublisher != null)
					return false;
			} else if (!servicePublisher.equals(other.servicePublisher))
				return false;
			return true;
		}
		
		// Eclipse-generated
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((epr == null) ? 0 : epr.hashCode());
			result = prime * result
					+ ((protocol == null) ? 0 : protocol.hashCode());
			result = prime * result
					+ ((serviceCat == null) ? 0 : serviceCat.hashCode());
			result = prime * result
					+ ((serviceName == null) ? 0 : serviceName.hashCode());
			result = prime
					* result
					+ ((servicePublisher == null) ? 0 : servicePublisher
							.hashCode());
			return result;
		}
		
	}

}
