/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * Adapter interface used for management through lifecycle MBean
 */
public interface ManagedLifecycleAdapter
{
    /**
     * Start the managed instance.
     * <p/>
     * This method is called to inform the managed instance that it can initialise
     * resources prior to enabling the service.
     */
    public void start()
        throws ManagedLifecycleException ;

    /**
     * Stop the managed instance.
     * <p/>
     * This method is called to inform the managed instance that it must disable
     * resources associated with the running service.  The service may choose to
     * disable the resources asynchronously provided that any subsequent call to
     * {@link #start()} or {@link #destroy()} blocks until these resources have been
     * disabled. 
     */
    public void stop()
        throws ManagedLifecycleException ;

    /**
     * Get the state of the managed instance.
     * @return The managed instance state.
     */
    public ManagedLifecycleState getState() ;

    /**
     * Get the configuration assoicated with the ManagedLifecycle.
     * @return Configuration.
     */
    public ConfigTree getConfig();
}