/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.http;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.principals.User;

/**
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class JbrHttpSecurityInfoExtractor implements SecurityInfoExtractor<Map<String,Object>>
{
	private Logger log = Logger.getLogger(JbrHttpSecurityInfoExtractor.class);
	
	public static final String USERNAME_KEY = "http.basic.username";
	public static final String PASSWORD_KEY = "http.basic.password";
	
	public AuthenticationRequest extractSecurityInfo( final Map<String,Object> request )
	{
		AuthenticationRequest authRequest = null;
		String username = (String) request.get(USERNAME_KEY);
		if ( username != null )
		{
			User user = new User((String)username);
			Set<Object> credentials = new HashSet<Object>();
			
			String passwd = (String) request.get(PASSWORD_KEY);
			if ( passwd != null )
			{
    			credentials.add(passwd.toCharArray());
    			Object remove = request.remove(PASSWORD_KEY);
    			if ( remove == null )
    			{ 
    				log.warn("Could not remove the password from the request map");
    			}
			}
			
			authRequest = new AuthenticationRequestImpl.Builder( user, credentials ).build();
		}
		return authRequest;
	}

}
