/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.common.tests.utils;

import java.util.Properties;

import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.helpers.NamingContextPool;

public class DrainQueuesAndTopics
{
	private Logger log = Logger.getLogger( DrainQueuesAndTopics.class );
	
	private static final int	  MAX_TIMES_NOMSG = 10;
 
  public DrainQueuesAndTopics() throws Exception
  {
	  purgeQueueTopic("queue/A");
	  purgeQueueTopic("queue/B");
	  purgeQueueTopic("topic/testTopic");
  } //__________________________________
  
  public int purgeQueueTopic(String p_sName) throws Exception
  { 
	int iRet = 0;
	log.debug(p_sName);
	MessageConsumer oCns = null;
	switch(p_sName.toLowerCase().charAt(0))
	{	case 't' : oCns = getTopic(p_sName);	break;
		case 'q' : oCns = getQueue(p_sName);	break;
	}
	if (null==oCns)
		return 0;
	
	for (int iNoRcv=0; iNoRcv < MAX_TIMES_NOMSG; )
	{	Message oMsg = oCns.receive(200);
		if (null==oMsg)
		{	iNoRcv++;
			log.debug(".");
			continue;
		}
		iRet++;
		dumpMessage(oMsg);
		iNoRcv = 0;
	}
	log.debug("");
	return iRet;
  } //__________________________________
  
  void dumpMessage(Message pM)
  {
	  log.debug(pM);
  } //__________________________________
  
  QueueReceiver getQueue(String p_sJndi) throws Exception
  {
      Properties environment = new Properties();
      environment.setProperty(Context.PROVIDER_URL, Environment.JBOSS_PROVIDER_URL);
      environment.setProperty(Context.INITIAL_CONTEXT_FACTORY, Environment.JBOSS_INITIAL_CONTEXT_FACTORY);
      environment.setProperty(Context.URL_PKG_PREFIXES, Environment.JBOSS_URL_PKG_PREFIX);
      final Context oCtx = NamingContextPool.getNamingContext(environment);
      try {
	QueueConnection oQconn = null;
	QueueSession 	oQsess = null;
	QueueConnectionFactory qcf = (QueueConnectionFactory) oCtx
		.lookup("ConnectionFactory");

	oQconn = qcf.createQueueConnection();
	oQsess = oQconn.createQueueSession(false
			,QueueSession.AUTO_ACKNOWLEDGE);
    Queue oQueue
    	= (Queue) oCtx.lookup(p_sJndi);
    QueueReceiver oRcv = oQsess.createReceiver(oQueue);
    oQconn.start();
    return oRcv;
      } finally {
          NamingContextPool.releaseNamingContext(oCtx) ;
      }
  } //__________________________________

  TopicSubscriber getTopic(String p_sJndi) throws Exception
  {
      Properties environment = new Properties();
      environment.setProperty(Context.PROVIDER_URL, Environment.JBOSS_PROVIDER_URL);
      environment.setProperty(Context.INITIAL_CONTEXT_FACTORY, Environment.JBOSS_INITIAL_CONTEXT_FACTORY);
      environment.setProperty(Context.URL_PKG_PREFIXES, Environment.JBOSS_URL_PKG_PREFIX);
      final Context oCtx = NamingContextPool.getNamingContext(environment);
      try {
	TopicConnection oTconn = null;
	TopicSession 	oTsess = null;
	TopicConnectionFactory qcf = (TopicConnectionFactory) oCtx
		.lookup("ConnectionFactory");

	oTconn = qcf.createTopicConnection();
	oTsess = oTconn.createTopicSession(false
			,QueueSession.AUTO_ACKNOWLEDGE);
    Topic oT = (Topic) oCtx.lookup(p_sJndi);
    TopicSubscriber oRcv = oTsess.createSubscriber(oT);
    oTconn.start();
    return oRcv;
      } finally {
          NamingContextPool.releaseNamingContext(oCtx) ;
      }
  } //__________________________________ 
} //____________________________________________________________________________
