package org.jboss.soa.esb.services.jbpm5.actions;

import java.util.HashMap;
import java.util.Map;

import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.MarshalException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.jbpm5.model.ProcessConstants;

import org.apache.log4j.Logger;

import org.drools.KnowledgeBase;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;

import org.drools.runtime.process.ProcessInstance;

import org.drools.runtime.StatefulKnowledgeSession;

/**
 * @author tcunning
 *
 */
public class Bpm5Callback extends AbstractBpm5Action {
    protected static Logger logger = Logger.getLogger(Bpm5Callback.class);

    public static final String JBPM_CALL_BACK_SERVICE_NAME = "JBpm5CallbackService";
    
    /**
     * Constructor.
     * @param configTree
     * @throws ConfigurationException
     */
    public Bpm5Callback(ConfigTree configTree) throws ConfigurationException {
	    super(configTree, logger) ;
	}

	/* (non-Javadoc)
	 * @see org.jboss.soa.esb.actions.ActionPipelineProcessor#process(org.jboss.soa.esb.message.Message)
	 */
	public Message process(Message message) throws ActionProcessingException {					
		// Retriever workItemId / processInstanceId from the EPR
		EPR toEpr = message.getHeader().getCall().getTo();
		PortReference portRef = toEpr.getAddr();
        Long workItemId  = Long.parseLong(portRef.getExtensionValue(ProcessConstants.WORK_ITEM_ID));
        Long processInstanceId = Long.parseLong(portRef.getExtensionValue(ProcessConstants.PROCESS_INSTANCE_ID));	
        
        final StatefulKnowledgeSession ksession = getSession(message);
		// Check to make sure the Process is still active
		ProcessInstance pi = ksession.getProcessInstance(processInstanceId);
		if (pi == null) {
			throw new ActionProcessingException("Could not find process for processInstanceId " 
					+ processInstanceId);
		} else if (ProcessInstance.STATE_ACTIVE != pi.getState()) {
			throw new ActionProcessingException("Process " + processInstanceId + " was found "
					+ "in state " + pi.getState() + ", not " + ProcessInstance.STATE_ACTIVE);
		}
		
		WorkItemManager workItemManager = (WorkItemManager) ksession.getWorkItemManager();
		WorkItem workItem = workItemManager.getWorkItem(workItemId);
		if ((workItem == null) || (workItem.getState() != WorkItem.PENDING)) {
            throw new ActionProcessingException("WorkItem " + workItemId + " is no longer active");
		}
		
		Map<String,Object> results = new HashMap<String,Object>();
		for (String name : message.getBody().getNames()) {
			results.put(name, message.getBody().get(name));
		}
		workItemManager.completeWorkItem(workItemId, results);
		
		return null;
	}
	
	/**
	 * Return the session id from the context id.
	 * @param msg message to get the session id from
	 * @return session id
	 */
	public int getSessionId(Message msg) {
		int id = -1;

		EPR toEpr = msg.getHeader().getCall().getTo();
        PortReference portRef = toEpr.getAddr();
        
        String sessionId = portRef.getExtensionValue(ProcessConstants.SESSION_ID);
        if (sessionId != null) {
            try {
                id = Integer.parseInt(sessionId);
            } catch (final NumberFormatException nfe) {
            }
        }

		try {
			if (msg.getBody().get(ProcessConstants.SESSION_ID) != null) {
				id = Integer.parseInt((String)msg.getBody().get(ProcessConstants.SESSION_ID));
			}
		} catch (Exception e) {
		}
		
		if (id == -1) {
			try {
				id = ((Integer)msg.getContext().getContext(ProcessConstants.SESSION_ID)).intValue();
			} catch (Exception e) {
			}
		}
		
		if (id == -1) {
			try {
				id = ((Integer)msg.getProperties().getProperty(ProcessConstants.SESSION_ID)).intValue();
			} catch(Exception e) {
			}
		}
		
		return id;		
	}	
}
